//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//              www.cpp - http version and cgi scanning                     //
//                                                                          //
//   Copyright (C) 1999-2001 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// based off webscan.c by Mixter
// parts from: whisker (c) .rain.forest.puppy.,
// cgiscan (c) [CKS & Fdisk], VoidEye scanner, 
// httpver (c) Shok and buffer0verfl0w security's list

#include "../nsat.h"
#include "www.h"

extern Logging Logger;

void
webscan(int s0ck)
{
  int i, numbytes;
#ifdef DARWIN
  int nl = sizeof(struct sockaddr);
#else
  unsigned int nl = sizeof(struct sockaddr);
#endif
  char buffer[170];
  char *p = NULL;
  struct sockaddr_in sin;

  sock = s0ck;

  if (getpeername(sock, (struct sockaddr *) &sin, &nl) < 0)
    return;

  strncpy(whost, inet_ntoa(sin.sin_addr), BUFSIZE);

  send(sock, I_HTGET, 16, 0);

  for (i = 0; i < 5; i++)
    {
      bzero(buffer, sizeof(buffer));
      if ((numbytes = nread(pi.timeout, sock, buffer, sizeof(buffer)-1)) < 1)
	break;
      p = strstr(buffer, "Server:");
      if (p == NULL)
	continue;
      else
	{
	  strchop(p);
          Logger.msg(L_HTTVER, I_WWW, whost, "- %s", p+8);
	}
    }
  close(sock);

  if (pi.ScanWeb < 2)
    return;

  FILE *effdee;

  counter = 0;
  while (strstr(www_cgidirs[counter].n, "EOF") == NULL)
   {
    http_prescan_dir(&www_cgidirs[counter], whost, &sin, sizeof(sin));
    counter++;
   }

  if ((!strlen(pi.WebCgiFile)) || ((effdee = fopen(pi.WebCgiFile, "r")) == NULL))
    {
      counter = 0;
      while (strstr(www_cgibin[counter], "EOF") == NULL)
	{
         int dc = 0;
         while (strstr(www_cgidirs[dc].n, "EOF") == NULL)
          if (!strncmp(www_cgibin[counter], www_cgidirs[dc].n, strlen(www_cgidirs[dc].n)) && (!www_cgidirs[dc].scan))
           goto bah1;
          else dc++;
         http_get(www_cgibin[counter], whost, &sin, sizeof(sin));
	 counter++;
	}
bah1:
     {} // x86 assembly sucks
    }
  else
    {
      char cgibuf[BUFSIZE];

      while (fgets(cgibuf, BUFSIZE, effdee) != NULL)
	{
	  if ((cgibuf[0] != '#') && (cgibuf[0] != ' ') && (isprint(cgibuf[0])))
	    {
              int dc = 0;
              while (strstr(www_cgidirs[dc].n, "EOF") == NULL)
               if (!strncmp(cgibuf, www_cgidirs[dc].n, strlen(www_cgidirs[dc].n)) && (!www_cgidirs[dc].scan))
                goto bah2;
               else dc++;
	      cgibuf[strlen(cgibuf) - 1] = '\0';
	      http_get(cgibuf, whost, &sin, sizeof(sin));
	    }
bah2:
	  memset(cgibuf, 0, BUFSIZE);
	}
      fclose(effdee);
    }
  return;

}

void
http_prescan_dir(htdirrec *d, char *whost, struct sockaddr_in *sin, int slen)
{
  char cgibuff[BUFSIZE * 3];

  memset(cgibuff, 0, BUFSIZE * 3);
  sock = socket(AF_INET, SOCK_STREAM, 0);

#ifdef EBUG
  dbug << "http_prescan_dir: '" << d->n << "'\n";
#endif

  snprintf(cgibuff, BUFSIZE * 3, I_HTGET2, d->n);

  if (connect(sock, (struct sockaddr *) sin, slen)<0)
  {
   close(sock);
   return;
  }

  send(sock, cgibuff, strlen(cgibuff), 0);
  bzero(cgibuff, sizeof(cgibuff));
  nread(pi.timeout/2, sock, cgibuff, sizeof(cgibuff) - 1);

#ifdef ACCESS_FORBIDDEN_MEANS_DIRS_EXIST
  if (y2ksucks(cgibuff) || strstr(cgibuff, "403 "))
#else
  if (y2ksucks(cgibuff))
#endif
   d->scan = 1;
  else
   d->scan = 0;

  close(sock);
}

void
http_get(char *file, char *whost, struct sockaddr_in *sin, int slen)
{
  char cgibuff[BUFSIZE * 3];

  memset(cgibuff, 0, BUFSIZE * 3);
  sock = socket(AF_INET, SOCK_STREAM, 0);

#ifdef EBUG
  dbug << "http_get: '" << file << "'\n";
#endif

  if ((pi.ScanWeb >= 3) && !strstr(file,"%"))
    {
      char evasion[BUFSIZE * 4];
      
      /* Mixed case */
      if(pi.ScanWeb > 4)
      for(unsigned int qi=0;qi < strlen(file); qi++)
      {
       if(isalpha(file[qi]) && (getrandom(0,100)<50))
       {
        if(isupper(file[qi]))
	{
	 char ble = tolower(file[qi]);
	 file[qi] = ble;
	}
	else
	{
	 char bla = toupper(file[qi]);
	 file[qi] = bla;
	}
       }
      }

      memset(evasion, 0, sizeof(evasion));
      strncpy(evasion, WEBGET, 4);
      strcat(evasion, "/");
      for (unsigned int i = 1; i < strlen(file); i++)
	{
	  char etmp[64];

	  // begin intrusion detection systems evasion
	  // just the basic substitution stuph for maximum compatibility
	  // unless ScanWeb is bigger than 3
	  if (((isalpha(file[i])) || (isspace(file[i]))))
	    sprintf(etmp, "%%%x", file[i]);
	  else if((pi.ScanWeb > 3) && (file[i] == '/'))
	    sprintf(etmp, "%%2F%%2E%%2F%%2E%%2F"); /* insert ./././ slashes */
	  else
	    sprintf(etmp, "%c", file[i]);
	    
	  strcat(evasion, etmp);
	}
	cerr << evasion << "\n";
      strcat(evasion, WEBVER);
      strncpy(cgibuff, evasion, BUFSIZE * 3);
    }
  else
    snprintf(cgibuff, BUFSIZE * 3, I_HTGET2, file);

  if (connect(sock, (struct sockaddr *) sin, slen)<0)
  {
   close(sock);
   return;
  }

  send(sock, cgibuff, strlen(cgibuff), 0);
  bzero(cgibuff, sizeof(cgibuff));
  nread(pi.timeout/2, sock, cgibuff, sizeof(cgibuff) - 1);

  if (y2ksucks(cgibuff))
    {
      Logger.msg(L_CGI, I_WWW, whost, "- %s", file);
    }
  close(sock);
}

int
y2ksucks(char *buf)
{
  if (strstr(buf, "404 "))
    return 0;
  if (strstr(buf, "400 "))
    return 0;
  if (strstr(buf, "Bad Request"))
    return 0;
  if (strstr(buf, "Not Found"))
    return 0;
  if (strstr(buf, "Error Performing"))
    return 0;

  if (strstr(buf, " 200 "))
    return 1;

  return 0;
}
