---
title: Workflow
weight: 2
aliases:
  - /contributing/workflow/
---

By participating in this project, you agree to abide our [code of conduct](https://github.com/golangci/golangci-lint?tab=coc-ov-file).

## Set up your machine

Golangci-lint is written in [Go](https://go.dev).

Prerequisites:

- `make`
- [Go](https://go.dev/doc/install)

Fork and clone [golangci-lint](https://github.com/golangci/golangci-lint) repository.

A good way of making sure everything is all right is running the following:

```bash
make build
./golangci-lint run -v
```

## Test your change

When you are satisfied with the changes, we suggest you run:

```bash
make test
```

Which runs all the linters and tests.

## Create or update parameters for docs

Add your new or updated parameters to [.golangci.next.reference.yml](https://github.com/golangci/golangci-lint/blob/HEAD/.golangci.next.reference.yml) so they will be shown in the docs

## Submit a pull request

Push your branch to your golangci-lint fork and open a pull request against the
`main` branch.

## Pull request checks

First, please, accept CLA - [CLA assistant](https://cla-assistant.io/) will make a comment on the pull request about it.

Also, we run a few checks in CI by using GitHub Actions, you can see them [here](https://github.com/golangci/golangci-lint/blob/HEAD/.github/workflows).

## New releases

First, see [our versioning policy](/docs/product/roadmap/#versioning-policy).

To make a new release create a tag `vX.Y.Z`.  
Don't forget to add zero patch version for a new minor release, e.g. `v1.99.0`.

A GitHub Action [workflow](https://github.com/golangci/golangci-lint/blob/HEAD/.github/workflows/release.yml) will start building and publishing release after that.

After making a release, you need to update GitHub [Action config](https://github.com/golangci/golangci-lint/blob/HEAD/assets/github-action-config.json) by running:

```bash
make assets/github-action-config.json
```
