/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.Font;
import java.awt.Graphics;
import java.awt.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitmapFont
extends Font<BitmapFontGlyph> {
    protected int emAscent;
    protected int emDescent;
    protected int lineAscent;
    protected int lineDescent;
    protected int xHeight;
    protected int capHeight;
    protected int lineGap;

    public BitmapFont() {
        this.emAscent = 0;
        this.emDescent = 0;
        this.lineAscent = 0;
        this.lineDescent = 0;
        this.xHeight = 0;
        this.capHeight = 0;
        this.lineGap = 0;
    }

    public BitmapFont(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.emAscent = n;
        this.emDescent = n2;
        this.lineAscent = n3;
        this.lineDescent = n4;
        this.xHeight = n5;
        this.capHeight = n6;
        this.lineGap = n7;
    }

    @Override
    public int getEmAscent() {
        return this.emAscent;
    }

    @Override
    public double getEmAscent2D() {
        return this.emAscent;
    }

    @Override
    public int getEmDescent() {
        return this.emDescent;
    }

    @Override
    public double getEmDescent2D() {
        return this.emDescent;
    }

    @Override
    public int getLineAscent() {
        return this.lineAscent;
    }

    @Override
    public double getLineAscent2D() {
        return this.lineAscent;
    }

    @Override
    public int getLineDescent() {
        return this.lineDescent;
    }

    @Override
    public double getLineDescent2D() {
        return this.lineDescent;
    }

    @Override
    public int getXHeight() {
        return this.xHeight;
    }

    @Override
    public double getXHeight2D() {
        return this.xHeight;
    }

    @Override
    public int getCapHeight() {
        return this.capHeight;
    }

    @Override
    public double getCapHeight2D() {
        return this.capHeight;
    }

    @Override
    public int getLineGap() {
        return this.lineGap;
    }

    @Override
    public double getLineGap2D() {
        return this.lineGap;
    }

    @Override
    public void setEmAscent(int n) {
        this.emAscent = n;
    }

    @Override
    public void setEmAscent2D(double d) {
        this.emAscent = (int)Math.ceil(d);
    }

    @Override
    public void setEmDescent(int n) {
        this.emDescent = n;
    }

    @Override
    public void setEmDescent2D(double d) {
        this.emDescent = (int)Math.ceil(d);
    }

    @Override
    public void setLineAscent(int n) {
        this.lineAscent = n;
    }

    @Override
    public void setLineAscent2D(double d) {
        this.lineAscent = (int)Math.ceil(d);
    }

    @Override
    public void setLineDescent(int n) {
        this.lineDescent = n;
    }

    @Override
    public void setLineDescent2D(double d) {
        this.lineDescent = (int)Math.ceil(d);
    }

    @Override
    public void setXHeight(int n) {
        this.xHeight = n;
    }

    @Override
    public void setXHeight2D(double d) {
        this.xHeight = (int)Math.ceil(d);
    }

    @Override
    public void setCapHeight(int n) {
        this.capHeight = n;
    }

    @Override
    public void setCapHeight2D(double d) {
        this.capHeight = (int)Math.ceil(d);
    }

    @Override
    public void setLineGap(int n) {
        this.lineGap = n;
    }

    @Override
    public void setLineGap2D(double d) {
        this.lineGap = (int)Math.ceil(d);
    }

    public void contractGlyphs() {
        for (BitmapFontGlyph bitmapFontGlyph : this.characters.values()) {
            bitmapFontGlyph.contract();
        }
        for (BitmapFontGlyph bitmapFontGlyph : this.namedGlyphs.values()) {
            bitmapFontGlyph.contract();
        }
    }

    public void setAscentDescent() {
        this.contractGlyphs();
        int n = this.guessBaselineAdjustment();
        if (n == 0) {
            return;
        }
        this.emAscent += n;
        this.emDescent -= n;
        this.lineAscent += n;
        this.lineDescent -= n;
        for (BitmapFontGlyph bitmapFontGlyph : this.characters.values()) {
            bitmapFontGlyph.setXY(bitmapFontGlyph.getX(), bitmapFontGlyph.getY() + n);
        }
        for (BitmapFontGlyph bitmapFontGlyph : this.namedGlyphs.values()) {
            bitmapFontGlyph.setXY(bitmapFontGlyph.getX(), bitmapFontGlyph.getY() + n);
        }
    }

    public void setXHeight() {
        this.contractGlyphs();
        int n = this.guessXHeight();
        if (n != 0) {
            this.xHeight = n;
        }
    }

    public void setCapHeight() {
        this.contractGlyphs();
        int n = this.guessCapHeight();
        if (n != 0) {
            this.capHeight = n;
        }
    }

    public Point draw(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        return this.draw(graphics, string, n, n2, n3, n4, (this.lineAscent + this.lineDescent + this.lineGap) * n3);
    }

    public Point draw(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = n;
        int n7 = n2;
        int n8 = 0;
        int n9 = string.length();
        while (n8 < n9) {
            int n10 = string.codePointAt(n8);
            n8 += Character.charCount(n10);
            if (n10 == 10 || n10 == 13) {
                n6 = n;
                n7 += n5;
                continue;
            }
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)this.characters.get(n10);
            if (bitmapFontGlyph == null) {
                bitmapFontGlyph = (BitmapFontGlyph)this.namedGlyphs.get(".notdef");
            }
            if (bitmapFontGlyph == null) continue;
            if (n6 - n + bitmapFontGlyph.getCharacterWidth() * n3 >= n4) {
                n6 = n;
                n7 += n5;
            }
            n6 = (int)((double)n6 + bitmapFontGlyph.paint(graphics, n6, n7, n3));
        }
        return new Point(n6, n7);
    }

    public Point drawAlphabet(Graphics graphics, int n, int n2, int n3, int n4) {
        return this.drawAlphabet(graphics, n, n2, n3, n4, (this.lineAscent + this.lineDescent + this.lineGap) * n3);
    }

    public Point drawAlphabet(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n;
        int n7 = n2;
        for (BitmapFontGlyph bitmapFontGlyph : this.characters.values()) {
            if (n6 - n + bitmapFontGlyph.getCharacterWidth() * n3 >= n4) {
                n6 = n;
                n7 += n5;
            }
            n6 = (int)((double)n6 + bitmapFontGlyph.paint(graphics, n6, n7, n3));
        }
        for (BitmapFontGlyph bitmapFontGlyph : this.namedGlyphs.values()) {
            if (n6 - n + bitmapFontGlyph.getCharacterWidth() * n3 >= n4) {
                n6 = n;
                n7 += n5;
            }
            n6 = (int)((double)n6 + bitmapFontGlyph.paint(graphics, n6, n7, n3));
        }
        return new Point(n6, n7);
    }
}

