/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathExtensions {
    public static final int CHORD = 1;
    public static final int OPEN = 0;
    public static final int PIE = 2;
    public static final int WIND_NON_ZERO = 1;
    public static final int WIND_EVEN_ODD = 0;
    private GeneralPath p;
    private double lcx;
    private double lx;
    private double lcy;
    private double ly;

    public PathExtensions() {
        this(new GeneralPath());
    }

    public PathExtensions(GeneralPath generalPath) {
        this.p = generalPath;
        Point2D point2D = generalPath.getCurrentPoint();
        if (point2D == null) {
            generalPath.moveTo(0.0f, 0.0f);
            this.lx = 0.0;
            this.lcx = 0.0;
            this.ly = 0.0;
            this.lcy = 0.0;
        } else {
            this.lcx = this.lx = point2D.getX();
            this.lcy = this.ly = point2D.getY();
        }
    }

    public GeneralPath getPath() {
        return this.p;
    }

    public Point2D getCurrentPoint() {
        return this.p.getCurrentPoint();
    }

    public void execute(char c, Number ... numberArray) {
        this.execute(c, Arrays.asList(numberArray));
    }

    public void execute(char c, List<? extends Number> list) {
        double d = list.size() > 0 ? list.get(0).doubleValue() : 0.0;
        double d2 = list.size() > 1 ? list.get(1).doubleValue() : 0.0;
        double d3 = list.size() > 2 ? list.get(2).doubleValue() : 0.0;
        double d4 = list.size() > 3 ? list.get(3).doubleValue() : 0.0;
        double d5 = list.size() > 4 ? list.get(4).doubleValue() : 0.0;
        double d6 = list.size() > 5 ? list.get(5).doubleValue() : 0.0;
        double d7 = list.size() > 6 ? list.get(6).doubleValue() : 0.0;
        switch (c) {
            case 'M': {
                this.moveTo(d, d2);
                break;
            }
            case 'm': {
                this.moveTo(d + this.lx, d2 + this.ly);
                break;
            }
            case 'H': {
                this.horizTo(d);
                break;
            }
            case 'h': {
                this.horizTo(d + this.lx);
                break;
            }
            case 'V': {
                this.vertTo(d);
                break;
            }
            case 'v': {
                this.vertTo(d + this.ly);
                break;
            }
            case 'L': {
                this.lineTo(d, d2);
                break;
            }
            case 'l': {
                this.lineTo(d + this.lx, d2 + this.ly);
                break;
            }
            case 'Q': {
                this.quadTo(d, d2, d3, d4);
                break;
            }
            case 'q': {
                this.quadTo(d + this.lx, d2 + this.ly, d3 + this.lx, d4 + this.ly);
                break;
            }
            case 'T': {
                this.quadTo(d, d2);
                break;
            }
            case 't': {
                this.quadTo(d + this.lx, d2 + this.ly);
                break;
            }
            case 'C': {
                this.curveTo(d, d2, d3, d4, d5, d6);
                break;
            }
            case 'c': {
                this.curveTo(d + this.lx, d2 + this.ly, d3 + this.lx, d4 + this.ly, d5 + this.lx, d6 + this.ly);
                break;
            }
            case 'S': {
                this.curveTo(d, d2, d3, d4);
                break;
            }
            case 's': {
                this.curveTo(d + this.lx, d2 + this.ly, d3 + this.lx, d4 + this.ly);
                break;
            }
            case 'K': {
                this.timmerTo(d, d2, d3, d4, d5, d6);
                break;
            }
            case 'k': {
                this.timmerTo(d + this.lx, d2 + this.ly, d3 + this.lx, d4 + this.ly, d5 + this.lx, d6 + this.ly);
                break;
            }
            case 'U': {
                this.timmerTo(d, d2, d3, d4);
                break;
            }
            case 'u': {
                this.timmerTo(d + this.lx, d2 + this.ly, d3 + this.lx, d4 + this.ly);
                break;
            }
            case 'A': {
                this.svgArcTo(d, d2, d3, d4 != 0.0, d5 != 0.0, d6, d7);
                break;
            }
            case 'a': {
                this.svgArcTo(d, d2, d3, d4 != 0.0, d5 != 0.0, d6 + this.lx, d7 + this.ly);
                break;
            }
            case 'G': {
                this.arcThroughTo(d, d2, d3, d4);
                break;
            }
            case 'g': {
                this.arcThroughTo(d + this.lx, d2 + this.ly, d3 + this.lx, d4 + this.ly);
                break;
            }
            case 'I': {
                this.gerberArcTo(d, d2, d3 != 0.0, d4 != 0.0, d5, d6);
                break;
            }
            case 'i': {
                this.gerberArcTo(d, d2, d3 != 0.0, d4 != 0.0, d5 + this.lx, d6 + this.ly);
                break;
            }
            case 'J': {
                this.gerberArcTo(d, d2, d3 != 0.0, d4 != 0.0, d5, d6);
                break;
            }
            case 'j': {
                this.gerberArcTo(d, d2, d3 != 0.0, d4 != 0.0, d5 + this.lx, d6 + this.ly);
                break;
            }
            case 'R': {
                this.appendRectangle(d, d2, d3, d4, d5, d6);
                break;
            }
            case 'r': {
                this.appendRectangle(d + this.lx, d2 + this.ly, d3, d4, d5, d6);
                break;
            }
            case 'E': {
                this.appendEllipse(d, d2, d3, d4, d5, d6, (int)Math.round(d7));
                break;
            }
            case 'e': {
                this.appendEllipse(d + this.lx, d2 + this.ly, d3, d4, d5, d6, (int)Math.round(d7));
                break;
            }
            case 'O': {
                this.appendEllipse(d, d2, d3, d4, d5, d6, (int)Math.round(d7));
                break;
            }
            case 'o': {
                this.appendEllipse(d + this.lx, d2 + this.ly, d3, d4, d5, d6, (int)Math.round(d7));
                break;
            }
            case 'P': {
                this.appendRegularPolygon(d, d2, d3, d4, (int)Math.round(d5), (int)Math.round(d6));
                break;
            }
            case 'p': {
                this.appendRegularPolygon(d + this.lx, d2 + this.ly, d3 + this.lx, d4 + this.ly, (int)Math.round(d5), (int)Math.round(d6));
                break;
            }
            case 'X': {
                this.appendAsterisk(d, d2, d3, d4, (int)Math.round(d5));
                break;
            }
            case 'x': {
                this.appendAsterisk(d + this.lx, d2 + this.ly, d3 + this.lx, d4 + this.ly, (int)Math.round(d5));
                break;
            }
            case 'Z': {
                this.closePath();
                break;
            }
            case 'z': {
                this.closePath();
                break;
            }
            case 'W': {
                this.setWindingRule(d == 0.0 ? 1 : 0);
                break;
            }
            case 'w': {
                this.setWindingRule(d == 0.0 ? 1 : 0);
            }
        }
    }

    public void moveTo(double d, double d2) {
        this.lcx = this.lx = d;
        this.lcy = this.ly = d2;
        this.p.moveTo(this.lx, this.ly);
    }

    public void horizTo(double d) {
        this.lcx = this.lx = d;
        this.lcy = this.ly;
        this.p.lineTo(this.lx, this.lcy);
    }

    public void vertTo(double d) {
        this.lcx = this.lx;
        this.lcy = this.ly = d;
        this.p.lineTo(this.lcx, this.ly);
    }

    public void lineTo(double d, double d2) {
        this.lcx = this.lx = d;
        this.lcy = this.ly = d2;
        this.p.lineTo(this.lx, this.ly);
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        this.lcx = d;
        this.lcy = d2;
        this.lx = d3;
        this.ly = d4;
        this.p.quadTo(this.lcx, this.lcy, this.lx, this.ly);
    }

    public void quadTo(double d, double d2) {
        this.quadTo(this.lx + this.lx - this.lcx, this.ly + this.ly - this.lcy, d, d2);
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.lcx = d3;
        this.lcy = d4;
        this.lx = d5;
        this.ly = d6;
        this.p.curveTo(d, d2, this.lcx, this.lcy, this.lx, this.ly);
    }

    public void curveTo(double d, double d2, double d3, double d4) {
        this.curveTo(this.lx + this.lx - this.lcx, this.ly + this.ly - this.lcy, d, d2, d3, d4);
    }

    public void timmerTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.lcx = d3;
        this.lcy = d4;
        this.lx = d5;
        this.ly = d6;
        PathExtensions.timmerTo(this.p, d, d2, this.lcx, this.lcy, this.lx, this.ly);
    }

    public void timmerTo(double d, double d2, double d3, double d4) {
        this.timmerTo(this.lx + this.lx - this.lcx, this.ly + this.ly - this.lcy, d, d2, d3, d4);
    }

    public void svgArcTo(double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5) {
        this.lcx = this.lx = d4;
        this.lcy = this.ly = d5;
        PathExtensions.svgArcTo(this.p, d, d2, d3, bl, bl2, this.lx, this.ly);
    }

    public void arcThroughTo(double d, double d2, double d3, double d4) {
        this.lcx = this.lx = d3;
        this.lcy = this.ly = d4;
        PathExtensions.arcThroughTo(this.p, d, d2, this.lx, this.ly);
    }

    public void gerberArcTo(double d, double d2, boolean bl, boolean bl2, double d3, double d4) {
        this.lcx = this.lx = d3;
        this.lcy = this.ly = d4;
        PathExtensions.gerberArcTo(this.p, d, d2, bl, bl2, this.lx, this.ly);
    }

    public void appendRectangle(double d, double d2, double d3, double d4, double d5, double d6) {
        Point2D point2D = PathExtensions.appendRectangle(this.p, d, d2, d3, d4, d5, d6);
        this.lcx = this.lx = point2D.getX();
        this.lcy = this.ly = point2D.getY();
    }

    public void appendEllipse(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        Point2D point2D = PathExtensions.appendEllipse(this.p, d, d2, d3, d4, d5, d6, n);
        this.lcx = this.lx = point2D.getX();
        this.lcy = this.ly = point2D.getY();
    }

    public void appendRegularPolygon(double d, double d2, double d3, double d4, int n, int n2) {
        Point2D point2D = PathExtensions.appendRegularPolygon(this.p, d, d2, d3, d4, n, n2);
        this.lcx = this.lx = point2D.getX();
        this.lcy = this.ly = point2D.getY();
    }

    public void appendAsterisk(double d, double d2, double d3, double d4, int n) {
        Point2D point2D = PathExtensions.appendAsterisk(this.p, d, d2, d3, d4, n);
        this.lcx = this.lx = point2D.getX();
        this.lcy = this.ly = point2D.getY();
    }

    public void closePath() {
        this.p.closePath();
        this.lcx = this.lx = this.p.getCurrentPoint().getX();
        this.lcy = this.ly = this.p.getCurrentPoint().getY();
    }

    public int getWindingRule() {
        return this.p.getWindingRule();
    }

    public void setWindingRule(int n) {
        this.p.setWindingRule(n);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        this.p.append(pathIterator, bl);
        this.lcx = this.lx = this.p.getCurrentPoint().getX();
        this.lcy = this.ly = this.p.getCurrentPoint().getY();
    }

    public void append(Shape shape, boolean bl) {
        this.p.append(shape, bl);
        this.lcx = this.lx = this.p.getCurrentPoint().getX();
        this.lcy = this.ly = this.p.getCurrentPoint().getY();
    }

    public static int getOperandCount(char c) {
        switch (c) {
            case 'Z': 
            case 'z': {
                return 0;
            }
            case 'H': 
            case 'V': 
            case 'W': 
            case 'h': 
            case 'v': 
            case 'w': {
                return 1;
            }
            case 'L': 
            case 'M': 
            case 'T': 
            case 'l': 
            case 'm': 
            case 't': {
                return 2;
            }
            case 'G': 
            case 'Q': 
            case 'S': 
            case 'U': 
            case 'g': 
            case 'q': 
            case 's': 
            case 'u': {
                return 4;
            }
            case 'X': 
            case 'x': {
                return 5;
            }
            case 'C': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'P': 
            case 'R': 
            case 'c': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'p': 
            case 'r': {
                return 6;
            }
            case 'A': 
            case 'E': 
            case 'O': 
            case 'a': 
            case 'e': 
            case 'o': {
                return 7;
            }
        }
        return -1;
    }

    public static void timmerTo(GeneralPath generalPath, double d, double d2, double d3, double d4, double d5, double d6) {
        Point2D point2D = generalPath.getCurrentPoint();
        if (point2D == null) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        double d7 = point2D.getX() + (d - point2D.getX()) * 4.0 / 3.0;
        double d8 = point2D.getY() + (d2 - point2D.getY()) * 4.0 / 3.0;
        double d9 = d5 - (d5 - d3) * 4.0 / 3.0;
        double d10 = d6 - (d6 - d4) * 4.0 / 3.0;
        generalPath.curveTo(d7, d8, d9, d10, d5, d6);
    }

    public static CubicCurve2D createTimmer(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d + (d3 - d) * 4.0 / 3.0;
        double d10 = d2 + (d4 - d2) * 4.0 / 3.0;
        double d11 = d7 - (d7 - d5) * 4.0 / 3.0;
        double d12 = d8 - (d8 - d6) * 4.0 / 3.0;
        return new CubicCurve2D.Double(d, d2, d9, d10, d11, d12, d7, d8);
    }

    public static void svgArcTo(GeneralPath generalPath, double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5) {
        Point2D point2D = generalPath.getCurrentPoint();
        if (point2D == null) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        Shape shape = PathExtensions.createSvgArc(point2D.getX(), point2D.getY(), d, d2, d3, bl, bl2, d4, d5);
        if (shape != null) {
            generalPath.append(shape, true);
        }
        generalPath.lineTo(d4, d5);
    }

    public static Shape createSvgArc(double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, double d6, double d7) {
        double d8;
        double d9;
        if (d == d6 && d2 == d7) {
            return null;
        }
        if (d3 == 0.0 || d4 == 0.0) {
            return null;
        }
        double d10 = (d - d6) / 2.0;
        double d11 = (d2 - d7) / 2.0;
        d5 = Math.toRadians(d5 % 360.0);
        double d12 = Math.cos(d5);
        double d13 = Math.sin(d5);
        double d14 = d13 * d11 + d12 * d10;
        double d15 = d12 * d11 - d13 * d10;
        double d16 = d14 * d14;
        double d17 = (d3 = Math.abs(d3)) * d3;
        double d18 = d16 / d17 + (d9 = d15 * d15) / (d8 = (d4 = Math.abs(d4)) * d4);
        if (d18 > 1.0) {
            d3 = Math.sqrt(d18) * d3;
            d4 = Math.sqrt(d18) * d4;
            d17 = d3 * d3;
            d8 = d4 * d4;
        }
        double d19 = bl == bl2 ? -1.0 : 1.0;
        double d20 = (d17 * d8 - d17 * d9 - d8 * d16) / (d17 * d9 + d8 * d16);
        if (d20 < 0.0) {
            d20 = 0.0;
        }
        double d21 = d19 * Math.sqrt(d20);
        double d22 = d21 * (d3 * d15 / d4);
        double d23 = d21 * -(d4 * d14 / d3);
        double d24 = (d + d6) / 2.0;
        double d25 = (d2 + d7) / 2.0;
        double d26 = d24 + d12 * d22 - d13 * d23;
        double d27 = d25 + d13 * d22 + d12 * d23;
        double d28 = (d14 - d22) / d3;
        double d29 = (d15 - d23) / d4;
        double d30 = (-d14 - d22) / d3;
        double d31 = (-d15 - d23) / d4;
        double d32 = Math.sqrt(d28 * d28 + d29 * d29);
        double d33 = d28;
        double d34 = d29 < 0.0 ? -1.0 : 1.0;
        double d35 = Math.toDegrees(d34 * Math.acos(d33 / d32));
        double d36 = Math.sqrt((d28 * d28 + d29 * d29) * (d30 * d30 + d31 * d31));
        double d37 = d28 * d30 + d29 * d31;
        double d38 = d28 * d31 - d29 * d30 < 0.0 ? -1.0 : 1.0;
        double d39 = Math.toDegrees(d38 * Math.acos(d37 / d36));
        if (!bl2 && d39 > 0.0) {
            d39 -= 360.0;
        }
        if (bl2 && d39 < 0.0) {
            d39 += 360.0;
        }
        d39 %= 360.0;
        d35 %= 360.0;
        Arc2D.Double double_ = new Arc2D.Double();
        double_.x = d26 - d3;
        double_.y = d27 - d4;
        double_.width = d3 * 2.0;
        double_.height = d4 * 2.0;
        double_.start = -d35;
        double_.extent = -d39;
        double d40 = double_.getCenterX();
        double d41 = double_.getCenterY();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d5, d40, d41);
        return affineTransform.createTransformedShape(double_);
    }

    public static void arcThroughTo(GeneralPath generalPath, double d, double d2, double d3, double d4) {
        Point2D point2D = generalPath.getCurrentPoint();
        if (point2D == null) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        Arc2D arc2D = PathExtensions.createArcThrough(point2D.getX(), point2D.getY(), d, d2, d3, d4);
        if (arc2D != null) {
            generalPath.append(arc2D, true);
        }
        generalPath.lineTo(d3, d4);
    }

    public static Arc2D createArcThrough(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d == d3 && d3 == d5) {
            return null;
        }
        if (d2 == d4 && d4 == d6) {
            return null;
        }
        double d7 = PathExtensions.arcHK(d, d2, d3, d4, d5, d6);
        double d8 = PathExtensions.arcH(d, d2, d3, d4, d5, d6) / d7;
        double d9 = PathExtensions.arcK(d, d2, d3, d4, d5, d6) / d7;
        if (Double.isNaN(d8) || Double.isInfinite(d8)) {
            return null;
        }
        if (Double.isNaN(d9) || Double.isInfinite(d9)) {
            return null;
        }
        double d10 = Math.hypot(d9 - d2, d - d8);
        double d11 = Math.toDegrees(Math.atan2(d9 - d2, d - d8));
        double d12 = Math.toDegrees(Math.atan2(d9 - d4, d3 - d8));
        double d13 = Math.toDegrees(Math.atan2(d9 - d6, d5 - d8));
        Arc2D.Double double_ = new Arc2D.Double();
        double_.x = d8 - d10;
        double_.y = d9 - d10;
        double_.width = d10 + d10;
        double_.height = d10 + d10;
        double_.start = d11;
        double_.extent = d11 <= d12 && d12 <= d13 || d13 <= d12 && d12 <= d11 ? d13 - d11 : (d13 <= d11 ? d13 - d11 + 360.0 : d13 - d11 - 360.0);
        return double_;
    }

    private static double arcdet(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return d * d5 * d9 + d2 * d6 * d7 + d3 * d4 * d8 - d * d6 * d8 - d2 * d4 * d9 - d3 * d5 * d7;
    }

    private static double arcHK(double d, double d2, double d3, double d4, double d5, double d6) {
        return PathExtensions.arcdet(d, d2, 1.0, d3, d4, 1.0, d5, d6, 1.0) * 2.0;
    }

    private static double arcH(double d, double d2, double d3, double d4, double d5, double d6) {
        return PathExtensions.arcdet(d * d + d2 * d2, d2, 1.0, d3 * d3 + d4 * d4, d4, 1.0, d5 * d5 + d6 * d6, d6, 1.0);
    }

    private static double arcK(double d, double d2, double d3, double d4, double d5, double d6) {
        return PathExtensions.arcdet(d, d * d + d2 * d2, 1.0, d3, d3 * d3 + d4 * d4, 1.0, d5, d5 * d5 + d6 * d6, 1.0);
    }

    public static void gerberArcTo(GeneralPath generalPath, double d, double d2, boolean bl, boolean bl2, double d3, double d4) {
        Point2D point2D = generalPath.getCurrentPoint();
        if (point2D == null) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        Arc2D arc2D = PathExtensions.createGerberArc(point2D.getX(), point2D.getY(), d, d2, bl, bl2, d3, d4);
        if (arc2D != null) {
            generalPath.append(arc2D, true);
        }
        generalPath.lineTo(d3, d4);
    }

    public static Arc2D createGerberArc(double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, double d6) {
        if (Math.abs(d - d5) < 1.0E-6 && Math.abs(d2 - d6) < 1.0E-6) {
            if (bl) {
                double d7 = Math.hypot(d3, d4);
                if (d7 < 1.0E-6) {
                    return null;
                }
                double d8 = Math.toDegrees(Math.atan2(d4, -d3));
                double d9 = bl2 ? -360.0 : 360.0;
                return new Arc2D.Double(d + d3 - d7, d2 + d4 - d7, d7 + d7, d7 + d7, d8, d9, 0);
            }
            return null;
        }
        double d10 = Math.hypot(d3, d4);
        GerberArcCandidate gerberArcCandidate = new GerberArcCandidate(d, d2, d10, d + d3, d2 + d4, d5, d6, bl2);
        if (bl) {
            return gerberArcCandidate.arc;
        }
        GerberArcCandidate gerberArcCandidate2 = new GerberArcCandidate(d, d2, d10, d + d3, d2 - d4, d5, d6, bl2);
        GerberArcCandidate gerberArcCandidate3 = new GerberArcCandidate(d, d2, d10, d - d3, d2 + d4, d5, d6, bl2);
        GerberArcCandidate gerberArcCandidate4 = new GerberArcCandidate(d, d2, d10, d - d3, d2 - d4, d5, d6, bl2);
        GerberArcCandidate gerberArcCandidate5 = null;
        if (Math.abs(gerberArcCandidate.extent) <= 90.0 && (gerberArcCandidate5 == null || gerberArcCandidate.deviation < gerberArcCandidate5.deviation)) {
            gerberArcCandidate5 = gerberArcCandidate;
        }
        if (Math.abs(gerberArcCandidate2.extent) <= 90.0 && (gerberArcCandidate5 == null || gerberArcCandidate2.deviation < gerberArcCandidate5.deviation)) {
            gerberArcCandidate5 = gerberArcCandidate2;
        }
        if (Math.abs(gerberArcCandidate3.extent) <= 90.0 && (gerberArcCandidate5 == null || gerberArcCandidate3.deviation < gerberArcCandidate5.deviation)) {
            gerberArcCandidate5 = gerberArcCandidate3;
        }
        if (Math.abs(gerberArcCandidate4.extent) <= 90.0 && (gerberArcCandidate5 == null || gerberArcCandidate4.deviation < gerberArcCandidate5.deviation)) {
            gerberArcCandidate5 = gerberArcCandidate4;
        }
        return gerberArcCandidate5 != null ? gerberArcCandidate5.arc : null;
    }

    public static Point2D appendRectangle(GeneralPath generalPath, double d, double d2, double d3, double d4, double d5, double d6) {
        if (d5 == 0.0 || d6 == 0.0) {
            Point2D point2D = generalPath.getCurrentPoint();
            if (point2D == null) {
                point2D = new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0);
            }
            generalPath.append(new Rectangle2D.Double(d, d2, d3, d4), false);
            generalPath.moveTo(point2D.getX(), point2D.getY());
            return point2D;
        }
        Point2D point2D = generalPath.getCurrentPoint();
        if (point2D == null) {
            point2D = new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0);
        }
        generalPath.append(new RoundRectangle2D.Double(d, d2, d3, d4, d5, d6), false);
        generalPath.moveTo(point2D.getX(), point2D.getY());
        return point2D;
    }

    public static Point2D appendEllipse(GeneralPath generalPath, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        n = Math.abs(n) % 5;
        if (d6 <= -360.0 || d6 >= 360.0) {
            Point2D point2D = generalPath.getCurrentPoint();
            if (point2D == null) {
                point2D = new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0);
            }
            generalPath.append(new Ellipse2D.Double(d, d2, d3, d4), false);
            generalPath.moveTo(point2D.getX(), point2D.getY());
            return point2D;
        }
        if (n < 3) {
            Point2D point2D = generalPath.getCurrentPoint();
            if (point2D == null) {
                point2D = new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0);
            }
            generalPath.append(new Arc2D.Double(d, d2, d3, d4, d5, d6, n), false);
            generalPath.moveTo(point2D.getX(), point2D.getY());
            return point2D;
        }
        generalPath.append(new Arc2D.Double(d, d2, d3, d4, d5, d6, 0), n > 3);
        return generalPath.getCurrentPoint();
    }

    public static Point2D appendRegularPolygon(GeneralPath generalPath, double d, double d2, double d3, double d4, int n, int n2) {
        Point2D point2D = generalPath.getCurrentPoint();
        if (point2D == null) {
            point2D = new Point2D.Double(d, d2);
        }
        generalPath.append(PathExtensions.createRegularPolygon(d, d2, d3, d4, n, n2), false);
        generalPath.moveTo(point2D.getX(), point2D.getY());
        return point2D;
    }

    public static GeneralPath createRegularPolygon(double d, double d2, double d3, double d4, int n, int n2) {
        if (n < 3) {
            n = 3;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        GeneralPath generalPath = new GeneralPath();
        double d5 = Math.hypot(d4 - d2, d3 - d);
        double d6 = Math.atan2(d4 - d2, d3 - d);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            for (int i = 0; n3 < n && (i == 0 || i % n != 0); ++n3, i += n2) {
                double d7 = d6 + Math.PI * (double)((i + n4) * 2) / (double)n;
                double d8 = d + d5 * Math.cos(d7);
                double d9 = d2 + d5 * Math.sin(d7);
                if (i == 0) {
                    generalPath.moveTo((float)d8, (float)d9);
                    continue;
                }
                generalPath.lineTo((float)d8, (float)d9);
            }
            generalPath.closePath();
            ++n4;
        }
        return generalPath;
    }

    public static Point2D appendAsterisk(GeneralPath generalPath, double d, double d2, double d3, double d4, int n) {
        Point2D point2D = generalPath.getCurrentPoint();
        if (point2D == null) {
            point2D = new Point2D.Double(d, d2);
        }
        generalPath.append(PathExtensions.createAsterisk(d, d2, d3, d4, n), false);
        generalPath.moveTo(point2D.getX(), point2D.getY());
        return point2D;
    }

    public static GeneralPath createAsterisk(double d, double d2, double d3, double d4, int n) {
        if (n < 1) {
            n = 1;
        }
        GeneralPath generalPath = new GeneralPath();
        double d5 = Math.hypot(d4 - d2, d3 - d);
        double d6 = Math.atan2(d4 - d2, d3 - d);
        for (int i = 0; i < n; ++i) {
            double d7 = d6 + Math.PI * (double)(i * 2) / (double)n;
            double d8 = d + d5 * Math.cos(d7);
            double d9 = d2 + d5 * Math.sin(d7);
            generalPath.moveTo((float)d, (float)d2);
            generalPath.lineTo((float)d8, (float)d9);
        }
        return generalPath;
    }

    private static class GerberArcCandidate {
        public final double deviation;
        public final double extent;
        public final Arc2D arc;

        public GerberArcCandidate(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
            double d8 = Math.hypot(d6 - d4, d7 - d5);
            this.deviation = Math.abs(d3 - d8);
            double d9 = (d3 + d8) / 2.0;
            double d10 = Math.toDegrees(Math.atan2(d5 - d2, d - d4));
            double d11 = Math.toDegrees(Math.atan2(d5 - d7, d6 - d4));
            this.extent = bl ? (d11 < d10 ? d11 - d10 : d11 - d10 - 360.0) : (d11 > d10 ? d11 - d10 : d11 - d10 + 360.0);
            this.arc = new Arc2D.Double(d4 - d9, d5 - d9, d9 + d9, d9 + d9, d10, this.extent, 0);
        }
    }
}

