/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.BitmapEditPanel;
import com.kreative.bitsnpicas.edit.BitmapGlyphListSelection;
import com.kreative.bitsnpicas.edit.BitmapGlyphState;
import com.kreative.bitsnpicas.edit.BitmapGlyphTransform;
import com.kreative.bitsnpicas.edit.BitmapListMenuBar;
import com.kreative.bitsnpicas.edit.BitmapToolHandler;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.GlyphComponent;
import com.kreative.bitsnpicas.edit.GlyphEditMenuBar;
import com.kreative.bitsnpicas.edit.SaveManager;
import com.kreative.bitsnpicas.edit.SwingUtils;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class BitmapEditMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;

    public BitmapEditMenuBar(Frame frame, SaveManager saveManager, BitmapFont bitmapFont, BitmapEditPanel bitmapEditPanel) {
        this.add(new FileMenu(frame, saveManager, bitmapFont, bitmapEditPanel));
        this.add(new EditMenu(bitmapEditPanel));
        this.add(new GlyphEditMenuBar.ViewMenu<BitmapFontGlyph>(frame, bitmapEditPanel, BitmapFontGlyph.class));
        this.add(new TransformMenu(bitmapEditPanel.getGlyphComponent()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TransformMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public TransformMenuItem(final BitmapGlyphTransform bitmapGlyphTransform, final GlyphComponent<BitmapFontGlyph> glyphComponent) {
            super(bitmapGlyphTransform.name);
            this.setAccelerator(bitmapGlyphTransform.keystroke);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    bitmapGlyphTransform.transform(glyphComponent.getGlyphFont(), (BitmapFontGlyph)glyphComponent.getGlyph());
                    glyphComponent.glyphChanged();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TransformMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public TransformMenu(GlyphComponent<BitmapFontGlyph> glyphComponent) {
            super("Transform");
            for (BitmapGlyphTransform bitmapGlyphTransform : BitmapGlyphTransform.TRANSFORMS) {
                if (bitmapGlyphTransform == null) {
                    this.addSeparator();
                    continue;
                }
                this.add(new TransformMenuItem(bitmapGlyphTransform, glyphComponent));
            }
        }
    }

    public static final class ClearMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ClearMenuItem(final BitmapEditPanel bitmapEditPanel) {
            super("Clear");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    bitmapEditPanel.getToolHandler().pushUndoState(null);
                    BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapEditPanel.getGlyph();
                    bitmapFontGlyph.setXY(0, 0);
                    bitmapFontGlyph.setGlyph(new byte[0][0]);
                    bitmapFontGlyph.setCharacterWidth(0);
                    bitmapEditPanel.getGlyphComponent().glyphChanged();
                }
            });
        }
    }

    public static final class PasteMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public PasteMenuItem(final BitmapEditPanel bitmapEditPanel, final boolean bl) {
            super(bl ? "Paste Into" : "Paste");
            this.setAccelerator(KeyStroke.getKeyStroke(86, CommonMenuItems.SHORTCUT_KEY | (bl ? 1 : 0)));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        BufferedImage bufferedImage;
                        Object object;
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        if (clipboard.isDataFlavorAvailable(BitmapGlyphListSelection.flavor) && ((BitmapGlyphState[])(object = (BitmapGlyphState[])clipboard.getData(BitmapGlyphListSelection.flavor))).length == 1) {
                            bitmapEditPanel.getToolHandler().pushUndoState(null);
                            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
                            object[0].apply(bitmapFontGlyph);
                            if (bl) {
                                bitmapFontGlyph = BitmapFontGlyph.compose((BitmapFontGlyph)bitmapEditPanel.getGlyph(), bitmapFontGlyph);
                            }
                            new BitmapGlyphState(bitmapFontGlyph).apply((BitmapFontGlyph)bitmapEditPanel.getGlyph());
                            bitmapEditPanel.getGlyphComponent().glyphChanged();
                            return;
                        }
                        if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor) && (bufferedImage = SwingUtils.toBufferedImage((Image)(object = (Image)clipboard.getData(DataFlavor.imageFlavor)))) != null) {
                            bitmapEditPanel.getToolHandler().pushUndoState(null);
                            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
                            bitmapFontGlyph.setToImage(0, -bitmapEditPanel.getGlyphFont().getLineAscent(), bufferedImage);
                            bitmapFontGlyph.setCharacterWidth(bufferedImage.getWidth());
                            if (bl) {
                                bitmapFontGlyph = BitmapFontGlyph.compose((BitmapFontGlyph)bitmapEditPanel.getGlyph(), bitmapFontGlyph);
                            }
                            new BitmapGlyphState(bitmapFontGlyph).apply((BitmapFontGlyph)bitmapEditPanel.getGlyph());
                            bitmapEditPanel.getGlyphComponent().glyphChanged();
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        unsupportedFlavorException.printStackTrace();
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
    }

    public static final class CopyMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public CopyMenuItem(final BitmapEditPanel bitmapEditPanel) {
            super("Copy");
            this.setAccelerator(KeyStroke.getKeyStroke(67, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    BitmapGlyphListSelection bitmapGlyphListSelection = new BitmapGlyphListSelection(Arrays.asList(bitmapEditPanel.getGlyphLocator()));
                    clipboard.setContents(bitmapGlyphListSelection, bitmapGlyphListSelection);
                }
            });
        }
    }

    public static final class CutMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public CutMenuItem(final BitmapEditPanel bitmapEditPanel) {
            super("Cut");
            this.setAccelerator(KeyStroke.getKeyStroke(88, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    BitmapGlyphListSelection bitmapGlyphListSelection = new BitmapGlyphListSelection(Arrays.asList(bitmapEditPanel.getGlyphLocator()));
                    clipboard.setContents(bitmapGlyphListSelection, bitmapGlyphListSelection);
                    bitmapEditPanel.getToolHandler().pushUndoState(null);
                    BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapEditPanel.getGlyph();
                    bitmapFontGlyph.setXY(0, 0);
                    bitmapFontGlyph.setGlyph(new byte[0][0]);
                    bitmapFontGlyph.setCharacterWidth(0);
                    bitmapEditPanel.getGlyphComponent().glyphChanged();
                }
            });
        }
    }

    public static final class RedoMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public RedoMenuItem(final BitmapToolHandler bitmapToolHandler) {
            super("Redo");
            this.setAccelerator(KeyStroke.getKeyStroke(90, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    bitmapToolHandler.redo();
                }
            });
        }
    }

    public static final class UndoMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public UndoMenuItem(final BitmapToolHandler bitmapToolHandler) {
            super("Undo");
            this.setAccelerator(KeyStroke.getKeyStroke(90, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    bitmapToolHandler.undo();
                }
            });
        }
    }

    public static final class EditMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public EditMenu(BitmapEditPanel bitmapEditPanel) {
            super("Edit");
            BitmapToolHandler bitmapToolHandler = bitmapEditPanel.getToolHandler();
            this.add(new UndoMenuItem(bitmapToolHandler));
            this.add(new RedoMenuItem(bitmapToolHandler));
            this.addSeparator();
            this.add(new CutMenuItem(bitmapEditPanel));
            this.add(new CopyMenuItem(bitmapEditPanel));
            this.add(new PasteMenuItem(bitmapEditPanel, false));
            this.add(new PasteMenuItem(bitmapEditPanel, true));
            this.add(new ClearMenuItem(bitmapEditPanel));
        }
    }

    public static final class ImportMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private String lastDirectory = null;

        public ImportMenuItem(final Frame frame, final BitmapEditPanel bitmapEditPanel) {
            super("Import Image...");
            this.setAccelerator(KeyStroke.getKeyStroke(73, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FileDialog fileDialog = new FileDialog(frame, "Import Image", 0);
                    if (ImportMenuItem.this.lastDirectory != null) {
                        fileDialog.setDirectory(ImportMenuItem.this.lastDirectory);
                    }
                    fileDialog.setVisible(true);
                    String string = fileDialog.getDirectory();
                    String string2 = fileDialog.getFile();
                    fileDialog.dispose();
                    if (string == null || string2 == null) {
                        return;
                    }
                    File file = new File(ImportMenuItem.this.lastDirectory = string, string2);
                    try {
                        BufferedImage bufferedImage = ImageIO.read(file);
                        if (bufferedImage != null) {
                            bitmapEditPanel.getToolHandler().pushUndoState(null);
                            Font font = bitmapEditPanel.getGlyphFont();
                            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapEditPanel.getGlyph();
                            bitmapFontGlyph.setToImage(0, -font.getLineAscent(), bufferedImage);
                            bitmapFontGlyph.setCharacterWidth(bufferedImage.getWidth());
                            bitmapEditPanel.getGlyphComponent().glyphChanged();
                        } else {
                            JOptionPane.showMessageDialog(null, "The selected file was not recognized as an image file.", "Import Image", 0);
                        }
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "An error occurred while reading the selected file.", "Import Image", 0);
                    }
                }
            });
        }
    }

    public static final class FileMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public FileMenu(Frame frame, SaveManager saveManager, BitmapFont bitmapFont, BitmapEditPanel bitmapEditPanel) {
            super("File");
            this.add(new CommonMenuItems.NewMenu());
            this.add(new CommonMenuItems.OpenMenuItem());
            this.add(new CommonMenuItems.CloseMenuItem(frame));
            this.addSeparator();
            this.add(new CommonMenuItems.SaveMenuItem(saveManager));
            this.add(new CommonMenuItems.SaveAsMenuItem(saveManager));
            this.add(new BitmapListMenuBar.ExportMenuItem(bitmapFont));
            this.addSeparator();
            this.add(new ImportMenuItem(frame, bitmapEditPanel));
            this.addSeparator();
            this.add(new CommonMenuItems.FontInfoMenuItem(bitmapFont, saveManager));
            this.add(new BitmapListMenuBar.PreviewMenuItem(bitmapFont, bitmapEditPanel.getGlyphList()));
            if (!CommonMenuItems.IS_MAC_OS) {
                this.addSeparator();
                this.add(new CommonMenuItems.ExitMenuItem());
            }
        }
    }
}

