/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphComponentListener;
import com.kreative.bitsnpicas.edit.Resources;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphComponent<G extends FontGlyph>
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN_WIDTH = 60;
    private static final int MARGIN_HEIGHT = 24;
    private static final Color GRID_COLOR = new Color(-3355444);
    private static final Color CAP_HEIGHT_COLOR = new Color(-26368);
    private static final Color X_HEIGHT_COLOR = new Color(-26368);
    private static final Color LINE_GAP_COLOR = new Color(-13312);
    private static final Color LINE_ASCENT_COLOR = new Color(-65332);
    private static final Color LINE_DESCENT_COLOR = new Color(-16724737);
    private static final Color EM_ASCENT_COLOR = Color.red;
    private static final Color EM_DESCENT_COLOR = Color.blue;
    private static final Color ADVANCE_COLOR = new Color(-16724992);
    private static final Color BOUNDS_COLOR = new Color(-6749953);
    private Font<G> font;
    private G glyph;
    private double scale;
    private double tx;
    private double ty;
    private boolean fit;
    private boolean showGlyphBounds;
    private Dimension minimumSize;
    private Dimension preferredSize;
    private final List<GlyphComponentListener<G>> listeners;

    public GlyphComponent(Font<G> font, G g) {
        this.font = font;
        this.glyph = g;
        this.fit = true;
        this.showGlyphBounds = false;
        this.listeners = new ArrayList<GlyphComponentListener<G>>();
        MyMouseListener myMouseListener = new MyMouseListener();
        this.addMouseListener(myMouseListener);
        this.addMouseMotionListener(myMouseListener);
        this.addMouseWheelListener(myMouseListener);
        MyComponentListener myComponentListener = new MyComponentListener();
        this.addComponentListener(myComponentListener);
    }

    public Font<G> getGlyphFont() {
        return this.font;
    }

    public G getGlyph() {
        return this.glyph;
    }

    public void setGlyph(Font<G> font, G g) {
        this.font = font;
        this.glyph = g;
        this.metricsAndGlyphChanged();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        if (this.scale != d && d > 0.0) {
            this.scale = d;
            this.repaint();
        }
    }

    public double getTranslateX() {
        return this.tx;
    }

    public double getTranslateY() {
        return this.ty;
    }

    public void setTranslate(double d, double d2) {
        if (this.tx != d || this.ty != d2) {
            this.tx = d;
            this.ty = d2;
            this.repaint();
        }
    }

    public void setBestScaleAndTranslate() {
        double d;
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        int n3 = n - 120;
        int n4 = n2 - 48;
        double d2 = this.font.getEmAscent2D();
        double d3 = d2 + this.font.getEmDescent2D();
        double d4 = d = d3 <= 0.0 ? (double)n4 / 20.0 : (double)n4 / d3 / 2.0;
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d >= 1.0) {
            d = Math.floor(d);
        }
        double d5 = Math.round(((double)n3 - ((FontGlyph)this.glyph).getCharacterWidth2D() * d) / 2.0);
        double d6 = Math.round(((double)n4 - d3 * d) / 2.0 + d2 * d);
        if (this.scale != d || this.tx != d5 || this.ty != d6) {
            this.scale = d;
            this.tx = d5;
            this.ty = d6;
            this.repaint();
        }
    }

    public boolean getFit() {
        return this.fit;
    }

    public void setFit(boolean bl) {
        this.fit = bl;
        if (bl) {
            this.setBestScaleAndTranslate();
        }
    }

    public boolean getShowGlyphBounds() {
        return this.showGlyphBounds;
    }

    public void setShowGlyphBounds(boolean bl) {
        this.showGlyphBounds = bl;
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        Insets insets = this.getInsets();
        int n = 140 + insets.left + insets.right;
        int n2 = 68 + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.minimumSize = dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        Insets insets = this.getInsets();
        int n = 520 + insets.left + insets.right;
        int n2 = 448 + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void addGlyphComponentListener(GlyphComponentListener<G> glyphComponentListener) {
        this.listeners.add(glyphComponentListener);
    }

    public void removeGlyphComponentListener(GlyphComponentListener<G> glyphComponentListener) {
        this.listeners.remove(glyphComponentListener);
    }

    public void metricsChanged() {
        for (GlyphComponentListener<G> glyphComponentListener : this.listeners) {
            glyphComponentListener.metricsChanged(this.glyph, this.font);
        }
        this.repaint();
    }

    public void glyphChanged() {
        for (GlyphComponentListener<G> glyphComponentListener : this.listeners) {
            glyphComponentListener.glyphChanged(this.glyph, this.font);
        }
        this.repaint();
    }

    public void metricsAndGlyphChanged() {
        for (GlyphComponentListener<G> glyphComponentListener : this.listeners) {
            glyphComponentListener.metricsChanged(this.glyph, this.font);
            glyphComponentListener.glyphChanged(this.glyph, this.font);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        if (this.scale <= 0.0) {
            this.setBestScaleAndTranslate();
        }
        Insets insets = this.getInsets();
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = this.getWidth() - insets.left - insets.right;
        int n6 = this.getHeight() - insets.top - insets.bottom;
        int n7 = n3 + 60;
        int n8 = n4 + 24;
        int n9 = n5 - 120;
        int n10 = n6 - 48;
        int n11 = n7 + (int)Math.round(this.tx);
        int n12 = n8 + (int)Math.round(this.ty);
        int n13 = n8 + (int)Math.round(this.ty - this.font.getEmAscent2D() * this.scale);
        int n14 = n8 + (int)Math.round(this.ty + this.font.getEmDescent2D() * this.scale);
        int n15 = n8 + (int)Math.round(this.ty - this.font.getLineAscent2D() * this.scale);
        int n16 = n8 + (int)Math.round(this.ty + this.font.getLineDescent2D() * this.scale);
        int n17 = n8 + (int)Math.round(this.ty + (this.font.getLineDescent2D() + this.font.getLineGap2D()) * this.scale);
        int n18 = n8 + (int)Math.round(this.ty - this.font.getXHeight2D() * this.scale);
        int n19 = n8 + (int)Math.round(this.ty - this.font.getCapHeight2D() * this.scale);
        int n20 = n7 + (int)Math.round(this.tx + ((FontGlyph)this.glyph).getCharacterWidth2D() * this.scale);
        graphics.setColor(Color.black);
        graphics.fillRect(n7 - 1, n8 - 1, n9 + 2, n10 + 2);
        Shape shape = graphics.getClip();
        graphics.clipRect(n7, n8, n9, n10);
        graphics.setColor(Color.white);
        graphics.fillRect(n7, n8, n9, n10);
        graphics.setColor(Color.black);
        ((FontGlyph)this.glyph).paint(graphics, (double)n7 + this.tx, (double)n8 + this.ty, this.scale);
        if (this.scale >= 5.0) {
            graphics.setColor(GRID_COLOR);
            n2 = 1;
            while (this.ty + (double)n2 * this.scale <= (double)n10) {
                n = n8 + (int)Math.round(this.ty + (double)n2 * this.scale);
                graphics.drawLine(n7, n, n7 + n9, n);
                ++n2;
            }
            n2 = 1;
            while (this.ty - (double)n2 * this.scale >= 0.0) {
                n = n8 + (int)Math.round(this.ty - (double)n2 * this.scale);
                graphics.drawLine(n7, n, n7 + n9, n);
                ++n2;
            }
            n2 = 1;
            while (this.tx + (double)n2 * this.scale <= (double)n9) {
                n = n7 + (int)Math.round(this.tx + (double)n2 * this.scale);
                graphics.drawLine(n, n8, n, n8 + n10);
                ++n2;
            }
            n2 = 1;
            while (this.tx - (double)n2 * this.scale >= 0.0) {
                n = n7 + (int)Math.round(this.tx - (double)n2 * this.scale);
                graphics.drawLine(n, n8, n, n8 + n10);
                ++n2;
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n7, n12, n7 + n9, n12);
        graphics.drawLine(n11, n8, n11, n8 + n10);
        graphics.setColor(CAP_HEIGHT_COLOR);
        graphics.drawLine(n7, n19, n7 + n9, n19);
        graphics.setColor(X_HEIGHT_COLOR);
        graphics.drawLine(n7, n18, n7 + n9, n18);
        graphics.setColor(LINE_GAP_COLOR);
        graphics.drawLine(n7, n17, n7 + n9, n17);
        graphics.setColor(LINE_ASCENT_COLOR);
        graphics.drawLine(n7, n15, n7 + n9, n15);
        graphics.setColor(LINE_DESCENT_COLOR);
        graphics.drawLine(n7, n16, n7 + n9, n16);
        graphics.setColor(EM_ASCENT_COLOR);
        graphics.drawLine(n7, n13, n7 + n9, n13);
        graphics.setColor(EM_DESCENT_COLOR);
        graphics.drawLine(n7, n14, n7 + n9, n14);
        graphics.setColor(ADVANCE_COLOR);
        graphics.drawLine(n20, n8, n20, n8 + n10);
        if (this.showGlyphBounds) {
            graphics.setColor(BOUNDS_COLOR);
            n2 = n7 + (int)Math.round(this.tx + ((FontGlyph)this.glyph).getGlyphOffset2D() * this.scale);
            n = n8 + (int)Math.round(this.ty - ((FontGlyph)this.glyph).getGlyphAscent2D() * this.scale);
            int n21 = n7 + (int)Math.round(this.tx + (((FontGlyph)this.glyph).getGlyphOffset2D() + ((FontGlyph)this.glyph).getGlyphWidth2D()) * this.scale);
            int n22 = n8 + (int)Math.round(this.ty + (-((FontGlyph)this.glyph).getGlyphAscent2D() + ((FontGlyph)this.glyph).getGlyphHeight2D()) * this.scale);
            graphics.drawRect(n2, n, n21 - n2, n22 - n);
        }
        graphics.setClip(shape);
        java.awt.Font font = graphics.getFont();
        graphics.setColor(Color.black);
        graphics.setFont(Resources.HEX_FONT);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (n13 >= n8 && n13 < n8 + n10) {
            String string = this.toString(this.font.getEmAscent2D(), true) + " >";
            graphics.drawString(string, n7 - fontMetrics.stringWidth(string) - 1, n13 + 4);
        }
        if (n14 >= n8 && n14 < n8 + n10) {
            String string = this.toString(-this.font.getEmDescent2D(), true) + " >";
            graphics.drawString(string, n7 - fontMetrics.stringWidth(string) - 1, n14 + 4);
        }
        if (n18 >= n8 && n18 < n8 + n10 && n18 != n13 && n18 != n14) {
            String string = this.toString(this.font.getXHeight2D(), false) + " >";
            graphics.drawString(string, n7 - fontMetrics.stringWidth(string) - 1, n18 + 4);
        }
        if (n15 >= n8 && n15 < n8 + n10) {
            String string = "< " + this.toString(this.font.getLineAscent2D(), true);
            graphics.drawString(string, n7 + n9 + 2, n15 + 4);
        }
        if (n16 >= n8 && n16 < n8 + n10) {
            String string = "< " + this.toString(-this.font.getLineDescent2D(), true);
            graphics.drawString(string, n7 + n9 + 2, n16 + 4);
        }
        if (n17 >= n8 && n17 < n8 + n10 && n17 != n15 && n17 != n16) {
            String string = "< " + this.toString(this.font.getLineGap2D(), false);
            graphics.drawString(string, n7 + n9 + 2, n17 + 4);
        }
        if (n19 >= n8 && n19 < n8 + n10 && n19 != n15 && n19 != n16 && n19 != n17) {
            String string = "< " + this.toString(this.font.getCapHeight2D(), false);
            graphics.drawString(string, n7 + n9 + 2, n19 + 4);
        }
        if (n20 >= n7 && n20 < n7 + n9) {
            String string = this.toString(((FontGlyph)this.glyph).getCharacterWidth2D(), false);
            graphics.drawString(string, n20 - fontMetrics.stringWidth(string) / 2, n8 - 11);
            graphics.drawString("~", n20 - 4, n8);
            graphics.drawString("^", n20 - 4, n8 + n10 + 7);
            graphics.drawString(string, n20 - fontMetrics.stringWidth(string) / 2, n8 + n10 + 18);
        }
        graphics.setFont(font);
    }

    private String toString(double d, boolean bl) {
        String string = d == (double)((int)d) ? Integer.toString((int)d) : Double.toString(d);
        return d > 0.0 && bl ? "+" + string : string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MouseRegion {
        NONE,
        INTERIOR,
        EM_ASCENT,
        EM_DESCENT,
        X_HEIGHT,
        LINE_ASCENT,
        LINE_DESCENT,
        LINE_GAP,
        CAP_HEIGHT,
        ADVANCE_WIDTH;

    }

    private class MyMouseListener
    extends MouseAdapter {
        private MouseRegion inRegion = MouseRegion.NONE;
        private int baseX;
        private int baseY;
        private double baseValue;

        private MyMouseListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.isControlDown()) {
                MouseRegion mouseRegion = this.getRegion(mouseWheelEvent);
                Point2D point2D = mouseRegion == MouseRegion.INTERIOR ? this.getInteriorPoint(mouseWheelEvent) : null;
                boolean bl = false;
                for (GlyphComponentListener glyphComponentListener : GlyphComponent.this.listeners) {
                    if (!glyphComponentListener.mouseWheelMoved(mouseWheelEvent, point2D, GlyphComponent.this.glyph, GlyphComponent.this.font)) continue;
                    bl = true;
                }
                if (bl) {
                    GlyphComponent.this.glyphChanged();
                }
            } else if (mouseWheelEvent.isAltDown()) {
                if (mouseWheelEvent.getWheelRotation() < 0) {
                    GlyphComponent.this.scale = GlyphComponent.this.scale * 1.5;
                    if (GlyphComponent.this.scale <= 0.0) {
                        GlyphComponent.this.scale = 1.0;
                    }
                    if (GlyphComponent.this.scale >= 1.0) {
                        GlyphComponent.this.scale = Math.ceil(GlyphComponent.this.scale);
                    }
                    GlyphComponent.this.repaint();
                }
                if (mouseWheelEvent.getWheelRotation() > 0) {
                    GlyphComponent.this.scale = GlyphComponent.this.scale / 1.5;
                    if (GlyphComponent.this.scale <= 0.0) {
                        GlyphComponent.this.scale = 1.0;
                    }
                    if (GlyphComponent.this.scale >= 1.0) {
                        GlyphComponent.this.scale = Math.floor(GlyphComponent.this.scale);
                    }
                    GlyphComponent.this.repaint();
                }
            } else if (mouseWheelEvent.isShiftDown()) {
                GlyphComponent.this.tx = GlyphComponent.this.tx - (double)mouseWheelEvent.getWheelRotation();
                GlyphComponent.this.repaint();
            } else {
                GlyphComponent.this.ty = GlyphComponent.this.ty - (double)mouseWheelEvent.getWheelRotation();
                GlyphComponent.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.inRegion == MouseRegion.NONE) {
                MouseRegion mouseRegion = this.getRegion(mouseEvent);
                Point2D point2D = mouseRegion == MouseRegion.INTERIOR ? this.getInteriorPoint(mouseEvent) : null;
                switch (mouseRegion) {
                    case EM_ASCENT: {
                        GlyphComponent.this.setCursor(Cursor.getPredefinedCursor(8));
                        GlyphComponent.this.setToolTipText("Em Ascent");
                        break;
                    }
                    case EM_DESCENT: {
                        GlyphComponent.this.setCursor(Cursor.getPredefinedCursor(9));
                        GlyphComponent.this.setToolTipText("Em Descent");
                        break;
                    }
                    case X_HEIGHT: {
                        GlyphComponent.this.setCursor(Cursor.getPredefinedCursor(8));
                        GlyphComponent.this.setToolTipText("X Height");
                        break;
                    }
                    case LINE_ASCENT: {
                        GlyphComponent.this.setCursor(Cursor.getPredefinedCursor(8));
                        GlyphComponent.this.setToolTipText("Line Ascent");
                        break;
                    }
                    case LINE_DESCENT: {
                        GlyphComponent.this.setCursor(Cursor.getPredefinedCursor(9));
                        GlyphComponent.this.setToolTipText("Line Descent");
                        break;
                    }
                    case LINE_GAP: {
                        GlyphComponent.this.setCursor(Cursor.getPredefinedCursor(9));
                        GlyphComponent.this.setToolTipText("Line Gap");
                        break;
                    }
                    case CAP_HEIGHT: {
                        GlyphComponent.this.setCursor(Cursor.getPredefinedCursor(8));
                        GlyphComponent.this.setToolTipText("Cap Height");
                        break;
                    }
                    case ADVANCE_WIDTH: {
                        GlyphComponent.this.setCursor(Cursor.getPredefinedCursor(11));
                        GlyphComponent.this.setToolTipText("Advance Width");
                        break;
                    }
                    case NONE: {
                        GlyphComponent.this.setCursor(null);
                        GlyphComponent.this.setToolTipText(null);
                        break;
                    }
                    case INTERIOR: {
                        Cursor cursor = null;
                        for (GlyphComponentListener glyphComponentListener : GlyphComponent.this.listeners) {
                            Cursor cursor2 = glyphComponentListener.getCursor(mouseEvent, point2D, GlyphComponent.this.glyph, GlyphComponent.this.font);
                            if (cursor2 == null) continue;
                            cursor = cursor2;
                        }
                        GlyphComponent.this.setCursor(cursor);
                        GlyphComponent.this.setToolTipText(null);
                    }
                }
                boolean bl = false;
                for (GlyphComponentListener glyphComponentListener : GlyphComponent.this.listeners) {
                    if (!glyphComponentListener.mouseMoved(mouseEvent, point2D, GlyphComponent.this.glyph, GlyphComponent.this.font)) continue;
                    bl = true;
                }
                if (bl) {
                    GlyphComponent.this.glyphChanged();
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.inRegion = this.getRegion(mouseEvent);
            if (this.inRegion == MouseRegion.INTERIOR) {
                Point2D point2D = this.getInteriorPoint(mouseEvent);
                boolean bl = false;
                for (GlyphComponentListener glyphComponentListener : GlyphComponent.this.listeners) {
                    if (!glyphComponentListener.mousePressed(mouseEvent, point2D, GlyphComponent.this.glyph, GlyphComponent.this.font)) continue;
                    bl = true;
                }
                if (bl) {
                    GlyphComponent.this.glyphChanged();
                }
            } else if (this.inRegion != MouseRegion.NONE) {
                this.baseX = mouseEvent.getX();
                this.baseY = mouseEvent.getY();
                switch (this.inRegion) {
                    case EM_ASCENT: {
                        this.baseValue = GlyphComponent.this.font.getEmAscent2D();
                        break;
                    }
                    case EM_DESCENT: {
                        this.baseValue = GlyphComponent.this.font.getEmDescent2D();
                        break;
                    }
                    case X_HEIGHT: {
                        this.baseValue = GlyphComponent.this.font.getXHeight2D();
                        break;
                    }
                    case LINE_ASCENT: {
                        this.baseValue = GlyphComponent.this.font.getLineAscent2D();
                        break;
                    }
                    case LINE_DESCENT: {
                        this.baseValue = GlyphComponent.this.font.getLineDescent2D();
                        break;
                    }
                    case LINE_GAP: {
                        this.baseValue = GlyphComponent.this.font.getLineGap2D();
                        break;
                    }
                    case CAP_HEIGHT: {
                        this.baseValue = GlyphComponent.this.font.getCapHeight2D();
                        break;
                    }
                    case ADVANCE_WIDTH: {
                        this.baseValue = GlyphComponent.this.glyph.getCharacterWidth2D();
                        break;
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.inRegion == MouseRegion.INTERIOR) {
                Point2D point2D = this.getInteriorPoint(mouseEvent);
                boolean bl = false;
                for (GlyphComponentListener glyphComponentListener : GlyphComponent.this.listeners) {
                    if (!glyphComponentListener.mouseDragged(mouseEvent, point2D, GlyphComponent.this.glyph, GlyphComponent.this.font)) continue;
                    bl = true;
                }
                if (bl) {
                    GlyphComponent.this.glyphChanged();
                }
            } else if (this.inRegion != MouseRegion.NONE) {
                double d = Math.round(this.baseValue + (double)(mouseEvent.getX() - this.baseX) / GlyphComponent.this.scale);
                double d2 = Math.round(this.baseValue + (double)(mouseEvent.getY() - this.baseY) / GlyphComponent.this.scale);
                double d3 = Math.round(this.baseValue - (double)(mouseEvent.getY() - this.baseY) / GlyphComponent.this.scale);
                switch (this.inRegion) {
                    case EM_ASCENT: {
                        GlyphComponent.this.font.setEmAscent2D(d3 > 0.0 ? d3 : 0.0);
                        break;
                    }
                    case EM_DESCENT: {
                        GlyphComponent.this.font.setEmDescent2D(d2 > 0.0 ? d2 : 0.0);
                        break;
                    }
                    case X_HEIGHT: {
                        GlyphComponent.this.font.setXHeight2D(d3 > 0.0 ? d3 : 0.0);
                        break;
                    }
                    case LINE_ASCENT: {
                        GlyphComponent.this.font.setLineAscent2D(d3 > 0.0 ? d3 : 0.0);
                        break;
                    }
                    case LINE_DESCENT: {
                        GlyphComponent.this.font.setLineDescent2D(d2 > 0.0 ? d2 : 0.0);
                        break;
                    }
                    case LINE_GAP: {
                        GlyphComponent.this.font.setLineGap2D(d2 > 0.0 ? d2 : 0.0);
                        break;
                    }
                    case CAP_HEIGHT: {
                        GlyphComponent.this.font.setCapHeight2D(d3 > 0.0 ? d3 : 0.0);
                        break;
                    }
                    case ADVANCE_WIDTH: {
                        GlyphComponent.this.glyph.setCharacterWidth2D(d > 0.0 ? d : 0.0);
                        break;
                    }
                }
                GlyphComponent.this.metricsChanged();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.inRegion == MouseRegion.INTERIOR) {
                Point2D point2D = this.getInteriorPoint(mouseEvent);
                boolean bl = false;
                for (GlyphComponentListener glyphComponentListener : GlyphComponent.this.listeners) {
                    if (!glyphComponentListener.mouseReleased(mouseEvent, point2D, GlyphComponent.this.glyph, GlyphComponent.this.font)) continue;
                    bl = true;
                }
                if (bl) {
                    GlyphComponent.this.glyphChanged();
                }
            } else if (this.inRegion != MouseRegion.NONE) {
                double d = Math.round(this.baseValue + (double)(mouseEvent.getX() - this.baseX) / GlyphComponent.this.scale);
                double d2 = Math.round(this.baseValue + (double)(mouseEvent.getY() - this.baseY) / GlyphComponent.this.scale);
                double d3 = Math.round(this.baseValue - (double)(mouseEvent.getY() - this.baseY) / GlyphComponent.this.scale);
                switch (this.inRegion) {
                    case EM_ASCENT: {
                        GlyphComponent.this.font.setEmAscent2D(d3 > 0.0 ? d3 : 0.0);
                        break;
                    }
                    case EM_DESCENT: {
                        GlyphComponent.this.font.setEmDescent2D(d2 > 0.0 ? d2 : 0.0);
                        break;
                    }
                    case X_HEIGHT: {
                        GlyphComponent.this.font.setXHeight2D(d3 > 0.0 ? d3 : 0.0);
                        break;
                    }
                    case LINE_ASCENT: {
                        GlyphComponent.this.font.setLineAscent2D(d3 > 0.0 ? d3 : 0.0);
                        break;
                    }
                    case LINE_DESCENT: {
                        GlyphComponent.this.font.setLineDescent2D(d2 > 0.0 ? d2 : 0.0);
                        break;
                    }
                    case LINE_GAP: {
                        GlyphComponent.this.font.setLineGap2D(d2 > 0.0 ? d2 : 0.0);
                        break;
                    }
                    case CAP_HEIGHT: {
                        GlyphComponent.this.font.setCapHeight2D(d3 > 0.0 ? d3 : 0.0);
                        break;
                    }
                    case ADVANCE_WIDTH: {
                        GlyphComponent.this.glyph.setCharacterWidth2D(d > 0.0 ? d : 0.0);
                        break;
                    }
                }
                GlyphComponent.this.metricsChanged();
            }
            this.inRegion = MouseRegion.NONE;
        }

        private MouseRegion getRegion(MouseEvent mouseEvent) {
            if (GlyphComponent.this.scale <= 0.0) {
                GlyphComponent.this.setBestScaleAndTranslate();
            }
            Insets insets = GlyphComponent.this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = GlyphComponent.this.getWidth() - insets.left - insets.right;
            int n4 = GlyphComponent.this.getHeight() - insets.top - insets.bottom;
            int n5 = n + 60;
            int n6 = n2 + 24;
            int n7 = n3 - 120;
            int n8 = n4 - 48;
            if (mouseEvent.getY() < n6 || mouseEvent.getY() >= n6 + n8) {
                if (mouseEvent.getX() >= n5 && mouseEvent.getX() < n5 + n7) {
                    int n9 = n5 + (int)Math.round(GlyphComponent.this.tx + GlyphComponent.this.glyph.getCharacterWidth2D() * GlyphComponent.this.scale);
                    if (mouseEvent.getX() > n9 - 10 && mouseEvent.getX() < n9 + 10) {
                        return MouseRegion.ADVANCE_WIDTH;
                    }
                }
            } else if (mouseEvent.getX() < n5) {
                if (mouseEvent.getY() >= n6 && mouseEvent.getY() < n6 + n8) {
                    int n10 = n6 + (int)Math.round(GlyphComponent.this.ty - GlyphComponent.this.font.getEmAscent2D() * GlyphComponent.this.scale);
                    int n11 = n6 + (int)Math.round(GlyphComponent.this.ty + GlyphComponent.this.font.getEmDescent2D() * GlyphComponent.this.scale);
                    int n12 = n6 + (int)Math.round(GlyphComponent.this.ty - GlyphComponent.this.font.getXHeight2D() * GlyphComponent.this.scale);
                    if (mouseEvent.getY() > n10 - 10 && mouseEvent.getY() < n10 + 10) {
                        return MouseRegion.EM_ASCENT;
                    }
                    if (mouseEvent.getY() > n11 - 10 && mouseEvent.getY() < n11 + 10) {
                        return MouseRegion.EM_DESCENT;
                    }
                    if (mouseEvent.getY() > n12 - 10 && mouseEvent.getY() < n12 + 10) {
                        return MouseRegion.X_HEIGHT;
                    }
                }
            } else if (mouseEvent.getX() >= n5 + n7) {
                if (mouseEvent.getY() >= n6 && mouseEvent.getY() < n6 + n8) {
                    int n13 = n6 + (int)Math.round(GlyphComponent.this.ty - GlyphComponent.this.font.getLineAscent2D() * GlyphComponent.this.scale);
                    int n14 = n6 + (int)Math.round(GlyphComponent.this.ty + GlyphComponent.this.font.getLineDescent2D() * GlyphComponent.this.scale);
                    int n15 = n6 + (int)Math.round(GlyphComponent.this.ty + (GlyphComponent.this.font.getLineDescent2D() + GlyphComponent.this.font.getLineGap2D()) * GlyphComponent.this.scale);
                    int n16 = n6 + (int)Math.round(GlyphComponent.this.ty - GlyphComponent.this.font.getCapHeight2D() * GlyphComponent.this.scale);
                    if (mouseEvent.getY() > n13 - 10 && mouseEvent.getY() < n13 + 10) {
                        return MouseRegion.LINE_ASCENT;
                    }
                    if (mouseEvent.getY() > n14 - 10 && mouseEvent.getY() < n14 + 10) {
                        return MouseRegion.LINE_DESCENT;
                    }
                    if (mouseEvent.getY() > n15 - 10 && mouseEvent.getY() < n15 + 10) {
                        return MouseRegion.LINE_GAP;
                    }
                    if (mouseEvent.getY() > n16 - 10 && mouseEvent.getY() < n16 + 10) {
                        return MouseRegion.CAP_HEIGHT;
                    }
                }
            } else {
                return MouseRegion.INTERIOR;
            }
            return MouseRegion.NONE;
        }

        private Point2D getInteriorPoint(MouseEvent mouseEvent) {
            if (GlyphComponent.this.scale <= 0.0) {
                GlyphComponent.this.setBestScaleAndTranslate();
            }
            Insets insets = GlyphComponent.this.getInsets();
            int n = insets.left + 60;
            int n2 = insets.top + 24;
            int n3 = n + (int)Math.round(GlyphComponent.this.tx);
            int n4 = n2 + (int)Math.round(GlyphComponent.this.ty);
            double d = (double)(mouseEvent.getX() - n3) / GlyphComponent.this.scale;
            double d2 = (double)(mouseEvent.getY() - n4) / GlyphComponent.this.scale;
            return new Point2D.Double(d, d2);
        }
    }

    private class MyComponentListener
    extends ComponentAdapter {
        private MyComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (GlyphComponent.this.fit) {
                GlyphComponent.this.setBestScaleAndTranslate();
            }
        }
    }
}

