/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphListDataPanel;
import com.kreative.bitsnpicas.edit.GlyphListListener;
import com.kreative.bitsnpicas.edit.GlyphListModelList;
import com.kreative.bitsnpicas.edit.GlyphListURLPanel;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.SaveManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphListPanel<G extends FontGlyph>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GlyphListModelList modelList;
    private final JScrollPane modelPane;
    private final GlyphListURLPanel urlPanel;
    private final GlyphList<G> glyphList;
    private final JScrollPane glyphPane;
    private final GlyphListDataPanel<G> dataPanel;

    public GlyphListPanel(Font<G> font, final SaveManager saveManager) {
        this.modelList = new GlyphListModelList(font);
        this.modelPane = new JScrollPane(this.modelList, 22, 31);
        this.urlPanel = new GlyphListURLPanel(this.modelList);
        this.glyphList = new GlyphList<G>(font);
        this.glyphPane = new JScrollPane(this.glyphList, 22, 31);
        this.dataPanel = new GlyphListDataPanel<G>(this.glyphList);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)GlyphListPanel.setWidth(this.modelPane, 240), "Center");
        jPanel.add((Component)GlyphListPanel.setWidth(this.urlPanel, 240), "Last");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.glyphPane, "Center");
        jPanel2.add(this.dataPanel, "Last");
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        jSplitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)jSplitPane, "Center");
        this.modelList.setSelectedModel(this.glyphList.getModel(), false);
        this.modelList.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                GlyphListPanel.this.glyphList.setModel(GlyphListPanel.this.modelList.getSelectedModel());
            }
        });
        this.glyphList.addGlyphListListener(new GlyphListListener<G>(){

            @Override
            public void selectionChanged(GlyphList<G> glyphList, Font<G> font) {
            }

            @Override
            public void selectionOpened(GlyphList<G> glyphList, Font<G> font) {
                Object object;
                List list = glyphList.getSelection();
                if (list.size() < 5 || JOptionPane.showConfirmDialog(GlyphListPanel.this, "Are you sure you want to edit " + list.size() + " glyphs?", "Edit Glyphs", 2) == 0) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        GlyphLocator glyphLocator = object.next();
                        Main.openGlyph(font, glyphLocator, glyphList, saveManager);
                    }
                }
                if ((object = glyphList.getSelectedIndices()).size() == 1) {
                    int n = (Integer)object.first();
                    Integer n2 = glyphList.getModel().getCodePoint(n);
                    if (n2 != null && n2 == -57683) {
                        String string = "Subtable " + Integer.toHexString(0xFF00 | n).substring(2).toUpperCase();
                        TreePath treePath = GlyphListPanel.this.modelList.getSelectionPath();
                        GlyphListModelList.GlyphListModelTreeNode glyphListModelTreeNode = (GlyphListModelList.GlyphListModelTreeNode)treePath.getLastPathComponent();
                        for (GlyphListModelList.GlyphListModelTreeNode glyphListModelTreeNode2 : glyphListModelTreeNode.getChildren()) {
                            if (!string.equals(glyphListModelTreeNode2.toString())) continue;
                            treePath = treePath.pathByAddingChild(glyphListModelTreeNode2);
                            GlyphListPanel.this.modelList.setSelectionPath(treePath);
                            GlyphListPanel.this.modelList.scrollPathToVisible(treePath);
                            JViewport jViewport = GlyphListPanel.this.modelPane.getViewport();
                            Point point = jViewport.getViewPosition();
                            point.x = 0;
                            jViewport.setViewPosition(point);
                            return;
                        }
                    }
                }
            }

            @Override
            public void metricsChanged(GlyphList<G> glyphList, Font<G> font) {
                saveManager.setChanged();
            }

            @Override
            public void glyphsChanged(GlyphList<G> glyphList, Font<G> font) {
                saveManager.setChanged();
            }
        });
        InputMap inputMap = this.glyphPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("UP"), "none");
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "none");
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "none");
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "none");
    }

    public GlyphList<G> getGlyphList() {
        return this.glyphList;
    }

    private static <C extends JComponent> C setWidth(C c, int n) {
        Dimension dimension = c.getPreferredSize();
        dimension.width = n;
        c.setMinimumSize(dimension);
        c.setPreferredSize(dimension);
        c.setMaximumSize(dimension);
        return c;
    }
}

