/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.GEOSFontStrike;
import com.kreative.bitsnpicas.geos.UTF8StrikeEntry;
import com.kreative.bitsnpicas.geos.UTF8StrikeMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEOSFontPointSize {
    public int pointSize;
    public GEOSFontStrike strike;
    public GEOSFontStrike[] megaStrikes;
    public GEOSFontStrike megaStrikeIndex;
    public UTF8StrikeMap utf8Map;
    public Map<UTF8StrikeEntry, GEOSFontStrike> utf8Strikes;

    public GEOSFontPointSize(int n) {
        this.pointSize = n;
        this.strike = null;
        this.megaStrikes = null;
        this.megaStrikeIndex = null;
        this.utf8Map = null;
        this.utf8Strikes = null;
    }

    public boolean isMega() {
        return this.megaStrikes != null && this.megaStrikeIndex != null;
    }

    public boolean isUTF8() {
        return this.utf8Map != null && this.utf8Strikes != null;
    }

    public void remap(Map<UTF8StrikeEntry, UTF8StrikeEntry> map) {
        if (this.utf8Map != null) {
            this.utf8Map.remap(map);
        }
        if (this.utf8Strikes != null) {
            HashMap<UTF8StrikeEntry, GEOSFontStrike> hashMap = new HashMap<UTF8StrikeEntry, GEOSFontStrike>();
            for (Map.Entry<UTF8StrikeEntry, GEOSFontStrike> entry : this.utf8Strikes.entrySet()) {
                if (map.containsKey(entry.getKey())) {
                    hashMap.put(map.get(entry.getKey()), entry.getValue());
                    continue;
                }
                hashMap.put(entry.getKey(), entry.getValue());
            }
            this.utf8Strikes = hashMap;
        }
    }
}

