/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.ConvertFile;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GEOSSplit {
    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            boolean bl = false;
            for (String string : stringArray) {
                if (string.equals("-r")) {
                    bl = true;
                    continue;
                }
                GEOSSplit.process(new File(string), bl);
            }
        } else {
            System.out.println("Splits GEOS .cvt files into their constituent parts. As applicable:");
            System.out.println("  .dir.bin            - CBM directory entry");
            System.out.println("  .info.bin           - GEOS info block");
            System.out.println("  .icon.bin           - GEOS icon sprite data");
            System.out.println("  .icon.png           - GEOS icon converted to PNG");
            System.out.println("  .rec.bin            - VLIR record block");
            System.out.println("  .seq.bin            - sequential data");
            System.out.println("  .0.bin, .1.bin, ... - VLIR records");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void process(File file, boolean bl) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.getName().startsWith(".") || !bl && !file2.isFile()) continue;
                GEOSSplit.process(file2, bl);
            }
            return;
        } else {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".cvt")) return;
            try {
                DataOutputStream dataOutputStream;
                ConvertFile convertFile = new ConvertFile();
                FileInputStream fileInputStream = new FileInputStream(file);
                convertFile.read(new DataInputStream(fileInputStream));
                fileInputStream.close();
                if (convertFile.directoryBlock != null) {
                    dataOutputStream = new DataOutputStream(new FileOutputStream(GEOSSplit.sibling(file, ".dir.bin")));
                    dataOutputStream.write(0);
                    dataOutputStream.write(0);
                    convertFile.directoryBlock.write(dataOutputStream);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                if (convertFile.infoBlock != null) {
                    dataOutputStream = new DataOutputStream(new FileOutputStream(GEOSSplit.sibling(file, ".info.bin")));
                    dataOutputStream.write(0);
                    dataOutputStream.write(0);
                    convertFile.infoBlock.write(dataOutputStream);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                    FileOutputStream fileOutputStream = new FileOutputStream(GEOSSplit.sibling(file, ".icon.bin"));
                    fileOutputStream.write(convertFile.infoBlock.iconBitmap);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    ImageIO.write((RenderedImage)convertFile.infoBlock.getIconImage(), "png", GEOSSplit.sibling(file, ".icon.png"));
                }
                if (convertFile.recordBlock != null) {
                    dataOutputStream = new DataOutputStream(new FileOutputStream(GEOSSplit.sibling(file, ".rec.bin")));
                    dataOutputStream.write(0);
                    dataOutputStream.write(0);
                    convertFile.recordBlock.write(dataOutputStream);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                if (convertFile.sequentialData != null) {
                    dataOutputStream = new DataOutputStream(new FileOutputStream(GEOSSplit.sibling(file, ".seq.bin")));
                    dataOutputStream.write(convertFile.sequentialData);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                if (convertFile.vlirData == null) return;
                for (int i = 0; i < convertFile.vlirData.size(); ++i) {
                    byte[] byArray = convertFile.vlirData.get(i);
                    if (byArray.length <= 0) continue;
                    DataOutputStream dataOutputStream2 = new DataOutputStream(new FileOutputStream(GEOSSplit.sibling(file, "." + i + ".bin")));
                    dataOutputStream2.write(byArray);
                    dataOutputStream2.flush();
                    dataOutputStream2.close();
                }
                return;
            }
            catch (IOException iOException) {
                System.err.println("Error reading " + file.getName() + ":");
                iOException.printStackTrace();
            }
        }
    }

    private static File sibling(File file, String string) {
        return new File(file.getParentFile(), file.getName() + string);
    }
}

