/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class PSFBitmapFontImporter
implements BitmapFontImporter {
    private GlyphList lowEncoding;
    private GlyphList highEncoding;
    private int puaBase;
    private boolean gzip;

    public PSFBitmapFontImporter() {
        this.lowEncoding = null;
        this.highEncoding = null;
        this.puaBase = -1;
        this.gzip = false;
    }

    public PSFBitmapFontImporter(boolean bl) {
        this.lowEncoding = null;
        this.highEncoding = null;
        this.puaBase = -1;
        this.gzip = bl;
    }

    public PSFBitmapFontImporter(GlyphList glyphList, GlyphList glyphList2, int n) {
        this.lowEncoding = glyphList;
        this.highEncoding = glyphList2;
        this.puaBase = n;
        this.gzip = false;
    }

    public PSFBitmapFontImporter(GlyphList glyphList, GlyphList glyphList2, int n, boolean bl) {
        this.lowEncoding = glyphList;
        this.highEncoding = glyphList2;
        this.puaBase = n;
        this.gzip = bl;
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        InputStream inputStream = new ByteArrayInputStream(byArray);
        if (this.gzip) {
            inputStream = new GZIPInputStream(inputStream);
        }
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(inputStream));
        inputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        if (this.gzip) {
            inputStream = new GZIPInputStream(inputStream);
        }
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(inputStream));
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        InputStream inputStream = new FileInputStream(file);
        if (this.gzip) {
            inputStream = new GZIPInputStream(inputStream);
        }
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(inputStream));
        inputStream.close();
        String string = file.getName();
        if (string.toLowerCase().endsWith(".psf")) {
            string = string.substring(0, string.length() - 4);
        } else if (string.toLowerCase().endsWith(".psfu")) {
            string = string.substring(0, string.length() - 5);
        } else if (string.toLowerCase().endsWith(".psf.gz")) {
            string = string.substring(0, string.length() - 7);
        } else if (string.toLowerCase().endsWith(".psfu.gz")) {
            string = string.substring(0, string.length() - 8);
        }
        bitmapFont.setName(1, string);
        return new BitmapFont[]{bitmapFont};
    }

    private BitmapFont importFontImpl(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.readVersion(dataInputStream);
        int n5 = n4 < 2 ? 4 : Integer.reverseBytes(dataInputStream.readInt());
        int n6 = n3 = n4 < 2 ? dataInputStream.readUnsignedByte() : Integer.reverseBytes(dataInputStream.readInt());
        int n7 = n4 < 2 ? ((n3 & 1) == 0 ? 256 : 512) : Integer.reverseBytes(dataInputStream.readInt());
        int n8 = n4 < 2 ? dataInputStream.readUnsignedByte() : Integer.reverseBytes(dataInputStream.readInt());
        int n9 = n4 < 2 ? n8 : Integer.reverseBytes(dataInputStream.readInt());
        int n10 = n2 = n4 < 2 ? 8 : Integer.reverseBytes(dataInputStream.readInt());
        if (n4 >= 2 && n5 > 32) {
            dataInputStream.readFully(new byte[n5 - 32]);
        }
        byte[][][] byArrayArray = new byte[n7][][];
        byte[] byArray = new byte[n8];
        for (int i = 0; i < n7; ++i) {
            dataInputStream.readFully(byArray);
            byArrayArray[i] = new byte[n9][n2];
            n = 0;
            for (int j = 0; j < n9; ++j) {
                int n11 = 0;
                while (n11 < n2) {
                    for (int k = 128; n11 < n2 && k != 0; ++n11, k >>= 1) {
                        if ((byArray[n] & k) == 0) continue;
                        byArrayArray[i][j][n11] = -1;
                    }
                    ++n;
                }
            }
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if ((n3 & (n4 < 2 ? 2 : 1)) != 0) {
            for (n = 0; n < n7; ++n) {
                String[] stringArray;
                for (String string : stringArray = this.readUnicodeEntry(dataInputStream, n4)) {
                    hashMap.put(string, n);
                }
            }
        }
        BitmapFont bitmapFont = new BitmapFont(n9, 0, n9, 0, n9, n9, 0);
        if (this.lowEncoding != null) {
            for (int i = 0; i < 256 && i < n7; ++i) {
                Integer n12 = this.lowEncoding.get(i & 0xFF);
                if (n12 == null || n12 < 0) continue;
                bitmapFont.putCharacter(n12, new BitmapFontGlyph(byArrayArray[i], 0, n2, n9));
            }
        }
        if (this.highEncoding != null) {
            for (int i = 256; i < 512 && i < n7; ++i) {
                Integer n13 = this.highEncoding.get(i & 0xFF);
                if (n13 == null || n13 < 0) continue;
                bitmapFont.putCharacter(n13, new BitmapFontGlyph(byArrayArray[i], 0, n2, n9));
            }
        }
        if (this.puaBase >= 0) {
            for (int i = 0; i < n7; ++i) {
                bitmapFont.putCharacter(this.puaBase + i, new BitmapFontGlyph(byArrayArray[i], 0, n2, n9));
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            if (string.codePointCount(0, string.length()) != 1) continue;
            int n14 = string.codePointAt(0);
            int n15 = (Integer)entry.getValue();
            bitmapFont.putCharacter(n14, new BitmapFontGlyph(byArrayArray[n15], 0, n2, n9));
        }
        if (bitmapFont.isEmpty()) {
            for (int i = 0; i < n7; ++i) {
                bitmapFont.putCharacter(i, new BitmapFontGlyph(byArrayArray[i], 0, n2, n9));
            }
        }
        bitmapFont.setAscentDescent();
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    private int readVersion(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        if (n == 13828) {
            return 1;
        }
        if (n == 29365) {
            int n2 = dataInputStream.readUnsignedShort();
            if (n2 == 19078) {
                int n3 = dataInputStream.readInt();
                if (n3 == 0) {
                    return 2;
                }
                throw new IOException("bad magic number m3: " + n3);
            }
            throw new IOException("bad magic number m2: " + n2);
        }
        throw new IOException("bad magic number m1: " + n);
    }

    private String[] readUnicodeEntry(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        if (n < 2) {
            char c;
            StringBuffer stringBuffer = new StringBuffer();
            while ((c = Character.reverseBytes(dataInputStream.readChar())) != '\uffff') {
                stringBuffer.append(c);
            }
            String string = stringBuffer.toString();
            return this.splitUnicodeEntry(string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = dataInputStream.readUnsignedByte()) != 255) {
            if (n2 == 254) {
                byteArrayOutputStream.write(239);
                byteArrayOutputStream.write(191);
                byteArrayOutputStream.write(190);
                continue;
            }
            byteArrayOutputStream.write(n2);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = new String(byArray, "UTF-8");
        return this.splitUnicodeEntry(string);
    }

    private String[] splitUnicodeEntry(String string) {
        int n;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split("\ufffe+");
        int n3 = stringArray[0].length();
        for (n = 0; n < n3; n += Character.charCount(n2)) {
            n2 = stringArray[0].codePointAt(n);
            arrayList.add(String.valueOf(Character.toChars(n2)));
        }
        n3 = stringArray.length;
        for (n = 1; n < n3; ++n) {
            arrayList.add(stringArray[n]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

