/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.HheaTable;
import com.kreative.bitsnpicas.truetype.HmtxTableEntry;
import com.kreative.bitsnpicas.truetype.ListBasedTable;
import com.kreative.bitsnpicas.truetype.MaxpTable;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmtxTable
extends ListBasedTable<HmtxTableEntry> {
    @Override
    public String tableName() {
        return "hmtx";
    }

    @Override
    public String[] dependencyNames() {
        return new String[]{"hhea", "maxp"};
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n = ((HheaTable)trueTypeTableArray[0]).numLongHorMetrics;
        for (int i = 0; i < this.size(); ++i) {
            HmtxTableEntry hmtxTableEntry = (HmtxTableEntry)this.get(i);
            if (i < n) {
                dataOutputStream.writeShort(hmtxTableEntry.advanceWidth);
            }
            dataOutputStream.writeShort(hmtxTableEntry.leftSideBearing);
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n2 = ((HheaTable)trueTypeTableArray[0]).numLongHorMetrics;
        int n3 = ((MaxpTable)trueTypeTableArray[1]).numGlyphs;
        int n4 = 0;
        this.clear();
        for (int i = 0; i < n3; ++i) {
            if (i < n2) {
                n4 = dataInputStream.readUnsignedShort();
            }
            HmtxTableEntry hmtxTableEntry = new HmtxTableEntry();
            hmtxTableEntry.advanceWidth = n4;
            hmtxTableEntry.leftSideBearing = dataInputStream.readShort();
            this.add(hmtxTableEntry);
        }
    }
}

