/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.ListBasedTable;
import com.kreative.bitsnpicas.truetype.PostTableEntry;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostTable
extends ListBasedTable<PostTableEntry> {
    public static final int FORMAT_1 = 65536;
    public static final int FORMAT_2 = 131072;
    public static final int FORMAT_2_5 = 163840;
    public static final int FORMAT_3 = 196608;
    public static final int FORMAT_4 = 262144;
    public static final int ITALIC_ANGLE_ISOMETRIC = -1740967;
    public static final int ITALIC_ANGLE_UPRIGHT = 0;
    public static final int FIXED_PITCH_FALSE = 0;
    public static final int FIXED_PITCH_TRUE = 1;
    public static final int MEM_UNKNOWN = 0;
    public int format = 131072;
    public int italicAngle = 0;
    public int underlinePosition = 0;
    public int underlineThickness = 0;
    public int fixedPitch = 0;
    public int minMemType42 = 0;
    public int maxMemType42 = 0;
    public int minMemType1 = 0;
    public int maxMemType1 = 0;

    @Override
    public String tableName() {
        return "post";
    }

    @Override
    public String[] dependencyNames() {
        return new String[0];
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        dataOutputStream.writeInt(this.format);
        dataOutputStream.writeInt(this.italicAngle);
        dataOutputStream.writeShort(this.underlinePosition);
        dataOutputStream.writeShort(this.underlineThickness);
        dataOutputStream.writeInt(this.fixedPitch);
        dataOutputStream.writeInt(this.minMemType42);
        dataOutputStream.writeInt(this.maxMemType42);
        dataOutputStream.writeInt(this.minMemType1);
        dataOutputStream.writeInt(this.maxMemType1);
        switch (this.format) {
            case 65536: {
                break;
            }
            case 131072: {
                dataOutputStream.writeShort(this.size());
                int n = 258;
                for (PostTableEntry postTableEntry : this) {
                    if (postTableEntry.isInteger()) {
                        dataOutputStream.writeShort(postTableEntry.intValue());
                        continue;
                    }
                    if (!postTableEntry.isString()) continue;
                    dataOutputStream.writeShort(n++);
                }
                for (PostTableEntry postTableEntry : this) {
                    byte[] byArray;
                    if (!postTableEntry.isString()) continue;
                    try {
                        byArray = postTableEntry.stringValue().getBytes("US-ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalStateException("Java is stupid.");
                    }
                    dataOutputStream.writeByte(byArray.length);
                    dataOutputStream.write(byArray);
                    --n;
                }
                if (n == 258) break;
                throw new IllegalStateException("Assertion failed: number of names written <> number of names assigned.");
            }
            case 163840: {
                dataOutputStream.writeShort(this.size());
                for (int i = 0; i < this.size(); ++i) {
                    PostTableEntry postTableEntry = (PostTableEntry)this.get(i);
                    if (!postTableEntry.isInteger()) {
                        throw new IllegalStateException("Invalid entry in Format 2.5 'post' table.");
                    }
                    dataOutputStream.writeByte(postTableEntry.intValue() - i);
                }
                break;
            }
            case 196608: {
                break;
            }
            case 262144: {
                for (int i = 0; i < this.size(); ++i) {
                    PostTableEntry postTableEntry = (PostTableEntry)this.get(i);
                    if (!postTableEntry.isInteger()) {
                        throw new IllegalStateException("Invalid entry in Format 4 'post' table.");
                    }
                    dataOutputStream.writeShort(postTableEntry.intValue());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid format for 'post' table.");
            }
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        this.format = dataInputStream.readInt();
        this.italicAngle = dataInputStream.readInt();
        this.underlinePosition = dataInputStream.readShort();
        this.underlineThickness = dataInputStream.readShort();
        this.fixedPitch = dataInputStream.readInt();
        this.minMemType42 = dataInputStream.readInt();
        this.maxMemType42 = dataInputStream.readInt();
        this.minMemType1 = dataInputStream.readInt();
        this.maxMemType1 = dataInputStream.readInt();
        switch (this.format) {
            case 65536: {
                this.clear();
                break;
            }
            case 131072: {
                int n2;
                int n3 = dataInputStream.readUnsignedShort();
                int[] nArray = new int[n3];
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = dataInputStream.readUnsignedShort();
                    if (nArray[i] <= n4) continue;
                    n4 = nArray[i];
                }
                String[] stringArray = new String[n4 + 1];
                for (n2 = 258; n2 < stringArray.length; ++n2) {
                    byte[] byArray = new byte[dataInputStream.readUnsignedByte()];
                    dataInputStream.readFully(byArray);
                    try {
                        stringArray[n2] = new String(byArray, "US-ASCII");
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalStateException("Java is stupid.");
                    }
                }
                this.clear();
                for (n2 = 0; n2 < n3; ++n2) {
                    int n5 = nArray[n2];
                    String string = stringArray[n5];
                    if (string != null) {
                        this.add(new PostTableEntry(string));
                        continue;
                    }
                    this.add(new PostTableEntry(n5));
                }
                break;
            }
            case 163840: {
                int n6 = dataInputStream.readUnsignedShort();
                this.clear();
                for (int i = 0; i < n6; ++i) {
                    int n7 = i + dataInputStream.readByte();
                    this.add(new PostTableEntry(n7));
                }
                break;
            }
            case 196608: {
                this.clear();
                break;
            }
            case 262144: {
                int n8 = (n - 32) / 2;
                this.clear();
                for (int i = 0; i < n8; ++i) {
                    int n9 = dataInputStream.readUnsignedShort();
                    if (n9 == 65535) {
                        n9 = -1;
                    }
                    this.add(new PostTableEntry(n9));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid format for 'post' table.");
            }
        }
    }
}

