/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgTableEntry
implements Comparable<SvgTableEntry> {
    public int startGlyphID = 0;
    public int endGlyphID = 0;
    public byte[] svgDocument = new byte[0];

    public boolean isCompressed() {
        return this.svgDocument.length >= 18 && this.svgDocument[0] == 31 && this.svgDocument[1] == -117;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = new ByteArrayInputStream(this.svgDocument);
        if (this.isCompressed()) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public OutputStream getOutputStream(boolean bl) throws IOException {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final OutputStream outputStream = bl ? new GZIPOutputStream(byteArrayOutputStream) : byteArrayOutputStream;
        return new OutputStream(){

            public void write(int n) throws IOException {
                outputStream.write(n);
            }

            public void write(byte[] byArray) throws IOException {
                outputStream.write(byArray);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                outputStream.write(byArray, n, n2);
            }

            public void flush() throws IOException {
                outputStream.flush();
                byteArrayOutputStream.flush();
            }

            public void close() throws IOException {
                outputStream.close();
                byteArrayOutputStream.close();
                SvgTableEntry.this.svgDocument = byteArrayOutputStream.toByteArray();
            }
        };
    }

    @Override
    public int compareTo(SvgTableEntry svgTableEntry) {
        return this.startGlyphID - svgTableEntry.startGlyphID;
    }
}

