/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.data.Encoding;
import com.kreative.unicode.data.GlyphList;
import com.kreative.unicode.data.UnicodeUtils;
import com.kreative.unicode.mappings.BOM;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingList {
    private static EncodingList instance = null;
    private final List<Encoding> encodings;
    private final Map<String, Encoding> encodingMap;
    private final List<GlyphList> glyphLists;
    private final Map<String, GlyphList> glyphListMap;

    public static EncodingList instance() {
        if (instance == null) {
            instance = new EncodingList();
        }
        return instance;
    }

    private EncodingList() {
        String string;
        ArrayList<Encoding> arrayList = new ArrayList<Encoding>();
        HashMap<String, Encoding> hashMap = new HashMap<String, Encoding>();
        ArrayList<GlyphList> arrayList2 = new ArrayList<GlyphList>();
        HashMap<String, GlyphList> hashMap2 = new HashMap<String, GlyphList>();
        for (Charset object : Charset.availableCharsets().values()) {
            string = object.displayName().toUpperCase();
            if (string.equals("CESU-8") || string.equals("GB18030") || string.startsWith("ISO-2022-") || string.startsWith("UTF-") || string.equals("X-COMPOUND_TEXT") || string.startsWith("X-EUC") || string.startsWith("X-IBM93") || string.equals("X-IBM964") || string.equals("X-IBM1364") || string.startsWith("X-ISO-2022-") || string.equals("X-JISAUTODETECT") || string.startsWith("X-UTF-") || string.startsWith("X-WINDOWS-5022") || string.startsWith("X-WINDOWS-ISO2022")) continue;
            EncodingList.add(new Encoding(object), arrayList, hashMap, arrayList2, hashMap2, false);
        }
        for (String string2 : BOM.getResourceNames()) {
            string = UnicodeUtils.stripExtension(string2);
            Encoding encoding = new Encoding(string, BOM.getResource(string2));
            EncodingList.add(encoding, arrayList, hashMap, arrayList2, hashMap2, true);
        }
        EncodingList.readDirectory(UnicodeUtils.getTableDirectory("Mappings"), arrayList, hashMap, arrayList2, hashMap2, false);
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        this.encodings = Collections.unmodifiableList(arrayList);
        this.encodingMap = Collections.unmodifiableMap(hashMap);
        this.glyphLists = Collections.unmodifiableList(arrayList2);
        this.glyphListMap = Collections.unmodifiableMap(hashMap2);
    }

    private static void add(Encoding encoding, List<Encoding> list, Map<String, Encoding> map, List<GlyphList> list2, Map<String, GlyphList> map2, boolean bl) {
        if (encoding == null) {
            return;
        }
        String string = encoding.getName().replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        if (bl && map.containsKey(string)) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        for (String object : encoding.getAliases()) {
            hashSet.add(object.replaceAll("[^A-Za-z0-9]", "").toLowerCase());
        }
        list.add(encoding);
        for (String string2 : hashSet) {
            map.put(string2, encoding);
        }
        if (encoding.isMultiByte()) {
            return;
        }
        GlyphList glyphList = encoding.toGlyphList();
        list2.add(glyphList);
        for (String string3 : hashSet) {
            map2.put(string3, glyphList);
        }
    }

    private static void readDirectory(File file, List<Encoding> list, Map<String, Encoding> map, List<GlyphList> list2, Map<String, GlyphList> map2, boolean bl) {
        for (File file2 : file.listFiles()) {
            if (file2.getName().startsWith(".") || file2.getName().endsWith("\r")) continue;
            if (file2.isDirectory()) {
                EncodingList.readDirectory(file2, list, map, list2, map2, bl);
                continue;
            }
            try {
                String string = UnicodeUtils.stripExtension(file2.getName());
                Encoding encoding = new Encoding(string, new FileInputStream(file2));
                EncodingList.add(encoding, list, map, list2, map2, bl);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public List<Encoding> encodings() {
        return this.encodings;
    }

    public List<GlyphList> glyphLists() {
        return this.glyphLists;
    }

    public boolean containsEncoding(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.encodingMap.containsKey(string2);
    }

    public boolean containsGlyphList(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.glyphListMap.containsKey(string2);
    }

    public Encoding getEncoding(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.encodingMap.get(string2);
    }

    public GlyphList getGlyphList(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.glyphListMap.get(string2);
    }

    public int indexOfEncoding(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.encodingMap.containsKey(string2) ? this.encodings.indexOf(this.encodingMap.get(string2)) : -1;
    }

    public int indexOfGlyphList(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.glyphListMap.containsKey(string2) ? this.glyphLists.indexOf(this.glyphListMap.get(string2)) : -1;
    }

    public int lastIndexOfEncoding(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.encodingMap.containsKey(string2) ? this.encodings.lastIndexOf(this.encodingMap.get(string2)) : -1;
    }

    public int lastIndexOfGlyphList(String string) {
        String string2 = string.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        return this.glyphListMap.containsKey(string2) ? this.glyphLists.lastIndexOf(this.glyphListMap.get(string2)) : -1;
    }
}

