{
"/* COMPATIBILITY \n"
"   - HLSL compilers\n"
"   - Cg   compilers\n"
"*/\n"
"\n"
"struct input\n"
"{\n"
"   float2 video_size;\n"
"   float2 texture_size;\n"
"   float2 output_size;\n"
"   float frame_count;\n"
"   float frame_direction;\n"
"   float frame_rotation;\n"
"};\n"
"\n"
"void main_vertex\n"
"(\n"
"   float4 position : POSITION,\n"
"   out float4 oPosition : POSITION,\n"
"   uniform float4x4 modelViewProj,\n"
"\n"
"   float4 color : COLOR,\n"
"   out float4 oColor : COLOR,\n"
"\n"
"   float2 tex : TEXCOORD,\n"
"   out float2 oTex : TEXCOORD\n"
")\n"
"{\n"
"   oPosition = mul(modelViewProj, position);\n"
"   oColor = color;\n"
"   oTex = tex;\n"
"}\n"
"\n"
"float seed_random (float2 coords, float frame_cnt)\n"
"{\n"
"   frame_cnt = cos(frame_cnt);\n"
"   float2 constant1 = frame_cnt * float2(142.0/11.0, 1017.0/13.0);\n"
"   float constant2 = frame_cnt * 481344.0 / 11.0;\n"
"   return saturate(frac(sin(dot(coords, constant1)) * constant2) + 0.2);\n"
"}\n"
"\n"
"float4 main_fragment (float2 tex : TEXCOORD, uniform sampler2D s0 : TEXUNIT0, uniform input IN) : COLOR\n"
"{\n"
"   float2 texelSize = 1.0 / IN.texture_size;\n"
"   float rand = seed_random(tex, IN.frame_count);\n"
"   float4 color = tex2D(s0, tex.xy);\n"
"   color = (color - 16.0/255.0) * (255.0/219.0);\n"
"   return color * rand;\n"
"}\n"
"\n"
"\n"
},
