// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"


namespace Rivet {


  /// @brief e+e- -> pi+pi-pi0
  class BABAR_2004_I656680 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BABAR_2004_I656680);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      book(_num3pi, 1, 1, 1);

      for (const string& en : _num3pi.binning().edges<0>()) {
        const double eval = std::stod(en)*GeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en;
          break;
        }
      }

      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      if(ntotal!=3) vetoEvent;
      if(nCount[-211]==1&&nCount[211]==1&&nCount[111]==1) {
        _num3pi->fill(_sqs);
      }

    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_num3pi, crossSection()/ sumOfWeights() /nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _num3pi;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BABAR_2004_I656680);


}
