/*
 * Copyright (C) 2014-2025 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#include<QStringBuilder>

#include "src/datovka_shared/app_version_info.h"

#define textLineNL(text) \
	(QString("‣ ") % (text) % QLatin1String("<br>"))

QString AppVersionInfo::releaseNewsText(void)
{
	QString content;

	content.append(textLineNL(tr("Simplified the tag assignment dialogue. Tag assignment can be edited by checking or unchecking items in a provided list.")));
	content.append(textLineNL(tr("Tag assignment and editing of available tags are separate actions. Both can be added to available tool bars in the main window.")));
	content.append(textLineNL(tr("Added a simple tool that should help with data recovery from corrupted database files. It can be found in the '%1' menu.").arg(tr("Tools"))));
	content.append(textLineNL(tr("Added the possibility to increase the text size in the application. The new setting can be found in '%1' on the '%2' tab.").arg(tr("Preferences")).arg(tr("Interface"))));
	content.append(textLineNL(tr("Displaying release news in the application.")));
	content.append(textLineNL(tr("Displaying error dialogues on application start up when application configuration cannot be accessed or has been corrupted.")));
	content.append(textLineNL(tr("Showing an error pop up at the status bar when any message database cannot be opened.")));
	content.append(textLineNL(tr("Modified custom themes to better fit the light or dark system environments.")));
	content.append(textLineNL(tr("Showing download progress and speed in download message dialogue.")));
	content.append(textLineNL(tr("Fixed attachment entry duplication when repeatedly downloading high-volume messages.")));
	content.append(textLineNL(tr("Using MTOM/XOP to download high-volume messages.")));

	return content;
}
