# 7.1 Changelog

## [7.1.7] - 2022-04-26

### Engine Updates and Fixes

- Fix for partial PowerShell module search paths, that can be resolved to CWD locations
- Do not include node names when sending telemetry. (#16981) to v7.1.7 (Internal 20187,Internal 20260)

### Tests

- Re-enable `PowerShellGet` tests targeting PowerShell gallery (#17062)
- Skip failing scriptblock tests (#17093)

### Build and Packaging Improvements

<details>

<summary>

<p>Update .NET SDK to 5.0.407</p>

</summary>

<ul>
<li>Fix build failure in `generate checksum file for packages` step - v7.1.7 (Internal 20274)</li>
<li>Updated files.wxs for 7.1.7 (Internal 20210)</li>
<li>Updated to .NET 5.0.16 / SDK 5.0.407 (Internal 20131)</li>
<li>Update Ubuntu images to use Ubuntu 20.04 (#15906)</li>
<li>Update dotnet-install script download link (Internal 19950)</li>
<li>Create checksum file for global tools (#17056) (Internal 19928)</li>
<li>Make sure global tool packages are published in stable build (Internal 19624)</li>
</ul>

</details>

[7.1.7]: https://github.com/PowerShell/PowerShell/compare/v7.1.6...v7.1.7

## [7.1.6] - 2022-03-16

### Build and Packaging Improvements

<details>

<summary>

<p>Update .NET SDK to 5.0.406</p>

</summary>

<ul>
<li>Update the mapping file (#16316, Internal 19528)</li>
<li>Remove code that handles dotnet5 feed (Internal 19525)</li>
<li>Fix issues in release build (#16332)</li>
<li>Enable ARM64 packaging for macOS (#15768)</li>
<li>Update feed and analyzer dependency (#16327)</li>
<li>Only upload stable <code>buildinfo</code> for stable releases (#16251)</li>
<li>Opt-in to build security monitoring (#16911)</li>
<li>Update experimental feature json files (#16838)</li>
<li>Ensure alpine and arm SKUs have the PowerShell configuration file with experimental features enabled (#16823)</li>
<li>Remove WiX install (#16834)</li>
<li>Add Linux package dependencies for packaging (#16807)</li>
<li>Switch to our custom images for build and release (#16801)</li>
<li>Remove all references to <code>cmake</code> for the builds in this repo (#16578)</li>
<li>Register NuGet source when generating <code>CGManifest</code> (#16570)</li>
<li>Update images used for release (#16580)</li>
<li>Add GitHub Workflow to keep notices up to date (#16284)</li>
<li>Update the <code>vmImage</code> and PowerShell root directory for macOS builds (#16611)</li>
<li>Add Software Bill of Materials to the main packages (#16202, #16641, #16711)</li>
<li>Update macOS build image and root folder for build (#16609)</li>
<li>Add diagnostics used to take corrective action when releasing <code>buildInfo</code> JSON file (#16404)</li>
<li>Add checkout to build json stage to get <code>ci.psm1</code> (#16399)</li>
</ul>

</details>

[7.1.6]: https://github.com/PowerShell/PowerShell/compare/v7.1.5...v7.1.6

## [7.1.5] - 2021-10-14

### Engine Updates and Fixes

- Handle error from unauthorized access when removing `AppLocker` test files (#15881)
- Test more thoroughly whether a command is `Out-Default` for transcription scenarios (#15653)
- Handle error when the telemetry mutex cannot be created (#15574) (Thanks @gukoff!)
- Configure `ApplicationInsights` to not send cloud role name (Internal 17100)
- Disallow `Add-Type` in NoLanguage mode on a locked down machine (Internal 17522)

### Tools

- Add `.stylecop` to `filetypexml` and format it (#16025)

### Build and Packaging Improvements

<details>

<summary>
<p>Bump .NET SDK to 5.0.402</p>
</summary>

<ul>
<li>Upgrade <code>set-value</code> package for markdown test (#16196)</li>
<li>Sign the .NET <code>createdump</code> executable (#16229)</li>
<li>Move vPack build to 1ES Pool (#16169)</li>
<li>Update to .NET SDK 5.0.402 (Internal 17537)</li>
<li>Move from PkgES hosted agents to 1ES hosted agents (#16023)</li>
<li>Fix the macOS build by updating the pool image name (#16010)</li>
<li>Use Alpine 3.12 for building PowerShell for Alpine Linux (#16008)</li>
</ul>

</details>

### Documentation and Help Content

- Fix example nuget.config (#14349)

[7.1.5]: https://github.com/PowerShell/PowerShell/compare/v7.1.4...v7.1.5

## [7.1.4] - 2021-08-12

### Build and Packaging Improvements

<details>

<summary>
Bump .NET SDK to version 5.0.400
</summary>

<ul>
<li>Remove the cat file from <code>PSDesiredStateConfiguration</code> module (Internal 16723)</li>
<li>Update .NET SDK version and other packages (Internal 16715)</li>
</ul>

</details>

[7.1.4]: https://github.com/PowerShell/PowerShell/compare/v7.1.3...v7.1.4

## [7.1.3] - 2021-03-11

### Engine Updates and Fixes

- Remove the 32K character limit on the environment block for `Start-Process` (#14111)
- Fix webcmdlets to properly construct URI from body when using `-NoProxy` (#14673)

### General Cmdlet Updates and Fixes

- Fix `PromptForCredential()` to add `targetName` as domain (#14504)

### Build and Packaging Improvements

<details>

<summary>

Bump .NET SDK to 5.0.4

</summary>

<ul>
<li>Bump .NET SDK to 5.0.4 (Internal 14775)</li>
<li>Disable running markdown link verification in release build CI (#14971, #14974, #14975)</li>
<li>Use template that disables component governance for CI (#14938)</li>
<li>Declare which variable group is used for checking the blob in the release build (#14970)</li>
<li>Add suppress for nuget multi-feed warning (#14893)</li>
<li>Disable code signing validation where the file type is not supported (#14885)</li>
<li>Install wget on <code>CentOS</code> 7 docker image (#14857)</li>
<li>Fix install-dotnet download (#14856)</li>
<li>Make universal Deb package based on deb package spec (#14681)</li>
<li>Fix release build to upload global tool packages to artifacts (#14620)</li>
<li>Update <code>ini</code> component version in test <code>package.json</code> (#14454)</li>
<li>Add manual release automation steps and improve changelog script (#14445)</li>
<li>Update markdown test packages with security fixes (#14145)</li>
<li>Fix a typo in the <code>Get-ChangeLog</code> function (#14129)</li>
<li>Disable global tool copy to unblock release</li>
</ul>

</details>

[7.1.3]: https://github.com/PowerShell/PowerShell/compare/v7.1.2...v7.1.3

## [7.1.2] - 2021-02-11

### Build and Packaging Improvements

<details>

<summary>
Bump .NET SDK to version <code>5.0.103</code>
</summary>

<ul>
<li>Fix third party signing for files in sub-folders (#14751)</li>
<li>Bump .NET SDK to version 5.0.103 (Internal 14459)</li>
<li>Publish the global tool package for stable release</li>
</ul>

</details>

[7.1.2]: https://github.com/PowerShell/PowerShell/compare/v7.1.1...v7.1.2

## [7.1.1] - 2021-01-14

### General Cmdlet Updates and Fixes

- Avoid an exception if file system does not support reparse points (#13634) (Thanks @iSazonov!)
- Make AppLocker Enforce mode take precedence over UMCI Audit mode (#14353)

### Code Cleanup

- Fix syntax error in Windows packaging script (#14377)

### Build and Packaging Improvements

<details>

<ul>
<li>Use one feed in each nuget.config in official builds (#14363)</li>
<li>Fix path signed RPMs are uploaded from in release build (#14424)</li>
<li>Fix issue with unsigned build (#14367)</li>
<li>Move macOS and NuGet packages to ESRP signing (#14324)</li>
<li>Move Windows packages signing to use ESRP (#14060)</li>
<li>Move Linux packages to ESRP signing (#14210)</li>
<li>Migrate 3rd party signing to ESRP (#14010)</li>
<li>Don't do a shallow checkout (#13992)</li>
<li>Move to ESRP signing for Windows files (#13988)</li>
<li>Add checkout step to release build templates (#13840)</li>
</ul>

</details>

[7.1.1]: https://github.com/PowerShell/PowerShell/compare/v7.1.0...v7.1.1

## [7.1.0] - 2020-11-11

### Engine Updates and Fixes

- Fix a logic bug in `MapSecurityZone` (#13921) (Thanks @iSazonov!)

### General Cmdlet Updates and Fixes

- Update `pwsh -?` output to match docs (#13748)

### Tests

- `markdownlint` security updates (#13730)

### Build and Packaging Improvements

<details>

<ul>
<li>Fixes to release pipeline for GA release (Internal 13410)</li>
<li>Add validation and dependencies for <code>Ubuntu 20.04</code> distribution to packaging script (#13993)</li>
<li>Change PkgES Lab to unblock build (Internal 13376)</li>
<li>Add .NET install workaround for RTM (#13991)</li>
<li>Bump <code>Microsoft.PowerShell.Native</code> version from <code>7.1.0-rc.2</code> to <code>7.1.0</code> (#13976)</li>
<li>Bump <code>PSReadLine</code> version to <code>2.1.0</code> (#13975)</li>
<li>Bump .NET to version <code>5.0.100-rtm.20526.5</code> (#13920)</li>
<li>Update script to use .NET RTM feeds (#13927)</li>
</ul>

</details>

[7.1.0]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-rc.2...v7.1.0

## [7.1.0-rc.2] - 2020-10-20

### Engine Updates and Fixes

- Rename `Get-Subsystem` to `Get-PSSubsystem` and fix two related minor issues (#13765)
- Add missing `PSToken` token table entries to fix the `PSParser` API (#13779)
- Add additional PowerShell modules to the tracked modules list (#12183)
- Fix blocking wait when starting file associated with a Windows application (#13750)
- Revert `PSNativePSPathResolution` to being an experimental feature (#13734)

### General Cmdlet Updates and Fixes

- Emit warning if `ConvertTo-Json` exceeds `-Depth` value (#13692)

### Build and Packaging Improvements

- Change Linux package script call to publish to the production repository in release builds (#13714)
- Update `PSReadLine` version to `2.1.0-rc1` (#13777)
- Move PowerShell build to dotnet `5.0-RC.2` (#13780)
- Bump `Microsoft.PowerShell.Native` to `7.1.0-rc.2` (#13794)

[7.1.0-rc.2]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-rc.1...v7.1.0-rc.2

## [7.1.0-rc.1] - 2020-09-29

### Engine Updates and Fixes

- Make fixes to `ComInterop` code as suggested by .NET team (#13533)

### General Cmdlet Updates and Fixes

- Fix case where exception message contains just ``"`n"`` on Windows (#13684)
- Recognize `CONOUT$` and `CONIN$` as reserved device names (#13508) (Thanks @davidreis97!)
- Fix `ConciseView` for interactive advanced function when writing error (#13623)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @soccypowa</p>

</summary>

<ul>
<li>Simplify logical negation (#13555) (Thanks @xtqqczze!)</li>
<li>Fixed the indentation of the help content for <code>-nologo</code> (#13557) (Thanks @soccypowa!)</li>
</ul>

</details>

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@heaths</p>

</summary>

<ul>
<li>Bump <code>NJsonSchema</code> from 10.1.24 to 10.1.26 (#13586)</li>
<li>Bump <code>PowerShellGet</code> from 2.2.4 to 2.2.5 (#13683)</li>
<li>Bump <code>Microsoft.ApplicationInsights</code> from 2.14.0 to 2.15.0 (#13639)</li>
<li>Update PowerShell to build against dotnet 5.0-RC.1 (#13643)</li>
<li>Write the <code>InstallLocation</code> to fixed registry key (#13576) (Thanks @heaths!)</li>
</ul>

</details>

### Documentation and Help Content

- Update `README` and `metadata.json` for `7.1.0-preview.7` release (#13565)

[7.1.0-rc.1]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-preview.7...v7.1.0-rc.1

## [7.1.0-preview.7] - 2020-09-08

### Breaking Changes

- Fix `$?` to not be `$false` when native command writes to `stderr` (#13395)

### Engine Updates and Fixes

- Initial work of the subsystem plugin model (for minimal powershell) (#13186)
- Optimize `GetSystemLockdownPolicy` for non-lockdown scenarios (#13438)

### General Cmdlet Updates and Fixes

- Revert "Add the parameter `-Paged` to `Get-Help` to support paging (#13374)" (#13519)
- Add support for `TLS` 1.3 in Web cmdlets (#13409) (Thanks @iSazonov!)
- Add null check for `args` in `CommandLineParser` (#13451) (Thanks @iSazonov!)
- Process reparse points for Microsoft Store applications (#13481) (Thanks @iSazonov!)
- Move `PSNullConditionalOperators` feature out of experimental (#13529)
- Move `PSNativePSPathResolution` feature out of Experimental (#13522)
- Use field if property does not exist for `ObRoot` when using PowerShell Direct to container (#13375) (Thanks @hemisphera!)
- Suppress `UTF-7` obsolete warnings (#13484)
- Avoid multiple enumerations of an `IEnumerable<Expression>` instance in `Compiler.cs` (#13491)
- Change `Add-Type -OutputType` to not support `ConsoleApplication` and `WindowsApplication` (#13440)
- Create warnings when `UTF-7` is specified as an encoding (#13430)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @tamasvajk</p>

</summary>

<ul>
<li>Add single blank line after copyright header (#13486) (Thanks @xtqqczze!)</li>
<li>Use read-only auto-implemented properties (#13507) (Thanks @xtqqczze!)</li>
<li>Use boolean instead of bitwise operators on bool values (#13506) (Thanks @xtqqczze!)</li>
<li>Fix erroneous assert (#13495) (Thanks @tamasvajk!)</li>
<li>Cleanup: remove duplicate words in comments (#13539) (Thanks @xtqqczze!)</li>
<li>Reformat <code>StringUtil</code> (#13509) (Thanks @xtqqczze!)</li>
<li>Use <code>uint</code> instead of <code>long</code> for <code>PDH</code> constants (#13502) (Thanks @xtqqczze!)</li>
<li>Cleanup: Remove redundant empty lines (#13404) (Thanks @xtqqczze!)</li>
<li>Add <code>StringUtil.Format</code> overload to avoid unnecessary allocations (#13408) (Thanks @xtqqczze!)</li>
<li>Fix test hooks for <code>CommandLineParameterParser</code> (#13459)</li>
<li>Remove redundant delegate creation (#13441) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- vscode: Add `editorconfig` to recommended extensions (#13537) (Thanks @xtqqczze!)
- Remove the out-dated `ZapDisable` related code from `build.psm1` (#13350) (Thanks @jackerr3!)

### Tests

- Disable `WMF` download link validation test (#13479)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@yecril71pl</p>

</summary>

<ul>
<li>Add <code>Microsoft.NET.Test.Sdk</code> dependency (Internal 12589)</li>
<li>Update .NET NuGet package version to <code>5.0.0-preview.8.20407.11</code> (Internal 12555)</li>
<li>Update to .NET 5 preview 8 (#13530)</li>
<li>Change stage dependency for docker release stage in release pipeline (#13512)</li>
<li>Bump <code>Microsoft.NET.Test.Sdk</code> from 16.7.0 to 16.7.1 (#13492)</li>
<li>Create the folder before copying the global tools (#13476)</li>
<li>A few fixes to the release pipeline (#13473)</li>
<li>Bump <code>Markdig.Signed</code> from 0.20.0 to 0.21.1 (#13463)</li>
<li>Add a pre-check for git to <code>build.psm1</code> (#13227) (Thanks @yecril71pl!)</li>
</ul>

</details>

### Documentation and Help Content

- Update `README` links and `metadata.json` for `7.1.0-preview.6` (#13437)

[7.1.0-preview.7]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-preview.6...v7.1.0-preview.7

## [7.1.0-preview.6] - 2020-08-17

### Breaking Changes

- Rename `-FromUnixTime` to `-UnixTimeSeconds` on `Get-Date` to allow Unix time input (#13084) (Thanks @aetos382!)
- Make `$ErrorActionPreference` not affect `stderr` output of native commands (#13361)
- Allow explicitly specified named parameter to supersede the same one from hashtable splatting (#13162)

### Engine Updates and Fixes

- Refactor command line parser to do early parsing (#11482) (Thanks @iSazonov!)
- Add support for some .NET intrinsic type converters (#12580) (Thanks @iSazonov!)
- Refresh and enable the `ComInterop` code in PowerShell (#13304)

### Experimental Features

- Add `-Runspace` parameter to all `*-PSBreakpoint` cmdlets (#10492) (Thanks @KirkMunro!)

### General Cmdlet Updates and Fixes

- Fix error message from new symbolic link missing target (#13085) (Thanks @yecril71pl!)
- Make the parameter `args` non-nullable in the public `ConsoleHost` APIs (#13429)
- Add missing dispose for `CancellationTokenSource` (#13420) (Thanks @Youssef1313!)
- Add the parameter `-Paged` to `Get-Help` to support paging (#13374)
- Fix `Get-Help` not properly displaying if parameter supports wildcards (#13353) (Thanks @ThomasNieto!)
- Update `pwsh` help for `-InputFormat` parameter (#13355) (Thanks @sethvs!)
- Declare MIT license for files copied from Roslyn (#13305) (Thanks @xtqqczze!)
- Improve `BigInteger` casting behaviors (#12629) (Thanks @vexx32!)
- Fix `Get-Acl -LiteralPath "HKLM:Software\Classes\*"` behavior (#13107) (Thanks @Shriram0908!)
- Add `DefaultVisit` method to the visitor interface and class (#13258)
- Fix conflicting shorthand switch `-s` (STA) for `pwsh` (#13262) (Thanks @iSazonov!)
- Change `Read-Host -MaskInput` to use existing `SecureString` path, but return as plain text (#13256)
- Remove `ComEnumerator` as COM objects using `IEnumerator` is now supported in .NET 5.0 (#13259)
- Use temporary personal path at Runspace startup when the 'HOME' environment variable is not defined (#13239)
- Fix `Invoke-Command` to detect recursive call of the same history entry (#13197)
- Change `pwsh` executable `-inputformat` switch prefix `-in` to `-inp` to fix conflict with `-interactive` (#13205) (Thanks @iSazonov!)
- Handle WSL filesystem path when analyze security zone of a file (#13120)
- Make other switches mandatory in `Split-Path` (#13150) (Thanks @kvprasoon!)
- New Fluent Design icon for PowerShell 7 (#13100) (Thanks @sarthakmalik!)
- Fix `Move-Item` to support cross-mount moves on Unix (#13044)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @yecril71pl, @ThomasNieto, @dgoldman-msft</p>

</summary>

<ul>
<li>Use null check with pattern-matching instead of <code>object.ReferenceEquals</code> (#13065) (Thanks @xtqqczze!)</li>
<li>Fix comparison of value type object to null (#13285) (Thanks @xtqqczze!)</li>
<li>Use <code>is</code> operator instead of <code>as</code> operator (#13287) (Thanks @xtqqczze!)</li>
<li>Change <code>SwitchParameter</code> fields to properties (#13291) (Thanks @xtqqczze!)</li>
<li>Change &quot;operable&quot; to &quot;executable&quot; (#13281) (Thanks @yecril71pl!)</li>
<li>Remove <code>AssemblyInfo</code> property from list views (#13331) (Thanks @ThomasNieto!)</li>
<li>Use <code>is not</code> syntax where appropriate and remove unnecessary parentheses (#13323) (Thanks @xtqqczze!)</li>
<li>Remove unreachable code in CustomShellCommands.cs (#13316) (Thanks @xtqqczze!)</li>
<li>Add copyright header to <code>.editorconfig</code> and update files (#13306) (Thanks @xtqqczze!)</li>
<li>Fix typo in Out-File.cs and Out-Printer.cs (#13298) (Thanks @dgoldman-msft!)</li>
<li>Fix <code>SA1026CodeMustNotContainSpaceAfterNewKeywordInImplicitlyTypedArrayAllocation</code> (#13249) (Thanks @xtqqczze!)</li>
<li>Remove usage of do statement to create an infinite loop (#13137) (Thanks @xtqqczze!)</li>
<li>Use <code>int</code> instead of <code>uint</code> in places where it's more appropriate (#13141) (Thanks @xtqqczze!)</li>
<li>Use <code>int</code> instead of <code>long</code> to avoid <code>Interlocked.Read</code> (#13069) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Fix `dotnet` install errors (#13387)
- Increase the timeout of Windows daily build to 90 minutes (#13354)
- Update the `dependabot` configuration to version 2 (#13230) (Thanks @RDIL!)
- Fix `Test-XUnitTestResults` function (#13270) (Thanks @iSazonov!)
- Update `.devcontainer` to use nightly docker SDK images (#13128)

### Tests

- Mark `Test-Connection -TraceRoute` tests as pending (#13310)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @iSazonov, @77, @WorrenB</p>

</summary>

<ul>
<li>Update <code>README.md</code> and <code>metadata.json</code> for next release (#13059)</li>
<li>Create release pipeline as a yaml pipeline (#13394)</li>
<li>Update infrastructure to consume private builds from .NET (#13427)</li>
<li>Fix breaks in packages daily build due to macOS signing changes (#13421)</li>
<li>Sign individual files for macOS PKG (#13392)</li>
<li>Disable code sign validation on jobs that do not sign (#13389)</li>
<li>Bump <code>PSReadLine</code> from 2.0.2 to 2.0.4 (#13240)</li>
<li>Update build documentation for Visual Studio 2019 dependency (#13336) (Thanks @xtqqczze!)</li>
<li>Bump <code>Microsoft.CodeAnalysis.CSharp</code> from 3.6.0 to 3.7.0 (#13360)</li>
<li>Bump <code>Microsoft.NET.Test.Sdk</code> from 16.6.1 to 16.7.0 (#13364)</li>
<li>Bump <code>xunit.runner.visualstudio</code> from 2.4.2 to 2.4.3 (#13343)</li>
<li>Use Authenticode certificate for MSIX signing (#13330)</li>
<li>Add default help content to the assets folder (#13257)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.7.20366.2</code> to <code>5.0.100-preview.7.20366.15</code> (#13200)</li>
<li>Set C# language version to preview/9.0 (#13090) (Thanks @iSazonov!)</li>
<li>Use <code>pwsh</code> for build and test of package in CI build (#13223)</li>
<li>Remove <code>rcedit</code> dependency, move daily ico dependency to props file (#13123)</li>
<li>Bump NJsonSchema from 10.1.23 to 10.1.24 (#13214)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.7.20364.3</code> to <code>5.0.100-preview.7.20366.2</code> (#13192)</li>
<li>Add support for installing arm64 MSIX package. (#13043) (Thanks @77!)</li>
<li>Fix Azure file copy issues in release build (#13182)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.7.20358.6</code> to <code>5.0.100-preview.7.20364.3</code> (#13155)</li>
<li>Fix Azure file copy break in Azure DevOps (#13173)</li>
<li>Bump <code>Xunit.SkippableFact</code> from <code>1.4.8</code> to <code>1.4.13</code> (#13143)</li>
<li>Add new chibi svg version of the avatar (#13160) (Thanks @WorrenB!)</li>
<li>Refactor MSI code to make it easier to add a WiX exe installer (#13139)</li>
<li>Disable ReadyToRun for debug build (#13144) (Thanks @iSazonov!)</li>
<li>Add new chibi version of the avatar (#13140)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.7.20356.2</code> to <code>5.0.100-preview.7.20358.6</code> (#13134) (Thanks @github-actions[bot]!)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.6.20318.15</code> to <code>5.0.100-preview.7.20356.2</code> (#13125) (Thanks @github-actions[bot]!)</li>
</ul>

</details>

### Documentation and Help Content

- Fix/clarify instructions for running Start-PSPester tests (#13373)
- Improve inline documentation for `VerbInfo` (#13265) (Thanks @yecril71pl!)
- Improve the wording of inline comments in the help system (#13274) (Thanks @yecril71pl!)
- Correct grammar in `README.md` and other docs (#13269) (Thanks @tasnimzotder!)
- Add "GitHub Actions Python builds" to `ADOPTERS.md` (#13228) (Thanks @brcrista!)
- Update change logs for `6.2.x` and `7.0.x` (#13194)
- Update `README.md` and `metadata.json` for the v7.0.3 release (#13187)

[7.1.0-preview.6]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-preview.5...v7.1.0-preview.6

## [7.1.0-preview.5] - 2020-07-06

### Engine Updates and Fixes

- Ensure assemblies listed in the module manifest `FileList` field are not loaded (#12968)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze</p>

</summary>

<ul>
<li>Code performance fixes (#12956) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Add missing `.editorconfig` settings present in `dotnet/runtime` (#12871) (Thanks @xtqqczze!)

### Tests

- Add new test for `Format-Custom` to avoid data loss (#11393) (Thanks @iSazonov!)

### Build and Packaging Improvements

<details>
<summary>

<p>Fixed upgrade code in MSI package.</p>

</summary>
<ul>
<li>Change log for v7.1.0-preview.5 (Internal 11880)</li>
<li>Fix Path for the Preview MSI (#13070)</li>
<li>Correct stable and preview upgrade codes for <code>MSI</code> (#13036)</li>
<li>Changelog for `v7.1.0-preview.4` (Internal 11841)</li>
<li>Fix NuGet package compliance issues (#13045)</li>
<li>Bump <code>xunit.runner.visualstudio</code> from <code>2.4.1</code> to<code> 2.4.2</code> (#12874)</li>
<li>Bump NJsonSchema from `10.1.21` to `10.1.23` (#13032) (#13022)</li>
</ul>

</details>

### Documentation and Help Content

- Fix links for MSI packages to point to `7.1.0-preview.3` (#13056)
- Add update `packages.microsoft.com` step to distribution request template. (#13008)
- Update `windows-core.md` (#13053) (Thanks @xtqqczze!)
- Add `@rjmholt` to maintainers list (#13033)
- Update docs for `v7.1.0-preview.4` release (#13028)

## [7.1.0-preview.4] - 2020-06-25

### Breaking Changes

- Make the switch parameter `-Qualifier` not positional for `Split-Path` (#12960) (Thanks @yecril71pl!)
- Resolve the working directory as literal path for `Start-Process` when it's not specified (#11946) (Thanks @NoMoreFood!)
- Make `-OutFile` parameter in web cmdlets to work like `-LiteralPath` (#11701) (Thanks @iSazonov!)

### Engine Updates and Fixes

- Ensure null-coalescing LHS is evaluated only once (#12667)
- Fix path handling bug in `PSTask` (#12554) (Thanks @IISResetMe!)
- Remove extra line before formatting group (#12163) (Thanks @iSazonov!)
- Make module formatting not generate error with strict mode (#11943)
- Adding more ETW logs to WSMan plugin (#12798) (Thanks @krishnayalavarthi!)
- Restrict loading of `amsi.dll` to `system32` folder (#12730)

### General Cmdlet Updates and Fixes

- Fix `NullReferenceException` in `CommandSearcher.GetNextCmdlet` (#12659) (Thanks @powercode!)
- Prevent `NullReferenceException` in Unix computer cmdlets with test hooks active (#12651) (Thanks @vexx32!)
- Fix issue in `Select-Object` where `Hashtable` members (e.g. `Keys`) cannot be used with `-Property` or `-ExpandProperty` (#11097) (Thanks @vexx32!)
- Fix conflicting shorthand switch `-w` for pwsh (#12945)
- Rename the `CimCmdlet` resource file (#12955) (Thanks @iSazonov!)
- Remove use of `Test-Path` in `ConciseView` (#12778)
- Flag `default` switch statement condition clause as keyword (#10487) (Thanks @msftrncs!)
- Add parameter `SchemaFile` to `Test-Json` cmdlet (#11934) (Thanks @beatcracker!)
- Bring back Certificate provider parameters (#10622) (Thanks @iSazonov!)
- Fix `New-Item` to create symbolic link to relative path target (#12797) (Thanks @iSazonov!)
- Add `CommandLine` property to Process (#12288) (Thanks @iSazonov!)
- Adds `-MaskInput` parameter to `Read-Host` (#10908) (Thanks @davinci26!)
- Change `CimCmdlets` to use `AliasAttribute` (#12617) (Thanks @thlac!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @sethvs, @romero126, @kvprasoon, @powercode</p>

</summary>

<ul>
<li>Use <code>nameof</code> operator (#12716) (Thanks @xtqqczze!)</li>
<li>Fix comments in Mshexpression.cs (#12711) (Thanks @sethvs!)</li>
<li>Formatting: remove duplicate semicolons (#12666) (Thanks @xtqqczze!)</li>
<li>Replace <code>SortedList</code> with <code>Generic.SortedList&lt;TKey,TValue&gt;</code> (#12954) (Thanks @xtqqczze!)</li>
<li>Use HashSet instead of Hashtable with null values (#12958) (Thanks @xtqqczze!)</li>
<li>Rename <code>CopyItem.Tests.ps1</code> to <code>Copy-Item.Tests.ps1</code> to match other tests (#10701) (Thanks @romero126!)</li>
<li>Fix <code>RCS1114: Remove redundant delegate creation</code> (#12917) (Thanks @xtqqczze!)</li>
<li>Code redundancy fixes (#12916) (Thanks @xtqqczze!)</li>
<li>Update the PowerShell modules to use the new Help URI (#12686)</li>
<li>Reorder modifiers according to preferred order (#12864) (Thanks @xtqqczze!)</li>
<li>Expand numberOfPowershellRefAssemblies list capacity (#12840) (Thanks @xtqqczze!)</li>
<li>Add readonly modifier to internal static members (#11777) (Thanks @xtqqczze!)</li>
<li>cleanup: Use coalesce expression (#12829) (Thanks @xtqqczze!)</li>
<li>Add missing assessibility modifiers (#12820) (Thanks @xtqqczze!)</li>
<li>Use <code>t_</code> naming convention for ThreadStatic members (#12826) (Thanks @xtqqczze!)</li>
<li>Formatting: Add empty line between declarations (#12824) (Thanks @xtqqczze!)</li>
<li>Clarify defaultRefAssemblies list capacity in AddType.cs (#12520) (Thanks @xtqqczze!)</li>
<li>Fixing &quot;Double &quot;period&quot; (..) in message for System.InvalidOperationException&quot; (#12758) (Thanks @kvprasoon!)</li>
<li>Rethrow to preserve stack details for better maintainability (#12723) (Thanks @xtqqczze!)</li>
<li>Delete license.rtf (#12738) (Thanks @xtqqczze!)</li>
<li>Nullable annotations for CommandSearcher (#12733) (Thanks @powercode!)</li>
<li>Redundancy: Remove 'partial' modifier from type with a single part (#12725) (Thanks @xtqqczze!)</li>
<li>Remove phrase 'All rights reserved' from Microsoft copyright statements (#12722) (Thanks @xtqqczze!)</li>
<li>IDictionary -&gt; IDictionary&lt;string, FunctionInfo&gt; for FunctionTable (#12658) (Thanks @powercode!)</li>
</ul>

</details>

### Tools

- Use correct isError parameter with Write-Log (#12989)
- Disable `NonPrivateReadonlyFieldsMustBeginWithUpperCaseLetter` rule in `StyleCop` (#12855) (Thanks @xtqqczze!)
- Add @TylerLeonhardt to PowerShell team list to correct changelog generation (#12927)
- Enable the upload of `ETW` traces to `CLR CAP` in Windows daily build (#12890)
- Prevent GitHub workflow for daily dotnet build updates from running in forks (#12763) (Thanks @bergmeister!)
- Add GitHub action for PR creation and `Wix` file generation logic (#12748)

### Tests

- Remove duplicate tests from `Measure-Object.Tests.ps1` (#12683) (Thanks @sethvs!)
- Fix tests to not write errors to console (#13010)
- Make sure tabcompletion tests run (#12981)
- Remove dependency on DNS for `Test-Connection` tests on macOS (#12943)
- Restore `markdownlint` tests (#12549) (Thanks @xtqqczze!)
- Wrap tests in pester blocks (#12700) (Thanks @xtqqczze!)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@iSazonov, @kvprasoon, @Saancreed, @heaths, @xtqqczze</p>

</summary>

<ul>
<li>Update Distribution_Request.md</li>
<li>Bump NJsonSchema from 10.1.15 to 10.1.16 (#12685)</li>
<li>Disable uploading Symbols package (#12687)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.5.20279.10</code> to <code>5.0.100-preview.6.20318.15</code> (#13018)</li>
<li>Remove component ref when re-generating the wix file (#13019)</li>
<li>Make sure icons are added to MSI staging folder (#12983)</li>
<li>Update <code>DotnetRutimeMetadata.json</code> to point to preview 6 (#12972)</li>
<li>Bump PSReadLine from <code>2.0.1</code> to <code>2.0.2</code> (#12909)</li>
<li>Bump <code>NJsonSchema</code> from 10.1.18 to 10.1.21 (#12944)</li>
<li>Check if Azure Blob exists before overwriting (#12921)</li>
<li>Enable skipped tests (#12894) (Thanks @iSazonov!)</li>
<li>Fix break in package build by pinning <code>ffi</code> version to <code>1.12</code> (#12889)</li>
<li>Upgrade <code>APIScan</code> version (#12876)</li>
<li>Make contributors unique in Release notes (#12878) (Thanks @kvprasoon!)</li>
<li>Update Linux daily CI to run in a single agent &amp; collect traces (#12866)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.5.20278.13</code> to <code>5.0.100-preview.5.20279.10</code> (#12844) (Thanks @github-actions[bot]!)</li>
<li>Sign the <code>MSIX</code> files for the store (#12582)</li>
<li>Update the CI builds (#12830)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.5.20272.6</code> to <code>5.0.100-preview.5.20278.13</code> (#12772) (Thanks @github-actions[bot]!)</li>
<li>Allow use of build module on unknown Linux distros (#11146) (Thanks @Saancreed!)</li>
<li>Fix MSI upgrade and shortcut issues (#12792) (Thanks @heaths!)</li>
<li>Bump NJsonSchema from 10.1.17 to 10.1.18 (#12812)</li>
<li>Update .NET SDK version from <code>5.0.100-preview.5.20269.29</code> to <code>5.0.100-preview.5.20272.6</code> (#12759) (Thanks @github-actions[bot]!)</li>
<li>Bump NJsonSchema from 10.1.16 to 10.1.17 (#12761)</li>
<li>Update to dotnet SDK 5.0.0-preview.5.20268.9 (#12740)</li>
<li>Remove <code>assets\license.rtf</code> (#12721) (Thanks @xtqqczze!)</li>
<li>Bump <code>Microsoft.CodeAnalysis.CSharp</code> from <code>3.5.0</code> to <code>3.6.0</code> (#12731)</li>
</ul>

</details>

### Documentation and Help Content

- Update `README` and `metadata` files for next release (#12717)
- Update `README.md` removing experimental status of `Arm` builds, but `Win-Arm64` is still preview for Stable release. (#12707)
- Add link to Github compare in changelog (#12713) (Thanks @xtqqczze!)
- Added missing changelog for v7.1.0-preview.2 (#12665)
- Update required Visual Studio version in build docs (#12628) (Thanks @xtqqczze!)
- minor update to Distribution_Request.md (#12705) (Thanks @kilasuit!)
- Update docs.microsoft.com links (#12653) (Thanks @xtqqczze!)
- Update change log for `6.2.5` release (#12670)
- Update `README.md` and `metadata.json` for next release (#12668)
- Merge 7.0.1 change log (#12669)
- Remove markdown unused definitions (#12656) (Thanks @xtqqczze!)
- Add HoloLens to list of PowerShell adopters (#12940) (Thanks @reynoldsbd!)
- Update `README.md` and `metadata.json` for next releases (#12939)
- Fix broken link in `README.md` (#12887) (Thanks @xtqqczze!)
- Minor typo corrections in Distribution Request Issue Templates (#12744) (Thanks @corbob!)
- Correct 'review-for-comments' in `Governance.md` (#11035) (Thanks @MarvTheRobot!)
- Fix markdown ordered lists (#12657) (Thanks @xtqqczze!)
- Fix broken `docs.microsoft.com` link (#12776) (Thanks @xtqqczze!)
- Replace link to Slack with link to PowerShell Virtual User Group (#12786) (Thanks @xtqqczze!)
- Update `LICENSE.txt` so that it's recognized as MIT (#12729)

## [7.1.0-preview.3] - 2020-05-14

### Breaking Changes

- Fix string parameter binding for `BigInteger` numeric literals (#11634) (Thanks @vexx32!)

### Engine Updates and Fixes

- Set correct `PSProvider` full name at module load time (#11813) (Thanks @iSazonov!)

### Experimental Features

- Support passing `PSPath` to native commands (#12386)

### General Cmdlet Updates and Fixes

- Fix incorrect index in format string in ParameterBinderBase (#12630) (Thanks @powercode!)
- Copy the `CommandInfo` property in `Command.Clone()` (#12301) (Thanks @TylerLeonhardt!)
- Apply `-IncludeEqual` in `Compa-Object` when `-ExcludeDifferent` is specified (#12317) (Thanks @davidseibel!)
- Change `Get-FileHash` to close file handles before writing output (#12474) (Thanks @HumanEquivalentUnit!)
- Fix inconsistent exception message in `-replace` operator (#12388) (Thanks @jackdcasey!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @RDIL, @powercode, @xtqqczze, @xtqqczze</p>

</summary>

<ul>
<li>Replace Unicode <code>non-breaking space</code> character with space (#12576) (Thanks @xtqqczze!)</li>
<li>Remove unused <code>New-DockerTestBuild.ps1</code> (#12610) (Thanks @RDIL!)</li>
<li>Annotate <code>Assert</code> methods for better code analysis (#12618) (Thanks @powercode!)</li>
<li>Use correct casing for cmdlet names and parameters in *.ps1 files throughout the codebase (#12584) (Thanks @xtqqczze!)</li>
<li>Document why <code>PackageVersion</code> is used in <code>PowerShell.Common.props</code> (#12523) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Update `@PoshChan` config to include `SSH` (#12526) (Thanks @vexx32!)
- Update log message in `Start-PSBootstrap` (#12573) (Thanks @xtqqczze!)
- Add the `.NET SDK` installation path to the current process path in `tools/UpdateDotnetRuntime.ps1` (#12525)

### Tests

- Make CIM tab completion test case insensitive (#12636)
- Mark ping tests as Pending due to stability issues in macOS (#12504)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@jcotton42, @iSazonov, @iSazonov, @iSazonov</p>

</summary>

<ul>
<li>Update build to use the new .NET SDK <code>5.0.100-preview.4.20258.7</code> (#12637)</li>
<li>Bump NJsonSchema from 10.1.14 to 10.1.15 (#12608)</li>
<li>Bump NJsonSchema from 10.1.13 to 10.1.14 (#12598)</li>
<li>Bump NJsonSchema from 10.1.12 to 10.1.13 (#12583)</li>
<li>Update the build to sign any unsigned files as 3rd party Dlls (#12581)</li>
<li>Update .NET SDK to <code>5.0.100-preview.4.20229.10</code> (#12538)</li>
<li>Add ability to <code>Install-Dotnet</code> to specify directory (#12469)</li>
<li>Allow <code>/</code> in relative paths for <code>using module</code> (#7424) (#12492) (Thanks @jcotton42!)</li>
<li>Update dotnet metadata for next channel for automated updates (#12502)</li>
<li>Bump .NET to 5.0.0-preview.4 (#12507)</li>
<li>Bump <code>Microsoft.ApplicationInsights</code> from <code>2.13.1</code> to <code>2.14.0</code> (#12479)</li>
<li>Bump PackageManagement from 1.4.6 to 1.4.7 in /src/Modules (#12506)</li>
<li>Bump <code>Xunit.SkippableFact</code> from <code>1.3.12</code> to <code>1.4.8</code> (#12480)</li>
<li>Fix quotes to allow variable expansion (#12512)</li>
<li>Use new <code>TargetFramework</code> as <code>net5.0</code> in packaging scripts (#12503) (Thanks @iSazonov!)</li>
<li>Use new value for <code>TargetFramework</code> as <code>net5.0</code> instead of <code>netcoreapp5.0</code> (#12486) (Thanks @iSazonov!)</li>
<li>Disable <code>PublishReadyToRun</code> for framework dependent packages (#12450)</li>
<li>Add <code>dependabot</code> rules to ignore updates from .NET (#12466)</li>
<li>Update <code>README.md</code> and <code>metadata.json</code> for upcoming release (#12441)</li>
<li>Turn on <code>ReadyToRun</code> (#12361) (Thanks @iSazonov!)</li>
<li>Add summary to compressed sections of change log (#12429)</li>
</ul>

</details>

### Documentation and Help Content

- Add link to life cycle doc to distribution request template (#12638)
- Update TFM reference in build docs (#12514) (Thanks @xtqqczze!)
- Fix broken link for blogs in documents (#12471)

## [7.1.0-preview.2] - 2020-04-23

### Breaking Changes

- On Windows, `Start-Process` creates a process environment with
  all the environment variables from current session,
  using `-UseNewEnvironment` creates a new default process environment (#10830) (Thanks @iSazonov!)
- Do not wrap return result to `PSObject` when converting ScriptBlock to delegate (#10619)

### Engine Updates and Fixes

- Allow case insensitive paths for determining `PSModulePath` (#12192)
- Add PowerShell version 7.0 to compatible version list (#12184)
- Discover assemblies loaded by `Assembly.Load(byte[])` and `Assembly.LoadFile` (#12203)

### General Cmdlet Updates and Fixes

- Fix `WinCompat` module loading to treat PowerShell 7 modules with higher priority (#12269)
- Implement `ForEach-Object -Parallel` runspace reuse (#12122)
- Fix `Get-Service` to not modify collection while enumerating it (#11851) (Thanks @NextTurn!)
- Clean up the IPC named pipe on PowerShell exit (#12187)
- Fix `<img />` detection regex in web cmdlets (#12099) (Thanks @vexx32!)
- Allow shorter signed hex literals with appropriate type suffixes (#11844) (Thanks @vexx32!)
- Update `UseNewEnvironment` parameter behavior of `Start-Process` cmdlet on Windows (#10830) (Thanks @iSazonov!)
- Add `-Shuffle` switch to `Get-Random` command (#11093) (Thanks @eugenesmlv!)
- Make `GetWindowsPowerShellModulePath` compatible with multiple PS installations (#12280)
- Fix `Start-Job` to work on systems that don't have Windows PowerShell registered as default shell (#12296)
- Specifying an alias and `-Syntax` to `Get-Command` returns the aliased commands syntax (#10784) (Thanks @ChrisLGardner!)
- Make CSV cmdlets work when using `-AsNeeded` and there is an incomplete row (#12281) (Thanks @iSazonov!)
- In local invocations, do not require `-PowerShellVersion 5.1` for `Get-FormatData` in order to see all format data. (#11270) (Thanks @mklement0!)
- Added Support For Big Endian `UTF-32` (#11947) (Thanks @NoMoreFood!)
- Fix possible race that leaks PowerShell object dispose in `ForEach-Object -Parallel` (#12227)
- Add `-FromUnixTime` to `Get-Date` to allow Unix time input (#12179) (Thanks @jackdcasey!)
- Change default progress foreground and background colors to provide improved contrast (#11455) (Thanks @rkeithhill!)
- Fix `foreach -parallel` when current drive is not available (#12197)
- Do not wrap return result to `PSObject` when converting `ScriptBlock` to `delegate` (#10619)
- Don't write DNS resolution errors on `Test-Connection -Quiet` (#12204) (Thanks @vexx32!)
- Use dedicated threads to read the redirected output and error streams from the child process for out-of-proc jobs (#11713)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@ShaydeNofziger, @RDIL</p>

</summary>

<ul>
<li>Fix erroneous comment in <code>tokenizer.cs</code> (#12206) (Thanks @ShaydeNofziger!)</li>
<li>Fix terms checker issues (#12189)</li>
<li>Update copyright notice to latest guidance (#12190)</li>
<li>CodeFactor cleanup (#12251) (Thanks @RDIL!)</li>
</ul>

</details>

### Tools

- Update .NET dependency update script to include test `csproj` files (#12372)
- Scripts to update to .NET prerelease version (#12284)

### Tests

- Pin major Pester version to 4 to prevent breaking changes caused by upcoming release of v5 (#12262) (Thanks @bergmeister!)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@rkitover, @bergmeister</p>

</summary>

<ul>
<li>Add the <code>nuget.config</code> from root to the temporary build folder (#12394)</li>
<li>Bump System.IO.Packaging (#12365)</li>
<li>Bump Markdig.Signed from 0.18.3 to 0.20.0 (#12379)</li>
<li>Bump to .NET 5 Preview 3 pre-release (#12353)</li>
<li>Bump PowerShellGet from 2.2.3 to 2.2.4 (#12342)</li>
<li>Linux: Initial support for Gentoo installations. (#11429) (Thanks @rkitover!)</li>
<li>Upgrade to .NET 5 Preview 2 (#12250) (Thanks @bergmeister!)</li>
<li>Fix the <code>Sync PSGalleryModules to Artifacts</code> build (#12277)</li>
<li>Bump PSReadLine from 2.0.0 to 2.0.1 (#12243)</li>
<li>Bump <code>NJsonSchema</code> from <code>10.1.11</code> to <code>10.1.12</code> (#12230)</li>
<li>Update change log generation script to support collapsible sections (#12214)</li>
</ul>

</details>

### Documentation and Help Content

- Add documentation for `WebResponseObject` and `BasicHtmlWebResponseObject` properties (#11876) (Thanks @kevinoid!)
- Add Windows 10 IoT Core reference in `Adopters.md` (#12266) (Thanks @parameshbabu!)
- Update `README.md` and `metadata.json` for `7.1.0-preview.1` (#12211)

## [7.1.0-preview.1] - 2020-03-26

### Breaking Changes

- Use invariant culture string conversion for `-replace` operator (#10954) (Thanks @iSazonov!)

### Engine Updates and Fixes

- Revert the PRs that made `DBNull.Value` and `NullString.Value` treated as `$null` (#11648)

### Experimental Features

- Use invariant culture string conversion for `-replace` operator (#10954) (Thanks @iSazonov!)

### General Cmdlet Updates and Fixes

- Fix an operator preference order issue in binder code (#12075) (Thanks @DamirAinullin!)
- Fix `NullReferenceException` when binding common parameters of type `ActionPreference` (#12124)
- Fix default formatting for deserialized `MatchInfo` (#11728) (Thanks @iSazonov!)
- Use asynchronous streams in `Invoke-RestMethod` (#11095) (Thanks @iSazonov!)
- Address UTF-8 Detection In `Get-Content -Tail` (#11899) (Thanks @NoMoreFood!)
- Handle the `IOException` in `Get-FileHash` (#11944) (Thanks @iSazonov!)
- Change `PowerShell Core` to `PowerShell` in a resource string (#11928) (Thanks @alexandair!)
- Bring back `MainWindowTitle` in `PSHostProcessInfo` (#11885) (Thanks @iSazonov!)
- Miscellaneous minor updates to Windows Compatibility (#11980)
- Fix `ConciseView` to split `PositionMessage` using `[Environment]::NewLine` (#12010)
- Remove network hop restriction for interactive sessions (#11920)
- Fix `NullReferenceException` in `SuspendStoppingPipeline()` and `RestoreStoppingPipeline()` (#11870) (Thanks @iSazonov!)
- Generate GUID for `FormatViewDefinition` `InstanceId` if not provided (#11896)
- Fix `ConciseView` where error message is wider than window width and doesn't have whitespace (#11880)
- Allow cross-platform `CAPI-compatible` remote key exchange (#11185) (Thanks @silijon!)
- Fix error message (#11862) (Thanks @NextTurn!)
- Fix `ConciseView` to handle case where there isn't a console to obtain the width (#11784)
- Update `CmsCommands` to use Store vs certificate provider (#11643) (Thanks @mikeTWC1984!)
- Enable `pwsh` to work on Windows systems where `mpr.dll` and STA is not available (#11748)
- Refactor and implement `Restart-Computer` for `Un*x` and macOS (#11319)
- Add an implementation of `Stop-Computer` for Linux and macOS (#11151)
- Fix `help` function to check if `less` is available before using (#11737)
- Update `PSPath` in `certificate_format_ps1.xml` (#11603) (Thanks @xtqqczze!)
- Change regular expression to match relation-types without quotes in Link header (#11711) (Thanks @Marusyk!)
- Fix error message during symbolic link deletion (#11331)
- Add custom `Selected.*` type to `PSCustomObject` in `Select-Object` only once (#11548) (Thanks @iSazonov!)
- Add `-AsUTC` to the `Get-Date` cmdlet (#11611)
- Fix grouping behavior with Boolean values in `Format-Hex` (#11587) (Thanks @vexx32!)
- Make `Test-Connection` always use the default synchronization context for sending ping requests (#11517)
- Correct startup error messages (#11473) (Thanks @iSazonov!)
- Ignore headers with null values in web cmdlets (#11424) (Thanks @iSazonov!)
- Re-add check for `Invoke-Command` job dispose. (#11388)
- Revert "Update formatter to not write newlines if content is empty (#11193)" (#11342) (Thanks @iSazonov!)
- Allow `CompleteInput` to return results from `ArgumentCompleter` when `AST` or Script has matching function definition (#10574) (Thanks @M1kep!)
- Update formatter to not write new lines if content is empty (#11193)

### Code Cleanup

<details>

<ul>
<li>Use span-based overloads (#11884) (Thanks @iSazonov!)</li>
<li>Use new <code>string.Split()</code> overloads (#11867) (Thanks @iSazonov!)</li>
<li>Remove unreachable DSC code (#12076) (Thanks @DamirAinullin!)</li>
<li>Remove old dead code from FullCLR (#11886) (Thanks @iSazonov!)</li>
<li>Use <code>Dictionary.TryAdd()</code> where possible (#11767) (Thanks @iSazonov!)</li>
<li>Use <code>Environment.NewLine</code> instead of hard-coded linefeed in <code>ParseError.ToString</code> (#11746)</li>
<li>Fix <code>FileSystem</code> provider error message (#11741) (Thanks @iSazonov!)</li>
<li>Reformat code according to <code>EditorConfig</code> rules (#11681) (Thanks @xtqqczze!)</li>
<li>Replace use of throw <code>GetExceptionForHR</code> with <code>ThrowExceptionForHR</code> (#11640) (Thanks @xtqqczze!)</li>
<li>Refactor delegate types to lambda expressions (#11690) (Thanks @xtqqczze!)</li>
<li>Remove Unicode BOM from text files (#11546) (Thanks @xtqqczze!)</li>
<li>Fix Typo in <code>Get-ComputerInfo</code> cmdlet description (#11321) (Thanks @doctordns!)</li>
<li>Fix typo in description for <code>Get-ExperimentalFeature</code> <code>PSWindowsPowerShellCompatibility</code> (#11282) (Thanks @alvarodelvalle!)</li>
<li>Cleanups in command discovery (#10815) (Thanks @iSazonov!)</li>
<li>Review <code>CurrentCulture</code> (#11044) (Thanks @iSazonov!)</li>
</ul>

</details>

### Tools

- Change recommended VS Code extension name from `ms-vscode.csharp` to `ms-dotnettools.csharp` (#12083) (Thanks @devlead!)
- Specify `csharp_preferred_modifier_order` in `EditorConfig` (#11775) (Thanks @xtqqczze!)
- Update `.editorconfig` (#11675) (Thanks @xtqqczze!)
- Enable `EditorConfig` support in `OmniSharp` (#11627) (Thanks @xtqqczze!)
- Specify charset in `.editorconfig` as `utf-8` (no BOM) (#11654) (Thanks @xtqqczze!)
- Configure the issue label bot (#11527)
- Avoid variable names that conflict with automatic variables (#11392) (Thanks @xtqqczze!)

### Tests

- Add empty `preview.md` file to fix broken link (#12041)
- Add helper functions for SSH remoting tests (#11955)
- Add new tests for `Get-ChildItem` for `FileSystemProvider` (#11602) (Thanks @iSazonov!)
- Ensure that types referenced by `PowerShellStandard` are present (#10634)
- Check state and report reason if it's not "opened" (#11574)
- Fixes for running tests on Raspbian (#11661)
- Unify pester test syntax for the arguments of `-BeOfType`  (#11558) (Thanks @xtqqczze!)
- Correct casing for automatic variables (#11568) (Thanks @iSazonov!)
- Avoid variable names that conflict with automatic variables part 2 (#11559) (Thanks @xtqqczze!)
- Update pester syntax to v4 (#11544) (Thanks @xtqqczze!)
- Allow error 504 (Gateway Timeout) in `markdown-link` tests (#11439) (Thanks @xtqqczze!)
- Re-balance CI tests (#11420) (Thanks @iSazonov!)
- Include URL in the markdown-links test error message (#11438) (Thanks @xtqqczze!)
- Use CIM cmdlets instead of WMI cmdlets in tests (#11423) (Thanks @xtqqczze!)

### Build and Packaging Improvements

<details>

<ul>
<li>Put symbols in separate package (#12169)</li>
<li>Disable <code>x86</code> PDB generation (#12167)</li>
<li>Bump <code>NJsonSchema</code> from <code>10.1.5</code> to <code>10.1.11</code> (#12050) (#12088) (#12166)</li>
<li>Create <code>crossgen</code> symbols for Windows <code>x64</code> and <code>x86</code> (#12157)</li>
<li>Move to <code>.NET 5 preview.1</code> (#12140)</li>
<li>Bump <code>Microsoft.CodeAnalysis.CSharp</code> from <code>3.4.0</code> to <code>3.5.0</code> (#12136)</li>
<li>Move to standard internal pool for building (#12119)</li>
<li>Fix package syncing to private Module Feed  (#11841)</li>
<li>Add Ubuntu SSH remoting tests CI (#12033)</li>
<li>Bump <code>Markdig.Signed</code> from <code>0.18.1</code> to <code>0.18.3</code> (#12078)</li>
<li>Fix MSIX packaging to determine if a Preview release by inspecting the semantic version string (#11991)</li>
<li>Ignore last exit code in the build step as <code>dotnet</code> may return error when SDK is not installed (#11972)</li>
<li>Fix daily package build (#11882)</li>
<li>Fix package sorting for syncing to private Module Feed (#11838)</li>
<li>Set <code>StrictMode</code> version <code>3.0</code> (#11563) (Thanks @xtqqczze!)</li>
<li>Bump <code>.devcontainer</code> version to dotnet <code>3.1.101</code> (#11707) (Thanks @Jawz84!)</li>
<li>Move to version 3 of <code>AzFileCopy</code> (#11697)</li>
<li>Update <code>README.md</code> and <code>metadata.json</code> for next release (#11664)</li>
<li>Code Cleanup for environment data gathering in <code>build.psm1</code> (#11572) (Thanks @xtqqczze!)</li>
<li>Update Debian Install Script To Support Debian 10 (#11540) (Thanks @RandomNoun7!)</li>
<li>Update <code>ADOPTERS.md</code> (#11261) (Thanks @edyoung!)</li>
<li>Change back to use powershell.exe in 'SetVersionVariables.yml' to unblock daily build (#11207)</li>
<li>Change to use pwsh to have consistent JSON conversion for <code>DateTime</code> (#11126)</li>
</ul>

</details>

### Documentation and Help Content

- Replace `VSCode` link in `CONTRIBUTING.md` (#11475) (Thanks @stevend811!)
- Remove the version number of PowerShell from LICENSE (#12019)
- Add the 7.0 change log link to `CHANGELOG/README.md` (#12062) (Thanks @LabhanshAgrawal!)
- Improvements to the contribution guide (#12086) (Thanks @ShaydeNofziger!)
- Update the doc about debugging dotnet core in VSCode (#11969)
- Update `README.md` and `metadata.json` for the next release (#11918) (#11992)
- Update `Adopters.md` to include info on Azure Pipelines and GitHub Actions (#11888) (Thanks @alepauly!)
- Add information about how Amazon AWS uses PowerShell. (#11365) (Thanks @bpayette!)
- Add link to .NET CLI version in build documentation (#11725) (Thanks @joeltankam!)
- Added info about `DeploymentScripts` in `ADOPTERS.md` (#11703)
- Update `CHANGELOG.md` for `6.2.4` release (#11699)
- Update `README.md` and `metadata.json` for next release (#11597)
- Update the breaking change definition (#11516)
- Adding System Frontier to the PowerShell Core adopters list `ADOPTERS.md` (#11480) (Thanks @OneScripter!)
- Update `ChangeLog`, `README.md` and `metadata.json` for `7.0.0-rc.1` release (#11363)
- Add `AzFunctions` to `ADOPTERS.md` (#11311) (Thanks @Francisco-Gamino!)
- Add `Universal Dashboard` to `ADOPTERS.md` (#11283) (Thanks @adamdriscoll!)
- Add `config.yml` for `ISSUE_TEMPLATE` so that Doc, Security, Support, and Windows PowerShell issues go to URLs (#11153)
- Add `Adopters.md` file (#11256)
- Update `Readme.md` for `preview.6` release (#11108)
- Update `SUPPORT.md` (#11101) (Thanks @mklement0!)
- Update `README.md` (#11100) (Thanks @mklement0!)

[7.1.0-preview.5]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-preview.4...v7.1.0-preview.5
[7.1.0-preview.4]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-preview.3...v7.1.0-preview.4
[7.1.0-preview.3]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-preview.2...v7.1.0-preview.3
[7.1.0-preview.2]: https://github.com/PowerShell/PowerShell/compare/v7.1.0-preview.1...v7.1.0-preview.2
[7.1.0-preview.1]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-preview.6...v7.1.0-preview.1

