#ifndef NVPERF_VERSIONS_TARGET_H
#define NVPERF_VERSIONS_TARGET_H

/*
 * Copyright 2014-2022  NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO USER:
 *
 * This source code is subject to NVIDIA ownership rights under U.S. and
 * international Copyright laws.
 *
 * This software and the information contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and conditions
 * of a form of NVIDIA software license agreement.
 *
 * NVIDIA MAKES NO REPRESENTATION ABOUT THE SUITABILITY OF THIS SOURCE
 * CODE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY OF ANY KIND.  NVIDIA DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL,
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS,  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION,  ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOURCE CODE.
 *
 * U.S. Government End Users.   This source code is a "commercial item" as
 * that term is defined at  48 C.F.R. 2.101 (OCT 1995), consisting  of
 * "commercial computer  software"  and "commercial computer software
 * documentation" as such terms are  used in 48 C.F.R. 12.212 (SEPT 1995)
 * and is provided to the U.S. Government only as a commercial end item.
 * Consistent with 48 C.F.R.12.212 and 48 C.F.R. 227.7202-1 through
 * 227.7202-4 (JUNE 1995), all U.S. Government End Users acquire the
 * source code with only those rights set forth herein.
 *
 * Any use of this source code in individual and commercial software must
 * include, in the user documentation and internal comments to the code,
 * the above Disclaimer and U.S. Government End Users Notice.
 */

#include <stddef.h>
#include <stdint.h>

#if defined(__GNUC__) && defined(NVPA_SHARED_LIB)
    #pragma GCC visibility push(default)
    #if !defined(NVPW_LOCAL)
        #define NVPW_LOCAL __attribute__ ((visibility ("hidden")))
    #endif
#else
    #if !defined(NVPW_LOCAL)
        #define NVPW_LOCAL
    #endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/**
 *  @file   nvperf_versions_target.h
 */

/// D3D11_PROFILER versions
#define NVPW_D3D11_PROFILER_VERSION_MAJOR 0
#define NVPW_D3D11_PROFILER_VERSION_MINOR 1
#define NVPW_D3D11_PROFILER_VERSION_PATCH 0

/// D3D12_PROFILER versions
#define NVPW_D3D12_PROFILER_VERSION_MAJOR 0
#define NVPW_D3D12_PROFILER_VERSION_MINOR 1
#define NVPW_D3D12_PROFILER_VERSION_PATCH 0

/// GPU_PERIODICSAMPLER versions
#define NVPW_GPU_PERIODICSAMPLER_VERSION_MAJOR 0
#define NVPW_GPU_PERIODICSAMPLER_VERSION_MINOR 1
#define NVPW_GPU_PERIODICSAMPLER_VERSION_PATCH 0

/// METRICSEVALUATOR versions
#define NVPW_METRICSEVALUATOR_VERSION_MAJOR 0
#define NVPW_METRICSEVALUATOR_VERSION_MINOR 1
#define NVPW_METRICSEVALUATOR_VERSION_PATCH 0

/// METRICS_GA10X_GRFX versions
#define NVPW_METRICS_GA10X_GRFX_VERSION_MAJOR 0
#define NVPW_METRICS_GA10X_GRFX_VERSION_MINOR 1
#define NVPW_METRICS_GA10X_GRFX_VERSION_PATCH 0

/// METRICS_TU10X_GRFX versions
#define NVPW_METRICS_TU10X_GRFX_VERSION_MAJOR 0
#define NVPW_METRICS_TU10X_GRFX_VERSION_MINOR 1
#define NVPW_METRICS_TU10X_GRFX_VERSION_PATCH 0

/// METRICS_TU11X_GRFX versions
#define NVPW_METRICS_TU11X_GRFX_VERSION_MAJOR 0
#define NVPW_METRICS_TU11X_GRFX_VERSION_MINOR 1
#define NVPW_METRICS_TU11X_GRFX_VERSION_PATCH 0

/// OPENGL_PROFILER versions
#define NVPW_OPENGL_PROFILER_VERSION_MAJOR 0
#define NVPW_OPENGL_PROFILER_VERSION_MINOR 1
#define NVPW_OPENGL_PROFILER_VERSION_PATCH 0

/// VULKAN_PROFILER versions
#define NVPW_VULKAN_PROFILER_VERSION_MAJOR 0
#define NVPW_VULKAN_PROFILER_VERSION_MINOR 1
#define NVPW_VULKAN_PROFILER_VERSION_PATCH 0

/// SDK versions
#define NVPW_SDK_VERSION_MAJOR 2022
#define NVPW_SDK_VERSION_MINOR 3
#define NVPW_SDK_VERSION_PATCH 0

/// D3D11_PROFILER versions
#define NVPW_D3D11_PROFILER_RELEASE_VERSION_MAJOR 0
#define NVPW_D3D11_PROFILER_RELEASE_VERSION_MINOR 1
#define NVPW_D3D11_PROFILER_RELEASE_VERSION_PATCH 0

/// D3D12_PROFILER versions
#define NVPW_D3D12_PROFILER_RELEASE_VERSION_MAJOR 0
#define NVPW_D3D12_PROFILER_RELEASE_VERSION_MINOR 1
#define NVPW_D3D12_PROFILER_RELEASE_VERSION_PATCH 0

/// GPU_PERIODICSAMPLER versions
#define NVPW_GPU_PERIODICSAMPLER_RELEASE_VERSION_MAJOR 0
#define NVPW_GPU_PERIODICSAMPLER_RELEASE_VERSION_MINOR 1
#define NVPW_GPU_PERIODICSAMPLER_RELEASE_VERSION_PATCH 0

/// METRICSEVALUATOR versions
#define NVPW_METRICSEVALUATOR_RELEASE_VERSION_MAJOR 0
#define NVPW_METRICSEVALUATOR_RELEASE_VERSION_MINOR 1
#define NVPW_METRICSEVALUATOR_RELEASE_VERSION_PATCH 0

/// METRICS_GA10X_GRFX versions
#define NVPW_METRICS_GA10X_GRFX_RELEASE_VERSION_MAJOR 0
#define NVPW_METRICS_GA10X_GRFX_RELEASE_VERSION_MINOR 1
#define NVPW_METRICS_GA10X_GRFX_RELEASE_VERSION_PATCH 0

/// METRICS_TU10X_GRFX versions
#define NVPW_METRICS_TU10X_GRFX_RELEASE_VERSION_MAJOR 0
#define NVPW_METRICS_TU10X_GRFX_RELEASE_VERSION_MINOR 1
#define NVPW_METRICS_TU10X_GRFX_RELEASE_VERSION_PATCH 0

/// METRICS_TU11X_GRFX versions
#define NVPW_METRICS_TU11X_GRFX_RELEASE_VERSION_MAJOR 0
#define NVPW_METRICS_TU11X_GRFX_RELEASE_VERSION_MINOR 1
#define NVPW_METRICS_TU11X_GRFX_RELEASE_VERSION_PATCH 0

/// OPENGL_PROFILER versions
#define NVPW_OPENGL_PROFILER_RELEASE_VERSION_MAJOR 0
#define NVPW_OPENGL_PROFILER_RELEASE_VERSION_MINOR 1
#define NVPW_OPENGL_PROFILER_RELEASE_VERSION_PATCH 0

/// VULKAN_PROFILER versions
#define NVPW_VULKAN_PROFILER_RELEASE_VERSION_MAJOR 0
#define NVPW_VULKAN_PROFILER_RELEASE_VERSION_MINOR 1
#define NVPW_VULKAN_PROFILER_RELEASE_VERSION_PATCH 0

/// SDK versions
#define NVPW_SDK_RELEASE_VERSION_MAJOR 2022
#define NVPW_SDK_RELEASE_VERSION_MINOR 3
#define NVPW_SDK_RELEASE_VERSION_PATCH 0



#ifdef __cplusplus
} // extern "C"
#endif

#if defined(__GNUC__) && defined(NVPA_SHARED_LIB)
    #pragma GCC visibility pop
#endif

#endif // NVPERF_VERSIONS_TARGET_H
