#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ncurses.h>
#include "scoring.h"
#include <getopt.h>
#include <unistd.h>
#include "nibbles.h"

void cmdline(int argc, char *argv[], unsigned int *basedelay, char **leveldir, char **rcfile, char **playerName)
{
int c=0;
int option_index = 0;
char *home;
FILE *fp;
static struct option long_options[] = 
	{
		{"help",0,0,'h'},
		{"basedelay",1,0,'b'},
		{"leveldir",1,0,'l'},
		{"rcfile",1,0,'r'},
		{"scores",0,0,'s'},
		{"scorefile",1,0,'f'},
		{"name",1,0,'n'},
		{0,0,0,0}
	};

*basedelay = TIMEOUT;   // default basedelay
strncpy(highscoref, HIGHSCOREFILE, 255);

while (c!=EOF)
{
c = getopt_long(argc,argv,"hb:l:r:sf:n:",long_options,&option_index);

switch(c)
	{
	case 0:
	fprintf(stderr,"option %s",long_options[option_index].name);
	if (optarg)
	fprintf(stderr," with arg %d",(int)optarg);
	fprintf(stderr,"\n");
	break;

	case 'h':
	fprintf(stderr,"Nibbles %s -- Copyright Toby Jaffey 1999",VERSION);
	fprintf(stderr,"\nBug reports to toby@earth.li");
	fprintf(stderr,"\nLatest Version at http://www.earth.li/projectpurple");
	fprintf(stderr,"\n\nUsage: nibbles");
	fprintf(stderr,"\noptions:");	
	fprintf(stderr,"\n-h\t--help\t\tSee recursion");
	fprintf(stderr,"\n-b\t--basedelay\tSet the game loop delay in milliseconds");
	fprintf(stderr,"\n-l\t--leveldir\tWhere to find .lev files");
	fprintf(stderr,"\n-r\t--rcfile\tUse a different rcfile from the default (~/.rcfile)");
	fprintf(stderr,"\n-s\t--scores\tShow the high score table");
	fprintf(stderr,"\n-f\t--scorefile\tUse an alternate high score file");
	fprintf(stderr,"\n-n\t--name\t\tName to use in highscore file");
	fprintf(stderr,"\n\n");
	exit(-1);
	break;
	
	case 'b':
	*basedelay = (unsigned int)strtol(optarg,NULL,10);
	if ( (*basedelay) > 1000000 || (*basedelay) < 100 )
		{
		fprintf(stderr,"\nPlease pick a sensible number for the base delay, in milliseconds\n");
		exit(-1);
		}
	break;

	case 'l':
	*leveldir = strdup(optarg);
	break;

	case 'r':
	*rcfile = strdup(optarg);
	break;

	case 'n':
	*playerName = strdup(optarg);
	break;

	case 's':
	print_high_scores();
	exit(0);
	break;

	case 'f':
	if (strlen(optarg)>254)
		{
		printf("High score filename too long. Max 254 chars.\n");
		exit(1);
		}
	if (getuid()!=geteuid())
		{
		printf("Nibbles appears to be SUID - unable to accept -f option.\n");
		exit(1);
		}
	if (getgid()!=getegid())
		{
		printf("Nibbles appears to be SGID - unable to accept -f option.\n");
		exit(1);
		}
	strncpy(highscoref, optarg, 255);
	if (highscoref[strlen(highscoref) - 1] == '\n')
	highscoref[strlen(highscoref) - 1] = '\0';
	break;
	

	case 63: // ARGGGGGGGGGHHHHHHHHHHHHhh WHY GOD WHY???
	exit(-2);
	break;
	} // end switch c
} // end while

if (*rcfile==NULL)
	{
	if ((*rcfile = malloc(255))==NULL)
		{
		fprintf(stderr,"\nAmnesia alert, seriously low on memory\n");
		exit(-1);
		}
	home = getenv("HOME");
	if (home==NULL)
		{
		fprintf(stderr,"\nYou have no HOME\n");
		exit(-1);
		}
	snprintf(*rcfile, 255, "%s/%s", home, RCFILENAME);
	if ( (fp = fopen(*rcfile,"r")) == NULL) // no such file
		{
		fprintf(stderr,"\nYou need an rc file: %s",*rcfile);
		fprintf(stderr,"\nThe first line should contain the pathname of the levels directory");
		fprintf(stderr,"\nI am creating one with default values\n\n");
		fp = fopen(*rcfile,"w");
		fprintf(fp,"%s\n\n",LEVELDIR);
		*leveldir = strdup(LEVELDIR);
		}	
	}
else
	{
	if ( (fp = fopen(*rcfile,"rw")) == NULL) // no such file
		{
		fprintf(stderr,"\nCan't open %s", *rcfile);
		exit(-1);
		}
	}
// fp is a real rc file
if (*leveldir==NULL)
	{
	if ((*leveldir = malloc(255))==NULL)
		{
		fprintf(stderr,"\nAmnesia alert, seriously low on memory\n");
		exit(-1);
		}
	if (fscanf(fp, "%s", *leveldir)!=1)
		{
		fprintf(stderr,"\nMalformed rcfile %s\n", *rcfile);
		}
	}
fclose(fp);

} // end parse command line params
