#include <ncurses.h>
#include <sys/time.h>
#include <stdlib.h>
#include "ncdrawlib.h"

void initDisplay(void)
{
initscr();	// fire up curses
start_color();	// allow colours
cbreak();	// no line buffering
noecho();	// no keyboard echo
keypad(stdscr, TRUE);	// use keypad
curs_set(0);	// invisible cursor
clear();	// cls
flushinp();	// clear any waiting keypresses
}

void closeDisplay(void)
{
endwin();
}

void circle(WINDOW *win, int x, int y, int r, char c, int attrs)
{
int xi,yi;
float error;

attron(attrs);

if (r!=0)
	{
	xi = 0;
	yi = r;
	error = 3 - (r << 1);

	while (xi <= yi)
		{
		mvwaddch(win, y+yi, x+xi, c);
		mvwaddch(win, y-yi, x+xi, c);
		mvwaddch(win, y+yi, x-xi, c);
		mvwaddch(win, y-yi, x-xi, c);
		mvwaddch(win, y+xi, x+yi, c);
		mvwaddch(win, y-xi, x+yi, c);
		mvwaddch(win, y+xi, x-yi, c);
		mvwaddch(win, y-xi, x-yi, c);

		if (error < 0)
			error += (xi << 2) + 6;
		else
			error += ((xi-yi--) << 2) + 10;
		xi++;
		}
	} // end rad != 0
attroff(attrs);
}

void rectangle(WINDOW *win, int fill, int x, int y, int width, int height, char c, int attrs)
{
int i;
attron(attrs);

if (fill)
	{
	for (i=y;i<y+height;i++)
	mvwhline(win, i, x, c, width);
	}
else
	{
	mvwhline(win, y, x, c, width);
	mvwhline(win, (y+height)-1, x, c, width);
	mvwvline(win, y, x, c, height);
	mvwvline(win, y, (x+width)-1, c, height);
	}

attroff(attrs);
}

void line(WINDOW *win, int x1, int y1, int x2, int y2, char c, int attrs)
{
int i, dx, dy, sdx, sdy, dxabs, dyabs, x, y, px, py;

attron(attrs);

dx = x2 - x1;      // the horizontal distance of the line
dy = y2 - y1;      // the vertical distance of the line
dxabs = abs(dx);
dyabs = abs(dy);
sdx = sgn(dx);
sdy = sgn(dy);
x = dyabs >> 1;
y = dxabs >> 1;
px = x1;
py = y1;

mvwaddch(win, py, px, c);

if (dxabs >= dyabs) // the line is more horizontal than vertical
	{
	for(i=0; i<dxabs; i++)
		{
 		y += dyabs;
		if (y >= dxabs)
			{
			y -= dxabs;
			py += sdy;
			}
		px += sdx;
		mvwaddch(win, py, px, c);
		}
	}
else // the line is more vertical than horizontal
	{
	for(i=0; i<dyabs; i++)
		{
		x += dxabs;
		if (x >= dyabs)
			{
			x -= dyabs;
			px += sdx;
			}
		py += sdy;
		mvwaddch(win, py, px, c);
		}
	}

attroff(attrs);
}

int cursGetch(unsigned int *usec)
{
int flags=0;
fd_set rfds; // updated by select
struct timeval tv;
int r=-1;

tv.tv_sec = 0;
if (usec==NULL)		// we don't need to know how much time was used
	tv.tv_usec = 100; // wait a piddly time for a keypress
else
	tv.tv_usec = *usec;

FD_ZERO(&rfds);
FD_SET(0,&rfds);
flags = select(0+1,&rfds,NULL,NULL,&tv);
if (flags) r=getch();

if (usec!=NULL)
	*usec=tv.tv_usec;

return r;
}

void dissolve(WINDOW *win)
{
int maxx,maxy,i;

getmaxyx(win,maxy,maxx);

for (i=0;i<maxx*maxy;i++)
	{
	mvwaddch(win, rand()%maxy, rand()%maxx, ' ');
	wrefresh(win);
	}
}
