/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.Result;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.renderer.AbstractStrongComponentRenderer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclesResult
implements Result {
    private final List<StrongComponent> _cycles = new ArrayList<StrongComponent>();
    private final String _statement;
    private final boolean _packageCycle;

    public CyclesResult(String statement, boolean packageCycle) {
        this._statement = statement;
        this._packageCycle = packageCycle;
    }

    public void addCycle(StrongComponent cycle) {
        this._cycles.add(cycle);
    }

    public List<StrongComponent> getCycles() {
        return this._cycles;
    }

    public String getStatement() {
        return this._statement;
    }

    public boolean isPackageCycle() {
        return this._packageCycle;
    }

    @Override
    public boolean isOk() {
        return this._cycles.size() == 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this._statement);
        if (this.isOk()) {
            buffer.append("\tOK");
        } else {
            for (StrongComponent component : this._cycles) {
                int numberOfVertices = component.getNumberOfVertices();
                buffer.append("\n  ");
                buffer.append(AbstractStrongComponentRenderer.createName(component));
                buffer.append(" contains ").append(numberOfVertices);
                buffer.append(' ').append(this._packageCycle ? "packages" : "classes").append(':');
                for (int i = 0; i < numberOfVertices; ++i) {
                    buffer.append("\n    ");
                    AtomicVertex vertex = component.getVertex(i);
                    buffer.append(((NameAttributes)vertex.getAttributes()).getName());
                }
            }
        }
        return new String(buffer.append('\n'));
    }
}

