/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.Analyser;
import classycle.dependency.DependencyCheckerCommandLine;
import classycle.dependency.DependencyProcessor;
import classycle.dependency.DependencyProperties;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.graph.AtomicVertex;
import java.io.PrintWriter;
import java.util.Map;

public class DependencyChecker {
    private final Analyser _analyser;
    private final ResultRenderer _renderer;
    private final DependencyProcessor _processor;

    public DependencyChecker(Analyser analyser, String dependencyDefinition, Map properties, ResultRenderer renderer) {
        this._analyser = analyser;
        this._renderer = renderer;
        DependencyProperties dp = new DependencyProperties(properties);
        this._processor = new DependencyProcessor(dependencyDefinition, dp, renderer);
    }

    public boolean check(PrintWriter writer) {
        Result result = this.check();
        writer.print(this._renderer.render(result));
        return result.isOk();
    }

    public Result check() {
        AtomicVertex[] graph = this._analyser.getClassGraph();
        ResultContainer result = new ResultContainer();
        while (this._processor.hasMoreStatements()) {
            result.add(this._processor.executeNextStatement(graph));
        }
        return result;
    }

    public static void main(String[] args) {
        DependencyCheckerCommandLine commandLine = new DependencyCheckerCommandLine(args);
        if (!commandLine.isValid()) {
            System.out.println("Usage: java -cp classycle.jar classycle.DependencyChecker " + commandLine.getUsage());
            System.exit(1);
        }
        Analyser analyser = new Analyser(commandLine.getClassFiles(), commandLine.getPattern(), commandLine.getReflectionPattern(), commandLine.isMergeInnerClasses());
        DependencyChecker dependencyChecker = new DependencyChecker(analyser, commandLine.getDependencyDefinition(), System.getProperties(), commandLine.getRenderer());
        PrintWriter printWriter = new PrintWriter(System.out);
        boolean ok = dependencyChecker.check(printWriter);
        printWriter.flush();
        System.exit(ok ? 0 : 1);
    }
}

