/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.Vertex;
import classycle.graph.VertexCondition;
import java.util.HashSet;

public class PathsFinder {
    private final VertexCondition _startSetCondition;
    private final VertexCondition _finalSetCondition;
    private final boolean _shortestPathsOnly;
    private final boolean _directPathsOnly;

    public PathsFinder(VertexCondition startSetCondition, VertexCondition finalSetCondition, boolean shortestPathsOnly) {
        this(startSetCondition, finalSetCondition, shortestPathsOnly, false);
    }

    public PathsFinder(VertexCondition startSetCondition, VertexCondition finalSetCondition, boolean shortestPathsOnly, boolean directPathsOnly) {
        this._startSetCondition = startSetCondition;
        this._finalSetCondition = finalSetCondition;
        this._shortestPathsOnly = shortestPathsOnly;
        this._directPathsOnly = directPathsOnly;
    }

    public VertexCondition getFinalSetCondition() {
        return this._finalSetCondition;
    }

    public boolean isShortestPathsOnly() {
        return this._shortestPathsOnly;
    }

    public VertexCondition getStartSetCondition() {
        return this._startSetCondition;
    }

    public AtomicVertex[] findPaths(AtomicVertex[] graph) {
        this.prepareGraph(graph);
        HashSet pathVertices = new HashSet();
        HashSet currentPath = new HashSet();
        for (int i = 0; i < graph.length; ++i) {
            AtomicVertex vertex = graph[i];
            if (!this._startSetCondition.isFulfilled(vertex)) continue;
            if (this._directPathsOnly) {
                this.findDirectPaths(vertex, pathVertices);
                continue;
            }
            this.prepareIfFinal(vertex);
            int pathLength = this.calculateShortestPath(vertex, currentPath);
            if (pathLength >= Integer.MAX_VALUE) continue;
            vertex.setOrder(pathLength);
            this.followPaths(vertex, pathVertices);
        }
        return pathVertices.toArray(new AtomicVertex[pathVertices.size()]);
    }

    private void findDirectPaths(AtomicVertex vertex, HashSet pathVertices) {
        if (this._finalSetCondition.isFulfilled(vertex)) {
            pathVertices.add(vertex);
        } else {
            int n = vertex.getNumberOfOutgoingArcs();
            for (int i = 0; i < n; ++i) {
                Vertex headVertex = vertex.getHeadVertex(i);
                if (!this._finalSetCondition.isFulfilled(headVertex)) continue;
                pathVertices.add(vertex);
                pathVertices.add(headVertex);
            }
        }
    }

    private void prepareGraph(AtomicVertex[] graph) {
        for (int i = 0; i < graph.length; ++i) {
            AtomicVertex vertex = graph[i];
            this.prepareVertex(vertex);
            int n = vertex.getNumberOfOutgoingArcs();
            for (int j = 0; j < n; ++j) {
                this.prepareVertex((AtomicVertex)vertex.getHeadVertex(j));
            }
        }
    }

    private void prepareVertex(AtomicVertex vertex) {
        vertex.reset();
        vertex.setOrder(Integer.MAX_VALUE);
        if (this._startSetCondition.isFulfilled(vertex)) {
            vertex.visit();
        }
    }

    private int calculateShortestPath(AtomicVertex vertex, HashSet currentPath) {
        currentPath.add(vertex);
        int shortestPath = Integer.MAX_VALUE;
        int n = vertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n; ++i) {
            int pathLength;
            AtomicVertex nextVertex = (AtomicVertex)vertex.getHeadVertex(i);
            this.prepareIfFinal(nextVertex);
            int n2 = pathLength = this._startSetCondition.isFulfilled(nextVertex) ? Integer.MAX_VALUE : nextVertex.getOrder();
            if (!currentPath.contains(nextVertex) && !nextVertex.isVisited()) {
                pathLength = this.calculateShortestPath(nextVertex, currentPath);
                nextVertex.setOrder(pathLength);
                nextVertex.visit();
            }
            shortestPath = Math.min(shortestPath, pathLength);
        }
        currentPath.remove(vertex);
        if (shortestPath < Integer.MAX_VALUE) {
            ++shortestPath;
        }
        return shortestPath;
    }

    private void prepareIfFinal(AtomicVertex vertex) {
        if (this._finalSetCondition.isFulfilled(vertex)) {
            vertex.visit();
            vertex.setOrder(0);
        }
    }

    private void followPaths(AtomicVertex vertex, HashSet pathVertices) {
        pathVertices.add(vertex);
        int shortestPathLength = vertex.getOrder() - 1;
        int n = vertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n; ++i) {
            AtomicVertex nextVertex = (AtomicVertex)vertex.getHeadVertex(i);
            int pathLength = nextVertex.getOrder();
            if (pathLength >= Integer.MAX_VALUE || pathVertices.contains(nextVertex) || this._shortestPathsOnly && pathLength != shortestPathLength) continue;
            pathVertices.add(nextVertex);
            if (pathLength <= 0) continue;
            this.followPaths(nextVertex, pathVertices);
        }
    }
}

