/*
 * Decompiled with CFR 0.152.
 */
package classycle.renderer;

import classycle.ClassAttributes;
import classycle.NameAndSourceAttributes;
import classycle.graph.AtomicVertex;
import classycle.graph.StrongComponent;
import classycle.renderer.AbstractStrongComponentRenderer;
import classycle.renderer.AtomicVertexRenderer;
import java.text.MessageFormat;

public class TemplateBasedClassRenderer
implements AtomicVertexRenderer {
    private MessageFormat _format;

    public TemplateBasedClassRenderer(String template) {
        this._format = new MessageFormat(template);
    }

    public String render(AtomicVertex vertex, StrongComponent cycle, int layerIndex) {
        String[] values = new String[10];
        NameAndSourceAttributes attributes = (NameAndSourceAttributes)vertex.getAttributes();
        values[0] = attributes.getName();
        values[2] = Integer.toString(attributes.getSize());
        values[9] = attributes.getSources();
        if (attributes instanceof ClassAttributes) {
            ClassAttributes ca = (ClassAttributes)attributes;
            values[1] = ca.getType();
            values[3] = ca.isInnerClass() ? "true" : "false";
        } else {
            values[1] = "";
            values[3] = "";
        }
        values[4] = Integer.toString(vertex.getNumberOfIncomingArcs());
        int usesInternal = 0;
        int usesExternal = 0;
        int n = vertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n; ++i) {
            if (((AtomicVertex)vertex.getHeadVertex(i)).isGraphVertex()) {
                ++usesInternal;
                continue;
            }
            ++usesExternal;
        }
        values[5] = Integer.toString(usesInternal);
        values[6] = Integer.toString(usesExternal);
        values[7] = Integer.toString(layerIndex);
        values[8] = cycle == null ? "" : AbstractStrongComponentRenderer.createName(cycle);
        return this._format.format(values);
    }
}

