/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.pantsbuild.jarjar.StringReader;
import org.pantsbuild.jarjar.util.ClassPathEntry;
import org.pantsbuild.jarjar.util.ClassPathIterator;
import org.pantsbuild.jarjar.util.RuntimeIOException;

class StringDumper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String classPath, PrintWriter pw) throws IOException {
        DumpStringReader stringReader = new DumpStringReader(pw);
        ClassPathIterator cp = new ClassPathIterator(classPath);
        try {
            while (cp.hasNext()) {
                ClassPathEntry entry = cp.next();
                InputStream in = entry.openStream();
                try {
                    new ClassReader(in).accept((ClassVisitor)stringReader, 0);
                }
                catch (Exception e) {
                    System.err.println("Error reading " + entry.getName() + ": " + e.getMessage());
                }
                finally {
                    in.close();
                }
                pw.flush();
            }
        }
        catch (RuntimeIOException e) {
            throw (IOException)e.getCause();
        }
        finally {
            cp.close();
        }
    }

    private static String escapeStringLiteral(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        block9: for (char ch : value.toCharArray()) {
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    private static class DumpStringReader
    extends StringReader {
        private final PrintWriter pw;
        private String className;

        public DumpStringReader(PrintWriter pw) {
            this.pw = pw;
        }

        @Override
        public void visitString(String className, String value, int line) {
            if (value.length() > 0) {
                if (!className.equals(this.className)) {
                    this.className = className;
                    this.pw.println(className.replace('/', '.'));
                }
                this.pw.print("\t");
                if (line >= 0) {
                    this.pw.print(line + ": ");
                }
                this.pw.print(StringDumper.escapeStringLiteral(value));
                this.pw.println();
            }
        }
    }
}

