/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.sys.package$;
import xsbt.boot.LaunchConfiguration;
import xsbt.boot.Locks$;
import xsbt.boot.Pre$;
import xsbt.boot.ServerConfiguration;
import xsbt.boot.ServerLocator$$anon$1;
import xsbt.boot.ServerLocator$$anonfun$locate$1;

public final class ServerLocator$ {
    public static final ServerLocator$ MODULE$;
    private final String SERVER_URI_PROPERTY;

    static {
        new ServerLocator$();
    }

    public static URI locate(File file2, LaunchConfiguration launchConfiguration) {
        Option option = launchConfiguration.serverConfig();
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw package$.error("No server lock file configured.  Cannot locate server.");
        }
        if (option instanceof Some) {
            ServerConfiguration serverConfiguration = (ServerConfiguration)((Some)option).x();
            File file3 = serverConfiguration.lockFile();
            ServerLocator$$anonfun$locate$1 serverLocator$$anonfun$locate$1 = new ServerLocator$$anonfun$locate$1(file2, launchConfiguration, serverConfiguration);
            file3 = new File(file3.getParentFile(), new StringContext(Predef$.wrapRefArray(new String[]{"", ".lock"})).s$6adc1fb3(Predef$.genericWrapArray(new Object[]{file3.getName()})));
            return (URI)Locks$.MODULE$.apply(file3, new ServerLocator$$anon$1(serverLocator$$anonfun$locate$1));
        }
        throw new MatchError(option);
    }

    public final Option readProperties(File file2) {
        try {
            String string = Pre$.readProperties(file2).getProperty(this.SERVER_URI_PROPERTY);
            Option option = string == null ? None$.MODULE$ : new Some(new URI(string));
            return option;
        }
        catch (IOException iOException) {
            return None$.MODULE$;
        }
    }

    public final void writeProperties(File file2, URI uRI) {
        Properties properties = new Properties();
        properties.setProperty(this.SERVER_URI_PROPERTY, uRI.toASCIIString());
        new FileOutputStream(file2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Pre$.writeProperties(properties, file2, new StringContext(Predef$.wrapRefArray(new String[]{"Server Startup at ", ""})).s$6adc1fb3(Predef$.genericWrapArray(new Object[]{simpleDateFormat.format(new Date())})));
    }

    public static boolean isReachable(URI uRI) {
        try {
            Socket socket = new Socket(uRI.getHost(), uRI.getPort());
            try {
                return socket.isConnected();
            }
            finally {
                socket.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private ServerLocator$() {
        MODULE$ = this;
        this.SERVER_URI_PROPERTY = "server.uri";
    }
}

