/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.Date;
import devplugin.TvBrowserSettings;
import java.awt.Color;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginManagerImpl;

public final class TvBrowserSettingsImpl
implements TvBrowserSettings {
    private static TvBrowserSettingsImpl INSTANCE;

    private TvBrowserSettingsImpl() {
    }

    public TvBrowserSettingsImpl(PluginManagerImpl pManager) throws IllegalAccessException {
        if (pManager == null || INSTANCE != null) {
            throw new IllegalAccessException("Only PluginManagerImpl can create an instance of this class");
        }
        INSTANCE = new TvBrowserSettingsImpl();
    }

    @Override
    public String getTvBrowserUserHome() {
        return Settings.getUserSettingsDirName();
    }

    @Override
    public int[] getTimeButtonTimes() {
        return Settings.Buttons.TIME_BUTTONS.getIntArray();
    }

    @Override
    public Date getLastDownloadDate() {
        return Settings.Data.DOWNLOAD_DATE_LAST.getDate();
    }

    @Override
    public int getDefaultNetworkConnectionTimeout() {
        return Settings.Network.DEFAULT_CONNECTION_TIMEOUT.getInt();
    }

    @Override
    public Color getColorForMarkingPriority(int priority) {
        Color result = null;
        if (priority > Settings.getHighlightingPriorityMaximum()) {
            priority = Settings.getHighlightingPriorityMaximum();
        }
        if (priority == -1) {
            result = new Color(255, 255, 255, 0);
        } else if (priority > -1) {
            result = Settings.getHighlightingColorForPriority(priority);
        }
        return result;
    }

    @Override
    public int getProgramTableEndOfDay() {
        return Settings.ProgramTable.END_OF_DAY.getInt();
    }

    @Override
    public int getProgramTableStartOfDay() {
        return Settings.ProgramTable.START_OF_DAY.getInt();
    }

    @Override
    public Color getProgramPanelOnAirLightColor() {
        return Settings.ProgramPanel.COLOR_ON_AIR_LIGHT.getColor();
    }

    @Override
    public Color getProgramPanelOnAirDarkColor() {
        return Settings.ProgramPanel.COLOR_ON_AIR_DARK.getColor();
    }

    @Override
    public boolean isMarkingBorderPainted() {
        return Settings.Markings.WITH_MARKINGS_SHOWING_BORDER.getBoolean();
    }

    @Override
    public boolean isUsingExtraSpaceForMarkIcons() {
        return Settings.Markings.USES_EXTRA_SPACE_FOR_MARK_ICONS.getBoolean();
    }

    @Override
    public short getAutoDownloadWaitingTime() {
        return Settings.General.AUTO_DOWNLOAD_WAITING_TIME.getShort();
    }

    @Override
    public Color getProgramTableMouseOverColor() {
        return Settings.ProgramTable.MOUSE_OVER.getBoolean() ? Settings.ProgramTable.COLOR_MOUSE_OVER.getColor() : null;
    }

    @Override
    public Color getProgramTableForegroundColor() {
        return Settings.ProgramTable.STYLE_BACKGROUND.getString().contains("ui") ? UIManager.getColor("List.foreground") : Settings.ProgramPanel.COLOR_FOREGROUND.getColor();
    }

    @Override
    public Color getProgramPanelSelectionColor() {
        return Settings.ProgramPanel.COLOR_KEYBOARD_SELECTED.getColor();
    }

    @Override
    public String getTimePattern() {
        return Settings.getTimePattern();
    }

    @Override
    public boolean isChannelUpdateActivated() {
        return Settings.General.AUTO_CHANNEL_UPDATE_PERIOD.getInt() > -1;
    }

    @Override
    public Color getScrollColorTimeLight() {
        return Settings.ProgramTable.COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_LIGHT.getColor();
    }

    @Override
    public Color getScrollColorTimeDark() {
        return Settings.ProgramTable.COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_DARK.getColor();
    }

    @Override
    public Color getScrollColorChannel() {
        return Settings.ProgramTable.COLOR_HIGHLIGHT_CHANNEL_PROGRAMS_BACKGROUND.getColor();
    }

    @Override
    public boolean isScrollToTimeHighlightActivated() {
        return Settings.ProgramTable.SCROLL_TO_TIME_MARKING.getBoolean();
    }

    @Override
    public boolean isScrollToChannelHighlightActivated() {
        return Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_SCROLLING.getBoolean();
    }

    @Override
    public String getDataDirectory() {
        return Settings.Directories.TV_DATA.getString();
    }

    @Override
    public boolean getCanReceiveProtocolMessages() {
        return Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.getBoolean();
    }
}

