/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.data;

import devplugin.Channel;
import devplugin.Date;
import devplugin.ProgramFieldType;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import tvbrowser.core.data.OnDemandDayProgramFile;
import tvdataservice.MutableProgram;

public class OnDemandProgram
extends MutableProgram {
    private static final Logger mLog = Logger.getLogger(OnDemandProgram.class.getName());
    private Object NULL_VALUE = "<null>";
    private OnDemandDayProgramFile mOnDemandFile;

    public OnDemandProgram(Channel channel, Date localDate, OnDemandDayProgramFile onDemandFile) {
        super(channel, localDate, true);
        this.mOnDemandFile = onDemandFile;
    }

    public void setLargeField(ProgramFieldType type, long position) {
        OnDemandValue onDemandValue = new OnDemandValue(position);
        if (type == ProgramFieldType.TITLE_TYPE) {
            this.mTitle = String.valueOf(onDemandValue.getValue(ProgramFieldType.TITLE_TYPE));
        }
        super.setObjectValueField(type, onDemandValue);
    }

    @Override
    protected Object getObjectValueField(ProgramFieldType type) {
        Object value = super.getObjectValueField(type);
        if (value instanceof OnDemandValue) {
            OnDemandValue onDemandValue = (OnDemandValue)value;
            return onDemandValue.getValue(type);
        }
        return value;
    }

    private class OnDemandValue {
        private long mPosition;
        private SoftReference<Object> mValue;

        OnDemandValue(long position) {
            this.mPosition = position;
        }

        Object getValue(ProgramFieldType type) {
            Object value = null;
            if (this.mValue != null) {
                value = this.mValue.get();
            }
            if (value == null) {
                try {
                    value = OnDemandProgram.this.mOnDemandFile.loadFieldValue(this.mPosition, type);
                    if (value == null) {
                        value = OnDemandProgram.this.NULL_VALUE;
                    }
                    this.mValue = new SoftReference<Object>(value);
                    if (mLog.isLoggable(Level.FINE)) {
                        mLog.fine("Loaded value on demand for field " + type.getName());
                    }
                }
                catch (Exception exc) {
                    mLog.log(Level.WARNING, "Loading value on demand for field " + type.getName() + " failed (channel: " + OnDemandProgram.this.getChannel() + ", date: " + OnDemandProgram.this.getDateString() + ")", exc);
                }
            }
            if (value == OnDemandProgram.this.NULL_VALUE) {
                return null;
            }
            return value;
        }
    }
}

