/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.Channel;
import devplugin.Program;
import java.lang.reflect.Method;
import tvbrowser.core.filters.Excludable;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.Node;
import tvbrowser.core.filters.filtercomponents.AcceptNoneFilterComponent;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import tvbrowser.core.filters.filtercomponents.SingleChannelFilterComponent;

class ItemNode
extends Node {
    private FilterComponent mRule;

    public ItemNode(FilterComponent rule) {
        this.mRule = rule;
    }

    @Override
    public boolean accept(Program prog) {
        return this.mRule.accept(prog);
    }

    @Override
    public boolean containsRuleComponent(String compName) {
        return this.mRule.getName().equalsIgnoreCase(compName);
    }

    @Override
    public boolean containsRuleComponent(Class<? extends Excludable> component) {
        boolean result = false;
        if (component != null && component.isInstance(this.mRule)) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isBrokenPartially() {
        boolean result = this.isBrokenCompletely();
        if (!result) {
            try {
                Method isBroken = this.mRule.getClass().getMethod("isBrokenPartially", new Class[0]);
                Object brokenResult = isBroken.invoke((Object)this.mRule, new Object[0]);
                if (brokenResult instanceof Boolean) {
                    result = (Boolean)brokenResult;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public boolean isBrokenCompletely() {
        boolean result = this.mRule instanceof AcceptNoneFilterComponent;
        if (!result) {
            try {
                Method isBroken = this.mRule.getClass().getMethod("isBrokenCompletely", new Class[0]);
                Object brokenResult = isBroken.invoke((Object)this.mRule, new Object[0]);
                if (brokenResult instanceof Boolean) {
                    result = (Boolean)brokenResult;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void updateChannelFilters(Channel[] channels) {
        if (this.mRule instanceof SingleChannelFilterComponent) {
            SingleChannelFilterComponent component = (SingleChannelFilterComponent)this.mRule;
            boolean found = false;
            for (Channel ch : channels) {
                if (!component.containsChannel(ch)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.mRule = new AcceptNoneFilterComponent(this.mRule.getName(), this.mRule.getDescription());
            }
        } else if (this.mRule instanceof AcceptNoneFilterComponent) {
            for (Channel ch : channels) {
                SingleChannelFilterComponent component = new SingleChannelFilterComponent(ch);
                if (!this.mRule.getName().equals(component.getName())) continue;
                this.mRule = component;
                break;
            }
        } else if (this.mRule instanceof ChannelFilterComponent) {
            ((ChannelFilterComponent)this.mRule).updateAvailableChannels(channels);
        }
    }
}

