/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import util.i18n.Localizer;
import util.ui.SearchForm;
import util.ui.SearchFormSettings;

public class MassFilterSettingsDialog
extends JDialog {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(MassFilterSettingsDialog.class);
    private SearchForm mForm;
    private SearchFormSettings mSearchFormSettings;

    public MassFilterSettingsDialog(Window parent, SearchFormSettings searchFormSettings) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.mSearchFormSettings = searchFormSettings;
        this.createGui();
        this.setLocationRelativeTo(parent);
    }

    private void createGui() {
        this.setTitle(mLocalizer.msg("title", "Mass-Filter Settings"));
        this.mForm = new SearchForm(false, false, false);
        this.mForm.setSearchFormSettings(this.mSearchFormSettings);
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        content.setBorder(Borders.DLU4);
        content.add((Component)this.mForm, "North");
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(e -> {
            this.okPressed();
            this.setVisible(false);
        });
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancel.addActionListener(e -> this.setVisible(false));
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(ok);
        buttons.add(cancel);
        content.add((Component)buttons, "South");
        this.pack();
    }

    private void okPressed() {
        this.mSearchFormSettings = this.mForm.getSearchFormSettings();
    }

    public SearchFormSettings getSearchFormSettings() {
        return this.mSearchFormSettings;
    }
}

