/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Marker;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import util.i18n.Localizer;

public class PluginFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginFilterComponent.class);
    private JComboBox<PluginProxy> mBox;
    private String mPluginId;

    public PluginFilterComponent(String name, String desc) {
        super(name, desc);
    }

    public PluginFilterComponent() {
        this("", "");
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        if (version == 1) {
            String pluginClassName = (String)in.readObject();
            this.mPluginId = "java." + pluginClassName;
        } else {
            this.mPluginId = (String)in.readObject();
        }
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        if (this.mPluginId == null) {
            out.writeObject("[invalid]");
        } else {
            out.writeObject(this.mPluginId);
        }
    }

    @Override
    public boolean accept(Program program) {
        if (this.mPluginId != null) {
            for (Marker marker : program.getMarkerArr()) {
                if (!this.mPluginId.equals(marker.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public String getPluginId() {
        return this.mPluginId;
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("desc", "Accept all programs marked by plugin:");
    }

    @Override
    public JPanel getSettingsPanel() {
        PluginProxy plugin;
        JPanel content = new JPanel(new BorderLayout(0, 7));
        PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
        Arrays.sort(plugins, new PluginProxy.Comparator());
        this.mBox = new JComboBox<PluginProxy>(plugins);
        if (this.mPluginId != null && (plugin = PluginProxyManager.getInstance().getPluginForId(this.mPluginId)) != null) {
            this.mBox.setSelectedItem(plugin);
        }
        content.add(this.mBox, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)content, "North");
        return centerPanel;
    }

    public String toString() {
        return mLocalizer.msg("Plugin", "Plugin");
    }

    @Override
    public void saveSettings() {
        this.mPluginId = ((PluginProxy)this.mBox.getSelectedItem()).getId();
    }

    @Override
    public int getVersion() {
        return 2;
    }

    public boolean isBrokenCompletely() {
        return this.mPluginId == null || PluginProxyManager.getInstance().getActivatedPluginForId(this.mPluginId) == null;
    }
}

