/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import java.awt.GridLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import util.i18n.Localizer;
import util.ui.SearchFormSettings;

public class TopicFavorite
extends Favorite {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(TopicFavorite.class);
    public static final String TYPE_ID = "topic";
    private String mTopic;

    public TopicFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super(in);
        in.readInt();
        this.mTopic = (String)in.readObject();
        this.mSearchFormSettings = new SearchFormSettings(this.mTopic);
        this.mSearchFormSettings.setSearchIn(2);
    }

    public TopicFavorite(String topic) {
        this.mTopic = topic = topic.trim();
        this.setName(this.mTopic);
        this.mSearchFormSettings = new SearchFormSettings(this.mTopic);
        this.mSearchFormSettings.setSearchIn(2);
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    protected void internalWriteData(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.mTopic);
    }

    @Override
    public FavoriteConfigurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public boolean isValidSearch() {
        return true;
    }

    @Override
    public String getTypeName() {
        return LOCALIZER.msg("typeName", "Topic Favorite");
    }

    class Configurator
    implements FavoriteConfigurator {
        private JTextField mSearchTextTf;

        public Configurator() {
            this.mSearchTextTf = new JTextField(TopicFavorite.this.mSearchFormSettings.getSearchText());
        }

        @Override
        public JPanel createConfigurationPanel() {
            JPanel panel = new JPanel(new GridLayout(-1, 1));
            panel.add(new JLabel(LOCALIZER.msg("topic-favorite.term", "Any program containing this term will be marked as a favorite:")));
            panel.add(this.mSearchTextTf);
            return panel;
        }

        @Override
        public void save() {
            String searchText = this.mSearchTextTf.getText();
            TopicFavorite.this.mSearchFormSettings.setSearchText(searchText);
        }

        @Override
        public boolean check() {
            if (this.mSearchTextTf.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.mSearchTextTf, LOCALIZER.msg("missingTopic.message", "Please specify a topic for the favorite!"), LOCALIZER.msg("missingTopic.title", "Invalid options"), 2);
                return false;
            }
            return true;
        }
    }
}

