/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Program;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.reminderplugin.PanelReminder;
import tvbrowser.extras.reminderplugin.ReminderContent;
import tvbrowser.extras.reminderplugin.ReminderFrame;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListDialog;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.ScrollableJPanel;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class FrameReminders
extends JFrame
implements PanelReminder.InterfaceClose<PanelReminder>,
WindowClosingIf {
    private static final String ID_WINDOW = "reminderFrameReminders";
    private static FrameReminders INSTANCE;
    private ReminderList mGlobalReminderList;
    private final ScrollableJPanel mListReminders = new ScrollableJPanel();
    private final JScrollPane mScrollPane;
    private final JButton mReschedule;
    private final JButton mDelete;
    private Thread mThreadUpdateHeight;
    private AtomicBoolean mAutoResize = null;

    private FrameReminders() {
        super(MainFrame.getInstance().getGraphicsConfiguration());
        this.mListReminders.setLayout(new BoxLayout(this.mListReminders, 1));
        this.mScrollPane = new JScrollPane(this.mListReminders);
        JButton close = new JButton(Localizer.getLocalization("i18n_close"));
        close.addActionListener(e -> this.close());
        this.mReschedule = new JButton(IconLoader.getInstance().getIconFromTheme("actions", "appointment-new", 16));
        this.mReschedule.setEnabled(false);
        this.mReschedule.setToolTipText(ReminderPlugin.LOCALIZER.msg("reschedule", "Close current Reminders and reschedule possible Reminders. (Ctrl+Enter)"));
        this.mReschedule.addActionListener(e -> {
            for (int i = this.mListReminders.getComponentCount() - 1; i >= 0; --i) {
                this.close((PanelReminder)this.mListReminders.getComponent(i), false, true);
            }
            if (ReminderPlugin.getInstance().getSettings().isSet("autoCloseFrameRemindersIfEmpty")) {
                this.close();
            }
        });
        this.mDelete = new JButton(TVBrowserIcons.delete(16));
        this.mDelete.setEnabled(false);
        this.mDelete.setToolTipText(Localizer.getLocalization("i18n_delete") + ReminderPlugin.LOCALIZER.msg("delete", " (Ctrl+Delete)"));
        this.mDelete.addActionListener(e -> {
            for (int i = this.mListReminders.getComponentCount() - 1; i >= 0; --i) {
                this.close((PanelReminder)this.mListReminders.getComponent(i), false, false);
            }
            if (ReminderPlugin.getInstance().getSettings().isSet("autoCloseFrameRemindersIfEmpty")) {
                this.close();
            }
        });
        JPanel content = new JPanel((LayoutManager)new FormLayout("default,100dlu:grow,default,5dlu,default", "fill:50dlu:grow,5dlu,default"));
        content.setBorder(Borders.DIALOG);
        content.add((Component)this.mScrollPane, CC.xyw((int)1, (int)1, (int)5));
        content.add((Component)this.mDelete, CC.xy((int)1, (int)3));
        content.add((Component)this.mReschedule, CC.xy((int)3, (int)3));
        content.add((Component)close, CC.xy((int)5, (int)3));
        this.setContentPane(content);
        this.getRootPane().setDefaultButton(close);
        this.addComponentListener(new ComponentListener(){
            private Thread mSavePosWait;
            private AtomicBoolean mWaitSavePos = new AtomicBoolean(false);
            private Thread mSaveSizeWait;
            private AtomicBoolean mWaitSaveSize = new AtomicBoolean(false);

            @Override
            public void componentShown(ComponentEvent e) {
                FrameReminders.this.updateHeight();
                this.savePos(e);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.saveSize(e);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.savePos(e);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.savePos(e);
            }

            private void savePos(final ComponentEvent e) {
                this.mWaitSavePos.set(true);
                if (this.mSavePosWait == null || !this.mSavePosWait.isAlive()) {
                    this.mSavePosWait = new Thread("SAVE WINDOW POSITION WAITING THREAD"){

                        @Override
                        public void run() {
                            while (mWaitSavePos.getAndSet(false)) {
                                try {
                                    1.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            if ((FrameReminders.this.getExtendedState() & 6) != 6) {
                                ReminderPlugin.getInstance().getSettings().set("frameRemindersXpos", e.getComponent().getX());
                                ReminderPlugin.getInstance().saveReminders();
                            }
                        }
                    };
                    this.mSavePosWait.start();
                }
            }

            private void saveSize(final ComponentEvent e) {
                this.mWaitSaveSize.set(true);
                if (this.mSaveSizeWait == null || !this.mSaveSizeWait.isAlive()) {
                    this.mSaveSizeWait = new Thread("SAVE WINDOW SIZE WAITING THREAD"){

                        @Override
                        public void run() {
                            while (mWaitSaveSize.getAndSet(false)) {
                                try {
                                    2.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            if ((FrameReminders.this.getExtendedState() & 6) != 6) {
                                ReminderPlugin.getInstance().getSettings().set("frameRemindersWidth", e.getComponent().getWidth());
                                ReminderPlugin.getInstance().saveReminders();
                            }
                        }
                    };
                    this.mSaveSizeWait.start();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FrameReminders.this.close();
            }
        });
        this.setTitle(ReminderFrame.LOCALIZER.msg("title2", "Current Reminders"));
        this.setIconImages(TVBrowser.ICONS_WINDOW);
        this.setDefaultCloseOperation(0);
        UiUtilities.registerForClosing(this);
        KeyStroke stroke = ReminderPlugin.getKeyStrokeFrameReminders();
        StringBuilder key = new StringBuilder();
        key.append(String.valueOf(stroke.getKeyCode()));
        key.append("_");
        key.append(String.valueOf(stroke.getModifiers()));
        this.rootPane.getInputMap(2).put(stroke, key.toString());
        this.rootPane.getActionMap().put(key.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameReminders.this.close();
            }
        });
        KeyStroke closeReminderInOrder = KeyStroke.getKeyStroke(27, 640);
        this.rootPane.getInputMap(2).put(closeReminderInOrder, "close_reminder_in_order");
        this.rootPane.getActionMap().put("close_reminder_in_order", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrameReminders.this.mListReminders.getComponentCount() > 0) {
                    FrameReminders.this.close((PanelReminder)FrameReminders.this.mListReminders.getComponent(0));
                }
            }
        });
        KeyStroke closeReminderInOrderAndReschedule = KeyStroke.getKeyStroke(27, 64);
        this.rootPane.getInputMap(2).put(closeReminderInOrderAndReschedule, "close_reminder_in_order_and_reschedule");
        this.rootPane.getActionMap().put("close_reminder_in_order_and_reschedule", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrameReminders.this.mListReminders.getComponentCount() > 0) {
                    FrameReminders.this.close((PanelReminder)FrameReminders.this.mListReminders.getComponent(0), true, true);
                }
            }
        });
        KeyStroke closeAndReschedule = KeyStroke.getKeyStroke(10, 128);
        this.rootPane.getInputMap(2).put(closeAndReschedule, "close_reminder_and_reschedule");
        this.rootPane.getActionMap().put("close_reminder_and_reschedule", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameReminders.this.mReschedule.doClick();
            }
        });
        KeyStroke deleteAndClose = KeyStroke.getKeyStroke(127, 128);
        this.rootPane.getInputMap(2).put(deleteAndClose, "delete_and_close_reminder");
        this.rootPane.getActionMap().put("delete_and_close_reminder", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameReminders.this.mDelete.doClick();
            }
        });
        Settings.layoutWindow(ID_WINDOW, this, new Dimension(Sizes.dialogUnitXAsPixel((int)400, (Component)this), Sizes.dialogUnitYAsPixel((int)300, (Component)this)));
        this.updateWindowSettings();
    }

    public void updateWindowSettings() {
        boolean autoResize;
        boolean bl = autoResize = !ReminderPlugin.getInstance().getSettings().isSet("autoResizeEnabled");
        if (this.mAutoResize == null || this.mAutoResize.get() != autoResize) {
            if (this.mAutoResize == null) {
                this.mAutoResize = new AtomicBoolean(autoResize);
            } else {
                this.mAutoResize.set(autoResize);
            }
            if (autoResize) {
                Settings.updateWindowSettings(ID_WINDOW, new Dimension(Sizes.dialogUnitXAsPixel((int)400, (Component)this), Sizes.dialogUnitYAsPixel((int)300, (Component)this)), false);
            } else {
                int width = Integer.parseInt(ReminderPlugin.getInstance().getSettings().get("frameRemindersWidth", String.valueOf(this.getWidth())));
                Settings.updateWindowSettings(ID_WINDOW, new Dimension(Sizes.dialogUnitXAsPixel((int)400, (Component)this), Sizes.dialogUnitYAsPixel((int)300, (Component)this)), true);
                this.pack();
                this.setSize(width, this.getHeight());
                this.setLocation(ReminderPlugin.getInstance().getSettings().getAsInt("frameRemindersXpos"), Toolkit.getDefaultToolkit().getScreenSize().height - 10);
                if (this.isVisible()) {
                    this.updateHeight();
                }
            }
        }
    }

    private void updateButtons() {
        this.mReschedule.setEnabled(this.mListReminders.getComponentCount() > 0);
        this.mDelete.setEnabled(this.mListReminders.getComponentCount() > 0);
        if (this.isVisible()) {
            this.updateHeight();
        }
    }

    public static synchronized FrameReminders getInstance() {
        return FrameReminders.getInstance(true);
    }

    public static synchronized FrameReminders getInstance(boolean create) {
        if (INSTANCE == null && create) {
            INSTANCE = new FrameReminders();
        }
        return INSTANCE;
    }

    public void addReminders(ReminderList list, ArrayList<ReminderListItem> items) {
        try {
            this.mGlobalReminderList = list;
            for (int i = items.size() - 1; i >= 0; --i) {
                ReminderListItem item = items.get(i);
                this.mGlobalReminderList.blockProgram(item.getProgram());
                this.mListReminders.add((Component)new PanelReminder(item, this), 0);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            SwingUtilities.invokeLater(() -> {
                if ((this.getExtendedState() & 1) == 1) {
                    this.setExtendedState(0);
                }
                this.mScrollPane.getVerticalScrollBar().setValue(0);
                this.mListReminders.repaint();
                this.mListReminders.revalidate();
            });
            if (ReminderPlugin.getInstance().getSettings().isSet("frameRemindersToFrontOnAdd")) {
                SwingUtilities.invokeLater(() -> {
                    this.setExtendedState(this.getExtendedState());
                    this.setAlwaysOnTop(true);
                    this.toFront();
                    this.requestFocus();
                    this.setAlwaysOnTop(false);
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.updateButtons();
    }

    @Override
    public void close(PanelReminder item) {
        this.close(item, ReminderPlugin.getInstance().getSettings().isSet("autoCloseFrameRemindersIfEmpty"), false);
    }

    public void close(PanelReminder item, boolean closeFrameIfEmptry, boolean reschedule) {
        if (item != null) {
            ReminderListItem reminder = item.getItem();
            int minutes = item.getNextReminderTime(reschedule);
            item.stopTimer();
            this.mListReminders.remove(item);
            if (this.isVisible()) {
                this.mListReminders.repaint();
                this.mListReminders.revalidate();
            }
            this.mGlobalReminderList.removeWithoutChecking(reminder.getProgramItem());
            if (minutes != -31) {
                Program program = reminder.getProgram();
                this.mGlobalReminderList.add(program, new ReminderContent(minutes, reminder.getComment()));
                this.mGlobalReminderList.unblockProgram(program);
            }
            SwingUtilities.invokeLater(() -> ReminderPlugin.getInstance().updateRootNode(true));
            ReminderListDialog.updateReminderList();
        }
        this.updateButtons();
        if (this.mListReminders.getComponentCount() < 1 && closeFrameIfEmptry) {
            this.close();
        }
    }

    public void updateReminder(ReminderListItem item) {
        boolean repaint = false;
        for (int i = 0; i < this.mListReminders.getComponentCount(); ++i) {
            PanelReminder panel = (PanelReminder)this.mListReminders.getComponent(i);
            if (!panel.containsItem(item) || !panel.update()) continue;
            panel.stopTimer();
            this.mListReminders.remove(panel);
            this.mGlobalReminderList.removeWithoutChecking(item.getProgramItem());
            if (item.getMinutes() != -31) {
                Program program = item.getProgram();
                this.mGlobalReminderList.add(program, new ReminderContent(item.getMinutes(), item.getComment()));
                this.mGlobalReminderList.unblockProgram(program);
            }
            repaint = true;
        }
        if (repaint && this.isVisible()) {
            this.mListReminders.repaint();
            this.mListReminders.revalidate();
        }
        if (this.mListReminders.getComponentCount() < 1 && ReminderPlugin.getInstance().getSettings().isSet("autoCloseFrameRemindersIfEmpty")) {
            this.close();
        }
    }

    public void removeReminder(ReminderListItem item) {
        for (int i = 0; i < this.mListReminders.getComponentCount(); ++i) {
            PanelReminder panel = (PanelReminder)this.mListReminders.getComponent(i);
            if (!panel.containsItem(item)) continue;
            panel.stopTimer();
            this.mListReminders.remove(panel);
        }
        if (this.isVisible()) {
            this.mListReminders.repaint();
            this.mListReminders.revalidate();
            this.mScrollPane.repaint();
            this.mScrollPane.revalidate();
        }
        this.updateButtons();
        if (this.mListReminders.getComponentCount() < 1 && ReminderPlugin.getInstance().getSettings().isSet("autoCloseFrameRemindersIfEmpty")) {
            this.close();
        }
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    private synchronized void updateHeight() {
        if (ReminderPlugin.getInstance().getSettings().isSet("autoResizeEnabled") && (this.mThreadUpdateHeight == null || !this.mThreadUpdateHeight.isAlive())) {
            this.mThreadUpdateHeight = new Thread("UPDATE HEIGHT THREAD"){

                @Override
                public void run() {
                    try {
                        8.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (int g = 0; g < 2; ++g) {
                        int heightWithoutScroll = 0;
                        Container c = FrameReminders.this.getContentPane();
                        int height = c.getInsets().top + c.getInsets().bottom;
                        int space = 0;
                        for (int i = 1; i < c.getComponentCount(); ++i) {
                            Insets insets = ((JComponent)c.getComponent(i)).getInsets();
                            space = Math.max(space, ((JComponent)c.getComponent((int)i)).getPreferredSize().height + insets.top + insets.bottom);
                        }
                        heightWithoutScroll = height + space;
                        if (FrameReminders.this.mListReminders.getComponentCount() > 0) {
                            Dimension scrnSize = Toolkit.getDefaultToolkit().getScreenSize();
                            Rectangle winSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                            Insets insets = FrameReminders.this.getInsets();
                            int maxWindowHeight = winSize.height;
                            int titleBarHeight = insets.top + insets.bottom;
                            int taskBarHeight = scrnSize.height - winSize.height;
                            int remindersHeight = 0;
                            for (int i = 0; i < FrameReminders.this.mListReminders.getComponentCount(); ++i) {
                                remindersHeight += Math.max(FrameReminders.this.mListReminders.getComponent((int)i).getPreferredSize().height, FrameReminders.this.mListReminders.getComponent(i).getHeight());
                            }
                            int futureHeight = remindersHeight + heightWithoutScroll + titleBarHeight + 3;
                            if (futureHeight < maxWindowHeight) {
                                FrameReminders.this.setSize(Math.max(Sizes.dialogUnitXAsPixel((int)400, (Component)FrameReminders.this), FrameReminders.this.getWidth()), futureHeight);
                            } else {
                                FrameReminders.this.setSize(Math.max(Sizes.dialogUnitXAsPixel((int)400, (Component)FrameReminders.this), FrameReminders.this.getWidth()), maxWindowHeight + insets.bottom + (insets.top == 0 ? -30 : 0));
                            }
                            int xPos = ReminderPlugin.getInstance().getSettings().getAsInt("frameRemindersXpos");
                            int winBorder = xPos - winSize.width + FrameReminders.this.getWidth();
                            if (winBorder == 0) {
                                xPos = winSize.width - FrameReminders.this.getWidth() + insets.right - 1;
                            } else if (xPos <= insets.left) {
                                xPos = 0 - insets.left + 1;
                            }
                            if (ReminderPlugin.getInstance().getSettings().isAutoResizeTop()) {
                                FrameReminders.this.setLocation(xPos, winSize.y);
                            } else {
                                int y = scrnSize.height - FrameReminders.this.getHeight() + insets.bottom;
                                if (scrnSize.height - winSize.y != winSize.height) {
                                    y -= taskBarHeight;
                                }
                                FrameReminders.this.setLocation(xPos, y);
                            }
                        }
                        try {
                            8.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.mThreadUpdateHeight.setPriority(1);
            this.mThreadUpdateHeight.start();
        }
    }

    public void openShow() {
        this.updateButtons();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        SwingUtilities.invokeLater(() -> {
            if ((this.getExtendedState() & 1) == 1) {
                this.setExtendedState(0);
            }
            this.setExtendedState(this.getExtendedState());
            this.setAlwaysOnTop(true);
            this.toFront();
            this.requestFocus();
            this.setAlwaysOnTop(false);
        });
    }

    public synchronized void updatePrograms() {
        for (int i = this.mListReminders.getComponentCount() - 1; i >= 0; --i) {
            PanelReminder panel = (PanelReminder)this.mListReminders.getComponent(i);
            Program p = panel.getProgram();
            if (p.getProgramState() == 1) {
                p = PluginManagerImpl.getInstance().getProgram(p.getUniqueID());
            } else if (p.getProgramState() == 2) {
                p = null;
            }
            if (p == null) {
                this.close(panel, false, false);
                continue;
            }
            panel.setProgram(p);
        }
    }
}

