/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.Date;
import devplugin.Program;
import javax.swing.JComboBox;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.io.IOUtilities;

public final class ReminderConstants {
    public static final int DONT_REMIND_AGAIN = -31;
    public static final int NO_REMINDER = -42;
    public static final RemindValue DONT_REMIND_AGAIN_VALUE = new RemindValue(-31);
    static final RemindValue[] REMIND_AFTER_VALUE_ARR = new RemindValue[]{new RemindValue(-30), new RemindValue(-20), new RemindValue(-10), new RemindValue(-5), new RemindValue(-1)};
    static final RemindValue[] REMIND_BEFORE_VALUE_ARR = new RemindValue[]{new RemindValue(0), new RemindValue(1), new RemindValue(2), new RemindValue(3), new RemindValue(5), new RemindValue(10), new RemindValue(15), new RemindValue(30), new RemindValue(60), new RemindValue(90), new RemindValue(120), new RemindValue(240), new RemindValue(480), new RemindValue(720), new RemindValue(1440), new RemindValue(2880), new RemindValue(4320), new RemindValue(10080)};

    static final String getStringForMinutes(int minutes) {
        int i;
        if (minutes == -31) {
            return DONT_REMIND_AGAIN_VALUE.toString();
        }
        for (i = 0; i < REMIND_BEFORE_VALUE_ARR.length; ++i) {
            if (REMIND_BEFORE_VALUE_ARR[i].getMinutes() != minutes) continue;
            return REMIND_BEFORE_VALUE_ARR[i].toString();
        }
        for (i = 0; i < REMIND_AFTER_VALUE_ARR.length; ++i) {
            if (REMIND_AFTER_VALUE_ARR[i].getMinutes() != minutes) continue;
            return REMIND_AFTER_VALUE_ARR[i].toString();
        }
        return null;
    }

    public static final JComboBox<RemindValue> getPreReminderMinutesSelection(int selectedMinutes) {
        JComboBox<RemindValue> selection = new JComboBox<RemindValue>();
        if (selectedMinutes < 0) {
            selectedMinutes = ReminderPlugin.getInstance().getDefaultReminderTime();
        }
        for (RemindValue value : REMIND_BEFORE_VALUE_ARR) {
            selection.addItem(value);
            if (value.getMinutes() != selectedMinutes) continue;
            selection.setSelectedIndex(selection.getItemCount() - 1);
        }
        return selection;
    }

    public static final int getReminderMinutesSelected(JComboBox<RemindValue> selection) {
        int result = -31;
        Object item = selection.getSelectedItem();
        if (item != null && item instanceof RemindValue) {
            result = ((RemindValue)item).getMinutes();
        }
        return result;
    }

    static int getAutoCloseReminderTime(Program p) {
        int autoCloseReminderTime = 0;
        try {
            if (ReminderPlugin.getInstance().getSettings().isAutoCloseOnEnd()) {
                int endTime = (p.getStartTime() + p.getLength()) * 60;
                int currentTime = IOUtilities.getSecondsAfterMidnight();
                int dateDiff = p.getDate().compareTo(Date.getCurrentDate());
                if (dateDiff == -1) {
                    currentTime += 86400;
                } else if (dateDiff == 1) {
                    endTime += 86400;
                }
                autoCloseReminderTime = endTime - currentTime;
            } else {
                autoCloseReminderTime = ReminderPlugin.getInstance().getSettings().isAutoCloseOnTime() ? ReminderPlugin.getInstance().getSettings().getAsInt("autoCloseReminderTime") : 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return autoCloseReminderTime;
    }
}

