/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.Program;
import devplugin.ProgramItem;
import java.awt.Window;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.reminderplugin.ReminderContent;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.i18n.Localizer;
import util.program.ProgramUtilities;
import util.ui.UiUtilities;

public class ReminderListItem
implements Comparable<ReminderListItem> {
    public static final int MAX_FORWARD_REMINDER_TIME = -30;
    private static final String KEY_REF_CNT = "refCnt";
    private static final String KEY_MINUTES = "minutes";
    private static final String KEY_COMMENT = "comment";
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderListItem.class);
    private ProgramItem mProgramItem;
    public static final ReminderListItem SEPARATOR_ITEM = new ReminderListItem();

    private ReminderListItem() {
        this.mProgramItem = new ProgramItem(PluginManagerImpl.getInstance().getExampleProgram());
    }

    public ReminderListItem(ProgramItem item) {
        this.mProgramItem = item;
    }

    public ReminderListItem(Program prog, int minutes) {
        this.mProgramItem = new ProgramItem(prog);
        this.setMinutes(minutes);
    }

    public ReminderListItem(Program prog, ReminderContent reminderContent) {
        this(prog, reminderContent.getReminderMinutes());
        this.setComment(reminderContent.getReminderComment());
    }

    public void setReferenceCount(int refCnt) {
        this.mProgramItem.setProperty(KEY_REF_CNT, Integer.toString(refCnt));
    }

    public ProgramItem getProgramItem() {
        return this.mProgramItem;
    }

    public int getReferenceCount() {
        String cnt = this.mProgramItem.getProperty(KEY_REF_CNT);
        if (cnt != null) {
            try {
                return Integer.parseInt(cnt);
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        return 1;
    }

    public void incReferenceCount() {
        int cnt = this.getReferenceCount() + 1;
        this.mProgramItem.setProperty(KEY_REF_CNT, Integer.toString(cnt));
    }

    public void decReferenceCount() {
        int cnt = this.getReferenceCount() - 1;
        if (cnt >= 0) {
            this.mProgramItem.setProperty(KEY_REF_CNT, Integer.toString(cnt));
        }
    }

    public int getMinutes() {
        String m = this.mProgramItem.getProperty(KEY_MINUTES);
        if (m != null) {
            try {
                return Integer.parseInt(m);
            }
            catch (NumberFormatException e) {
                return 10;
            }
        }
        return 10;
    }

    public void setMinutes(int minutes) {
        if (minutes < -30) {
            minutes = ReminderPlugin.getInstance().getDefaultReminderTime();
        }
        this.mProgramItem.setProperty(KEY_MINUTES, Integer.toString(minutes));
    }

    public String getComment() {
        String comment = this.mProgramItem.getProperty(KEY_COMMENT);
        if (comment != null) {
            return comment;
        }
        return "";
    }

    public void setComment(String comment) {
        if (comment != null) {
            this.mProgramItem.setProperty(KEY_COMMENT, comment);
        }
    }

    public Program getProgram() {
        return this.mProgramItem.getProgram();
    }

    @Override
    public int compareTo(ReminderListItem other) {
        return ProgramUtilities.getProgramComparator().compare(this.getProgram(), other.getProgram());
    }

    public void changeComment(Window parentFrame) {
        String comment = this.getComment();
        if (comment == null) {
            comment = "";
        }
        if ((comment = UiUtilities.showInputDialog(parentFrame, mLocalizer.msg("comment.message", "Enter new comment"), comment)) != null) {
            this.setComment(comment);
        }
    }

    public void refreshProgram() {
        this.mProgramItem.refreshProgram();
    }
}

