/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.finder.calendar;

import devplugin.Date;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.ui.finder.calendar.AbstractCalendarPanel;

public class CalendarPanel
extends AbstractCalendarPanel {
    private static final int COLUMNS = 7;
    private static final int ROWS = 6;
    private JComponent[][] components = new JComponent[7][6];
    private KeyListener mKeyListener;
    private int mFirstDayOfWeek = Settings.Locales.FIRST_DAY_OF_WEEK.getInt();

    public CalendarPanel(KeyListener keyListener) {
        this.mKeyListener = keyListener;
        this.rebuildControls();
        this.addMouseListener(this);
        this.addKeyListener(keyListener);
    }

    @Override
    protected void rebuildControls() {
        this.removeAll();
        this.setLayout(new GridLayout(6, 7));
        Date date = this.getFirstDate();
        while (date.getDayOfWeek() != this.mFirstDayOfWeek) {
            date = date.addDays(-1);
        }
        Date weekday = date;
        for (int i = 0; i < 7; ++i) {
            this.components[i][0] = new JLabel(new SimpleDateFormat("E").format(weekday.getCalendar().getTime()));
            this.components[i][0].addKeyListener(this.mKeyListener);
            ((JLabel)this.components[i][0]).setHorizontalAlignment(0);
            this.add(this.components[i][0]);
            weekday = weekday.addDays(1);
        }
        for (int y = 1; y < 6; ++y) {
            for (int x = 0; x < 7; ++x) {
                ExtendedButton currentButton = new ExtendedButton();
                currentButton.addKeyListener(this.mKeyListener);
                this.components[x][y] = currentButton;
                currentButton.setSelectedDate(date);
                currentButton.setEnabled(this.isValidDate(date));
                this.add(this.components[x][y]);
                date = date.addDays(1);
                currentButton.addActionListener(currentButton);
                currentButton.addMouseListener(this);
            }
        }
    }

    @Override
    public void markDate(final Date d, final Runnable callback, final boolean informPluginPanels) {
        this.setCurrentDate(d);
        if (this.mDateChangedListener == null) {
            return;
        }
        for (int y = 1; y < 6; ++y) {
            for (int x = 0; x < 7; ++x) {
                if (!(this.components[x][y] instanceof ExtendedButton)) continue;
                ExtendedButton button = (ExtendedButton)this.components[x][y];
                button.setSelected(button.getSelectedDate().equals(d));
            }
        }
        Thread thread = new Thread("Finder"){

            @Override
            public void run() {
                CalendarPanel.this.mDateChangedListener.dateChanged(d, CalendarPanel.this, callback, informPluginPanels);
            }
        };
        thread.start();
    }

    @Override
    public void updateItems() {
        for (int y = 1; y < 6; ++y) {
            for (int x = 0; x < 7; ++x) {
                ExtendedButton currentButton = (ExtendedButton)this.components[x][y];
                currentButton.setEnabled(TvDataBase.getInstance().dataAvailable(currentButton.getSelectedDate()));
            }
        }
    }

    private class ExtendedButton
    extends JToggleButton
    implements ActionListener {
        private Date mSelectedDate = null;

        private ExtendedButton() {
            this.setMargin(new Insets(1, -10, 1, -10));
            Font font = this.getFont();
            font = font.deriveFont(font.getSize() / 2);
            this.setFont(font);
            Dimension size = this.getMinimumSize();
            this.setMinimumSize(new Dimension((int)size.getWidth() / 2, (int)size.getHeight() / 2));
        }

        public Date getSelectedDate() {
            return this.mSelectedDate;
        }

        public void setSelectedDate(Date selectedDate) {
            this.mSelectedDate = selectedDate;
            Object value = Integer.toString(selectedDate.getDayOfMonth());
            if (((String)value).length() == 1) {
                value = "0" + (String)value;
            }
            this.setText((String)value);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CalendarPanel.this.markDate(this.mSelectedDate, true);
        }
    }
}

