/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import devplugin.Channel;
import devplugin.ChannelFilter;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import util.ui.ChannelContextMenu;
import util.ui.ChannelListCellRenderer;
import util.ui.DragAndDropMouseListener;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.UiUtilities;

public class ChannelChooserPanel
extends JPanel
implements ListDropAction<Object> {
    private DefaultListModel<Object> mChannelChooserModel;
    private JList<Object> mList;
    private MainFrame mParent;
    private boolean disableSync = false;
    private ChannelFilter mChannelFilter;

    public ChannelChooserPanel(MainFrame frame, KeyListener keyListener) {
        this.mParent = frame;
        this.mChannelChooserModel = new DefaultListModel();
        this.mList = new JList<Object>(this.mChannelChooserModel){

            @Override
            public void setSelectedIndex(int index) {
                if (index >= 0 && this.getModel().getElementAt(index) instanceof String) {
                    int test = this.getSelectedIndex();
                    index = test < index ? ++index : --index;
                    if (index >= 0 && index < this.getModel().getSize()) {
                        this.setSelectedIndex(index);
                    }
                } else {
                    super.setSelectedIndex(index);
                }
            }
        };
        this.mList.addKeyListener(keyListener);
        this.updateChannelChooser();
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.mList);
        scrollPane.addKeyListener(keyListener);
        scrollPane.getViewport().addKeyListener(keyListener);
        scrollPane.getVerticalScrollBar().addKeyListener(keyListener);
        scrollPane.getHorizontalScrollBar().addKeyListener(keyListener);
        this.add(scrollPane);
        ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mList, this.mList, this);
        new DragAndDropMouseListener<Object>(this.mList, this.mList, this, dnDHandler);
        this.mList.addListSelectionListener(e -> {
            if (!this.disableSync) {
                this.showChannel();
            }
            this.disableSync = false;
        });
        this.mList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ChannelChooserPanel.this.showChannel();
                }
            }
        });
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ChannelChooserPanel.this.showChannel();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ChannelChooserPanel.this.mList.setSelectedIndex(ChannelChooserPanel.this.mList.locationToIndex(e.getPoint()));
                }
                ChannelChooserPanel.this.showPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ChannelChooserPanel.this.showPopupMenu(e);
            }
        });
        this.mList.addMouseWheelListener(e -> {
            int selected = this.mList.getSelectedIndex() + e.getWheelRotation();
            if (selected < 0) {
                selected = 0;
            } else if (selected > this.mList.getModel().getSize()) {
                selected = this.mList.getModel().getSize();
            }
            this.mList.setSelectedIndex(selected);
            this.mList.ensureIndexIsVisible(selected);
        });
    }

    private void showChannel() {
        Channel selectedChannel = (Channel)this.mList.getSelectedValue();
        if (selectedChannel != null) {
            this.mParent.showChannel(selectedChannel);
        }
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            new ChannelContextMenu(e, (Channel)this.mList.getModel().getElementAt(this.mList.locationToIndex(e.getPoint())), this);
        }
    }

    public void updateChannelChooser() {
        this.mList.setCellRenderer(new ChannelListCellRenderer(Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.getBoolean(), Settings.IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST.getBoolean(), false, false, true, true));
        this.mChannelChooserModel.removeAllElements();
        Channel[] channelList = ChannelList.getSubscribedChannels();
        String[] separatorArr = Settings.Channels.SUBSCRIBED_SEPARATORS.getStringArray();
        Channel previousChannel = null;
        int lastSeparatorIndex = 0;
        if (channelList.length > 0) {
            this.mChannelChooserModel.addElement(channelList[0]);
            previousChannel = channelList[0];
        }
        for (int i = 1; i < channelList.length; ++i) {
            for (int j = lastSeparatorIndex; j < separatorArr.length; ++j) {
                String separator = separatorArr[j];
                if (!separator.endsWith(channelList[i].getUniqueId()) || previousChannel == null || !separator.startsWith(previousChannel.getUniqueId())) continue;
                this.mChannelChooserModel.addElement("##SEPARATOR##");
                lastSeparatorIndex = j + 1;
            }
            previousChannel = channelList[i];
            if (channelList[i - 1].getJointChannel() != null && channelList[i - 1].getJointChannel().equals(channelList[i])) continue;
            this.mChannelChooserModel.addElement(channelList[i]);
        }
    }

    @Override
    public void drop(JList<Object> source, JList<Object> target, int rows, boolean move) {
        Channel selected = (Channel)source.getSelectedValue();
        int pos = source.getSelectedIndex();
        UiUtilities.moveSelectedItems(target, rows, true);
        Channel additional = selected.getJointChannel();
        Object[] list = ((DefaultListModel)this.mList.getModel()).toArray();
        ArrayList<Channel> tempList = new ArrayList<Channel>();
        ArrayList<Object> separators = new ArrayList<Object>();
        Object lastChannelId = "";
        for (int i = 0; i < list.length; ++i) {
            if (list[i] instanceof Channel) {
                Channel joint = ((Channel)list[i]).getJointChannel();
                if (additional != null && joint != null && additional.equals(joint)) {
                    joint = null;
                }
                if (i == pos) {
                    if (additional != null) {
                        tempList.add(additional);
                    }
                    tempList.add((Channel)list[i]);
                } else {
                    tempList.add((Channel)list[i]);
                }
                if (joint != null) {
                    tempList.add(joint);
                }
                if (((String)lastChannelId).endsWith("##SEPARATOR##")) {
                    separators.add((String)lastChannelId + ";" + ((Channel)tempList.get(tempList.size() - 1)).getUniqueId());
                    lastChannelId = "";
                }
                lastChannelId = ((Channel)tempList.get(tempList.size() - 1)).getUniqueId();
                continue;
            }
            if (!(list[i] instanceof String) || ((String)lastChannelId).endsWith("##SEPARATOR##")) continue;
            lastChannelId = (String)lastChannelId + ";##SEPARATOR##";
        }
        if (((String)lastChannelId).endsWith("##SEPARATOR##")) {
            separators.add(lastChannelId);
        }
        Channel[] channelArr = tempList.toArray(new Channel[tempList.size()]);
        ChannelList.setSubscribeChannels(channelArr);
        Settings.Channels.SUBSCRIBED.setChannelArray(channelArr);
        Settings.Channels.SUBSCRIBED_SEPARATORS.setStringArray(separators.toArray(new String[separators.size()]));
        if (!Settings.Tray.Channels.SPECIAL_USE.getBoolean()) {
            Channel[] tempArr = new Channel[channelArr.length > 10 ? 10 : channelArr.length];
            System.arraycopy(channelArr, 0, tempArr, 0, tempArr.length);
            Settings.Tray.Channels.SPECIAL.setChannelArray(tempArr);
        }
        ChannelList.reload();
        DefaultProgramTableModel model = MainFrame.getInstance().getProgramTableModel();
        model.setChannels(ChannelList.getSubscribedChannels());
        MainFrame.getInstance().updateChannellist();
        this.setChannelFilter(this.mChannelFilter);
    }

    public void selectChannel(Channel channel) {
        this.disableSync = true;
        this.mList.setSelectedValue(channel, true);
        this.mList.ensureIndexIsVisible(this.mList.getSelectedIndex());
        this.disableSync = false;
    }

    public void setChannelFilter(ChannelFilter channelFilter) {
        this.mChannelFilter = channelFilter;
        Channel[] channels = null;
        if (channelFilter != null) {
            channels = channelFilter.getChannels();
        }
        ((ChannelListCellRenderer)this.mList.getCellRenderer()).setChannels(channels);
    }
}

