/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.actions;

import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.actions.TVBrowserActions;
import util.i18n.Localizer;

public abstract class TVBrowserAction
extends AbstractAction {
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(TVBrowserAction.class);
    private ImageIcon mSmallIcon;
    private KeyStroke mAccelerator;
    private String mKey;

    public TVBrowserAction(String key, ImageIcon smallIcon, ImageIcon largeIcon, int keyCode, int keyMask, int toolbarActionType) {
        this.mKey = key;
        this.mSmallIcon = smallIcon;
        this.mAccelerator = keyCode != 0 ? KeyStroke.getKeyStroke(keyCode, keyMask) : null;
        this.putValue("Name", this.getToolbarText());
        this.putValue("SmallIcon", smallIcon);
        this.putValue("BigIcon", largeIcon);
        this.putValue("ShortDescription", this.getToolbarTip());
        this.putValue("ActionType", toolbarActionType);
        this.putValue("ActionId", "#" + this.mKey);
        TVBrowserActions.register(this);
    }

    private String getToolbarTip() {
        String text = mLocalizer.msg(this.getKey() + ".toolbar.tip", "", false);
        if (text.indexOf(91) == 0) {
            text = this.getMenuHelpText();
        }
        return text;
    }

    public TVBrowserAction(String key, int keyCode, int keyMask) {
        this(key, null, null, keyCode, keyMask, -1);
    }

    public String getToolbarText() {
        String text = mLocalizer.msg(this.getKey() + ".toolbar", "Toolbar: " + this.mKey, false);
        if (text.indexOf(91) == 0) {
            text = this.getMenuText().replace("&", "");
            while (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    public Icon getIcon() {
        return this.mSmallIcon;
    }

    public String getMenuText() {
        return mLocalizer.msg(this.getKey() + ".menu", "Menu: " + this.mKey);
    }

    public String getMenuHelpText() {
        return mLocalizer.msg(this.getKey() + ".menu.info", "");
    }

    public KeyStroke getAccelerator() {
        return this.mAccelerator;
    }

    public String getToolbarIdentifier() {
        return (String)this.getValue("ActionId");
    }

    protected void showPopupMenu() {
        MainFrame.getInstance().getToolbar().showPopupMenu(this);
    }

    protected String getKey() {
        return this.mKey;
    }

    public boolean useEllipsis() {
        return false;
    }

    public boolean isSelected() {
        return false;
    }
}

