/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Channel;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.PluginStateListener;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.CompactLayout;
import tvbrowser.ui.programtable.CompactTimeBlockLayout;
import tvbrowser.ui.programtable.OptimizedCompactTimeBlockLayout;
import tvbrowser.ui.programtable.ProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import tvbrowser.ui.programtable.ProgramTableModelListener;
import tvbrowser.ui.programtable.RealCompactLayout;
import tvbrowser.ui.programtable.RealTimeSynchronousLayout;
import tvbrowser.ui.programtable.TimeBlockLayout;
import tvbrowser.ui.programtable.TimeSynchronousLayout;
import tvbrowser.ui.programtable.background.BackgroundPainter;
import tvbrowser.ui.programtable.background.OneImageBackPainter;
import tvbrowser.ui.programtable.background.SingleColorBackPainter;
import tvbrowser.ui.programtable.background.TimeBlockBackPainter;
import tvbrowser.ui.programtable.background.TimeOfDayBackPainter;
import tvbrowser.ui.programtable.background.UiColorBackPainter;
import tvbrowser.ui.programtable.background.UiTimeBlockBackPainter;
import util.i18n.Localizer;
import util.programmouseevent.AutoScrollerAndClickKeyHandler;
import util.programmouseevent.ProgramMouseEventHandler;
import util.settings.ProgramPanelSettings;
import util.ui.ProgramPanel;
import util.ui.TransferProgram;

public class ProgramTable
extends JPanel
implements ProgramTableModelListener,
DragGestureListener,
DragSourceListener,
PluginStateListener,
Scrollable,
AutoScrollerAndClickKeyHandler.ProgramAutoScrollListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramTable.class);
    private int mColumnWidth;
    private int mHeight;
    private int mCurrentCol;
    private int mCurrentRow;
    private int mCurrentY;
    private ProgramTableLayout mLayout;
    private ProgramTableModel mModel;
    private BackgroundPainter mBackgroundPainter;
    private Point mMouse;
    private JPopupMenu mPopupMenu;
    private Runnable mCallback;
    private Point mMouseMatrix = new Point(-1, -1);
    private AutoScrollerAndClickKeyHandler mAutoScroller;
    private ArrayList<ProgramPanel> mTimeMarkings;

    public ProgramTable(ProgramTableModel model, KeyListener keyListener) {
        this.setToolTipText("");
        this.setProgramTableLayout(null);
        this.addKeyListener(keyListener);
        this.mTimeMarkings = new ArrayList(0);
        this.mCurrentCol = -1;
        this.mCurrentRow = -1;
        this.mCurrentY = 0;
        this.setColumnWidth(Settings.ProgramTable.COLUMN_WIDTH.getInt());
        this.setModel(model);
        this.updateBackground();
        this.setBackground(Color.white);
        UIManager.put("programPanel.background", Color.white);
        this.setOpaque(true);
        this.mAutoScroller = new AutoScrollerAndClickKeyHandler(this, this);
        new DragSource().createDefaultDragGestureRecognizer(this, 2, this);
    }

    protected void setModel(ProgramTableModel model) {
        this.mModel = model;
        this.mModel.addProgramTableModelListener(this);
        this.updateLayout();
    }

    public ProgramTableModel getModel() {
        return this.mModel;
    }

    public ProgramTableLayout getProgramTableLayout() {
        return this.mLayout;
    }

    public void setProgramTableLayout(ProgramTableLayout layout) {
        if (layout == null) {
            layout = Settings.ProgramTable.LAYOUT.getString().equals("compact") ? new CompactLayout() : (Settings.ProgramTable.LAYOUT.getString().equals("realCompact") ? new RealCompactLayout() : (Settings.ProgramTable.LAYOUT.getString().equals("timeSynchronous") ? new TimeSynchronousLayout() : (Settings.ProgramTable.LAYOUT.getString().equals("timeBlock") ? new TimeBlockLayout() : (Settings.ProgramTable.LAYOUT.getString().equals("compactTimeBlock") ? new CompactTimeBlockLayout() : (Settings.ProgramTable.LAYOUT.getString().equals("optimizedCompactTimeBlock") ? new OptimizedCompactTimeBlockLayout() : new RealTimeSynchronousLayout())))));
        }
        this.mLayout = layout;
        if (this.mModel != null) {
            this.updateLayout();
            this.revalidate();
        }
    }

    public void setColumnWidth(int columnWidth) {
        this.mColumnWidth = columnWidth;
    }

    public int getColumnWidth() {
        return this.mColumnWidth;
    }

    public void updateBackground() {
        BackgroundPainter oldPainter = this.mBackgroundPainter;
        String background = Settings.ProgramTable.STYLE_BACKGROUND.getString();
        if (oldPainter instanceof SingleColorBackPainter && !background.equals("singleColor")) {
            this.resetBackground();
        }
        if (background.equals("timeOfDay")) {
            this.mBackgroundPainter = new TimeOfDayBackPainter();
        } else if (background.equals("singleColor")) {
            this.mBackgroundPainter = new SingleColorBackPainter();
        } else if (background.equals("oneImage")) {
            this.mBackgroundPainter = new OneImageBackPainter();
        } else if (background.equals("uiColor")) {
            this.mBackgroundPainter = new UiColorBackPainter();
        } else if (background.equals("uiTimeBlock")) {
            try {
                this.mBackgroundPainter = new UiTimeBlockBackPainter();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            this.mBackgroundPainter = new TimeBlockBackPainter();
        }
        this.mBackgroundPainter.layoutChanged(this.mLayout, this.mModel);
        this.firePropertyChange("backgroundpainter", oldPainter, this.mBackgroundPainter);
        this.repaint();
    }

    private void resetBackground() {
        Color temp = Settings.ProgramTable.COLOR_BACKGROUND_SINGLE.getColor();
        Settings.ProgramTable.COLOR_BACKGROUND_SINGLE.setColor(Color.white);
        this.repaint();
        Settings.ProgramTable.COLOR_BACKGROUND_SINGLE.setColor(temp);
    }

    public BackgroundPainter getBackgroundPainter() {
        return this.mBackgroundPainter;
    }

    @Override
    public void paintComponent(Graphics grp) {
        int columnCount;
        int maxCol;
        Graphics2D g2d;
        if (Settings.Fonts.ANTIALIASING_ENABLED.getBoolean() && null != (g2d = (Graphics2D)grp)) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle clipBounds = grp.getClipBounds();
        int minCol = clipBounds.x / this.mColumnWidth;
        if (minCol < 0) {
            minCol = 0;
        }
        if ((maxCol = (clipBounds.x + clipBounds.width) / this.mColumnWidth) >= (columnCount = this.mModel.getColumnCount())) {
            maxCol = columnCount - 1;
        }
        super.paintComponent(grp);
        int tableHeight = Math.max(this.mHeight, clipBounds.y + clipBounds.height);
        this.mBackgroundPainter.paintBackground(grp, this.mColumnWidth, tableHeight, minCol, maxCol, clipBounds, this.mLayout, this.mModel);
        boolean mouseOver = false;
        int x = minCol * this.mColumnWidth;
        for (int col = minCol; col <= maxCol; ++col) {
            int y = this.mLayout.getColumnStart(col);
            int rowCount = this.mModel.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = this.mModel.getProgramPanel(col, row);
                if (panel == null) continue;
                int cellHeight = panel.getHeight();
                if (y + cellHeight > clipBounds.y && y < clipBounds.y + clipBounds.height) {
                    Rectangle rec = new Rectangle(x, y, this.mColumnWidth, cellHeight);
                    if (Settings.ProgramTable.MOUSE_OVER.getBoolean()) {
                        mouseOver = this.mMouse != null && rec.contains(this.mMouse);
                    }
                    Shape oldClip = grp.getClip();
                    rec = rec.intersection(oldClip.getBounds());
                    if (rec.width > 0 || rec.height > 0) {
                        grp.setClip(rec);
                        grp.translate(x, y);
                        panel.setSize(this.mColumnWidth, cellHeight);
                        panel.paint(mouseOver, row == this.mCurrentRow && col == this.mCurrentCol, grp);
                        grp.translate(-x, -y);
                        grp.setClip(oldClip);
                    }
                }
                y += cellHeight;
            }
            x += this.mColumnWidth;
        }
        grp.setClip(clipBounds);
        if (!Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("uiColor") && !Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("uiTimeBlock")) {
            grp.setColor(Settings.ProgramPanel.COLOR_FOREGROUND.getColor());
        } else {
            grp.setColor(UIManager.getColor("List.foreground"));
        }
        Channel[] channelArr = this.mModel.getShownChannels();
        FontMetrics metric = grp.getFontMetrics();
        for (Channel channel : channelArr) {
            String msg = channel.getCopyrightNotice();
            while (metric.stringWidth(msg) > this.mColumnWidth) {
                Font font = grp.getFont();
                grp.setFont(font.deriveFont((float)(font.getSize() - 1)));
                metric = grp.getFontMetrics();
            }
        }
        for (int i = 0; i < channelArr.length; ++i) {
            String msg = channelArr[i].getCopyrightNotice();
            grp.drawString(msg, i * this.mColumnWidth + 3, this.getHeight() - 5);
        }
        if (clipBounds.width - x > 0) {
            grp.setColor(Color.WHITE);
            grp.fillRect(x, 0, clipBounds.width - x, clipBounds.height);
        }
        if (this.mCallback != null) {
            this.runCallback();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.mModel.getColumnCount() * this.mColumnWidth, this.mHeight);
    }

    public void markTime(int time) {
        this.clearTimeMarkings();
        if (Settings.ProgramTable.SCROLL_TO_TIME_MARKING.getBoolean()) {
            for (int column = 0; column < this.mModel.getColumnCount(); ++column) {
                for (int row = 0; row < this.mModel.getRowCount(column); ++row) {
                    ProgramPanel panel = this.mModel.getProgramPanel(column, row);
                    if (panel.getProgram().getStartTime() > time || panel.getProgram().getStartTime() + panel.getProgram().getLength() <= time) continue;
                    panel.setMarkTime(time);
                    panel.getProgram().validateMarking();
                    this.mTimeMarkings.add(panel);
                }
            }
        }
    }

    public void clearTimeMarkings() {
        for (ProgramPanel panel : this.mTimeMarkings) {
            panel.setMarkTime(-1);
            panel.getProgram().validateMarking();
        }
        this.mTimeMarkings.clear();
    }

    @Override
    public Program getProgramAt(int x, int y) {
        int col = x / this.mColumnWidth;
        if (col < 0 || col >= this.mModel.getColumnCount()) {
            return null;
        }
        int currY = this.mLayout.getColumnStart(col);
        if (y < currY) {
            return null;
        }
        int rowCount = this.mModel.getRowCount(col);
        for (int row = 0; row < rowCount; ++row) {
            ProgramPanel panel = this.mModel.getProgramPanel(col, row);
            if (y >= (currY += panel.getHeight())) continue;
            return panel.getProgram();
        }
        return null;
    }

    public void forceRepaintAll() {
        int columnCount = this.mModel.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            int rowCount = this.mModel.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = this.mModel.getProgramPanel(col, row);
                if (!Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("uiColor") && !Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("uiTimeBlock")) {
                    panel.setTextColor(Settings.ProgramPanel.COLOR_FOREGROUND.getColor());
                } else {
                    panel.setTextColor(UIManager.getColor("List.foreground"));
                }
                panel.setProgramPanelSettings(new ProgramPanelSettings(Settings.Pictures.TYPE.getInt(), Settings.Pictures.TIME_START.getInt(), Settings.Pictures.TIME_END.getInt(), false, Settings.Pictures.DESCRIPTION_SHOW.getBoolean(), Settings.Pictures.DURATION.getInt(), Settings.Pictures.PLUGIN_IDS.getStringArray(), 1, false, Settings.Pictures.BORDER_SHOW.getBoolean(), false));
                panel.forceRepaint();
            }
        }
        this.updateLayout();
    }

    public void updateLayout() {
        this.mLayout.updateLayout(this.mModel);
        this.mHeight = 0;
        int columnCount = this.mModel.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            int colHeight = this.mLayout.getColumnStart(col);
            int rowCount = this.mModel.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = this.mModel.getProgramPanel(col, row);
                colHeight += panel.getHeight();
            }
            if (colHeight <= this.mHeight) continue;
            this.mHeight = colHeight;
        }
        this.mHeight += 20;
        if (this.mBackgroundPainter != null) {
            this.mBackgroundPainter.layoutChanged(this.mLayout, this.mModel);
        }
    }

    private JPopupMenu createPluginContextMenu(Program program) {
        return PluginProxyManager.createPluginContextMenu(program);
    }

    @Override
    public void handleMouseDragged(MouseEvent evt) {
    }

    @Override
    public void handleMouseMoved(MouseEvent evt) {
        if (Settings.ProgramTable.MOUSE_OVER.getBoolean() && (this.mPopupMenu == null || !this.mPopupMenu.isVisible())) {
            this.mMouse = evt.getPoint();
            Point cellIndex = this.getMatrix(this.mMouse.x, this.mMouse.y);
            this.repaintCell(this.mMouseMatrix);
            if (cellIndex.x >= 0 && cellIndex.y >= 0 && (cellIndex.x != this.mMouseMatrix.x || cellIndex.y != this.mMouseMatrix.y)) {
                this.mMouseMatrix = cellIndex;
                this.repaintCell(this.mMouseMatrix);
            }
        }
    }

    private void repaintCell(Point cellIndex) {
        SwingUtilities.invokeLater(() -> {
            Rectangle cellRect;
            if ((cellIndex.x >= 0 || cellIndex.y >= 0) && cellIndex.x < this.mModel.getColumnCount() && (cellRect = this.getCellRect(cellIndex.x, cellIndex.y)) != null) {
                this.repaint(cellRect);
            }
        });
    }

    private void repaintCurrentCell() {
        this.repaintCell(new Point(this.mCurrentCol, this.mCurrentRow));
    }

    @Override
    public void handleMouseExited(MouseEvent evt) {
        if (Settings.ProgramTable.MOUSE_OVER.getBoolean()) {
            JViewport viewport = (JViewport)this.getParent();
            if (!(ProgramInfo.getInstance().dialogWasClosedRecently() || this.mPopupMenu != null && this.mPopupMenu.isVisible() || viewport.getViewRect().contains(evt.getPoint()))) {
                this.repaintCell(this.mMouseMatrix);
                this.mMouse = null;
                this.mMouseMatrix = new Point(-1, -1);
            }
        }
    }

    protected int getTimeY(int minutesAfterMidnight) {
        int totalTimeY = 0;
        int parts = 0;
        int columnCount = this.mModel.getColumnCount();
        int[] y = new int[columnCount];
        for (int col = 0; col < columnCount; ++col) {
            y[col] = this.getTimeYOfColumn(col, minutesAfterMidnight);
            if (y[col] <= 0) continue;
            totalTimeY += y[col];
            ++parts;
        }
        if (parts == 0) {
            return 0;
        }
        return totalTimeY / parts;
    }

    private int getTimeYOfColumn(int col, int minutesAfterMidnight) {
        int timeY = this.mLayout.getColumnStart(col);
        Date mainDate = this.mModel.getDate();
        int lastPanelHeight = 0;
        int rowCount = this.mModel.getRowCount(col);
        for (int row = 0; row < rowCount; ++row) {
            ProgramPanel panel = this.mModel.getProgramPanel(col, row);
            Program program = panel.getProgram();
            int startTime = program.getStartTime();
            if ((startTime += program.getDate().getNumberOfDaysSince(mainDate) * 24 * 60) == minutesAfterMidnight) {
                return timeY;
            }
            int progLength = program.getLength();
            int panelHeight = panel.getHeight();
            if (progLength > 0 && startTime < minutesAfterMidnight && startTime + progLength > minutesAfterMidnight) {
                if (panelHeight > 800) {
                    return 0;
                }
                return timeY + panelHeight * (minutesAfterMidnight - startTime) / progLength;
            }
            if (startTime > minutesAfterMidnight) {
                if (row == 0) {
                    return 0;
                }
                if (lastPanelHeight > 800) {
                    return 0;
                }
                return timeY;
            }
            timeY += panelHeight;
            lastPanelHeight = panelHeight;
        }
        return -1;
    }

    private Rectangle getCellRect(int cellCol, int cellRow) {
        int x = cellCol * this.mColumnWidth;
        int width = this.mColumnWidth;
        int y = this.mLayout.getColumnStart(cellCol);
        int rowCount = this.mModel.getRowCount(cellCol);
        for (int row = 0; row < rowCount; ++row) {
            ProgramPanel panel = this.mModel.getProgramPanel(cellCol, row);
            int height = panel.getHeight();
            if (row == cellRow) {
                return new Rectangle(x, y, width, height);
            }
            y += height;
        }
        return null;
    }

    public void runCallback() {
        SwingUtilities.invokeLater(() -> {
            if (this.mCallback != null) {
                this.mCallback.run();
            }
            this.mCallback = null;
        });
    }

    @Override
    public void tableDataChanged(Runnable callback) {
        this.mCallback = callback;
        this.updateLayout();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void tableCellUpdated(int col, int row) {
        Rectangle cellRect = this.getCellRect(col, row);
        if (cellRect != null) {
            this.repaint(cellRect);
        }
    }

    public void closePopupMenuIfVisible() {
        if (this.mPopupMenu != null && this.mPopupMenu.isVisible()) {
            this.mPopupMenu.setVisible(false);
        }
    }

    public void togglePopupFromKeyboard() {
        if (this.mCurrentCol == -1 || this.mCurrentRow == -1) {
            return;
        }
        if (this.mPopupMenu != null && this.mPopupMenu.isVisible()) {
            this.mPopupMenu.setVisible(false);
        } else {
            Program program = this.mModel.getProgramPanel(this.mCurrentCol, this.mCurrentRow).getProgram();
            Rectangle rect = this.getCellRect(this.mCurrentCol, this.mCurrentRow);
            this.scrollRectToVisible(rect);
            this.mPopupMenu = this.createPluginContextMenu(program);
            this.mPopupMenu.show(this, rect.x + rect.width / 3, rect.y + rect.height * 3 / 4);
        }
    }

    public void handleKeyboardAction(ContextMenuManager.ContextMenuAction action) {
        if (this.mCurrentCol == -1 || this.mCurrentRow == -1) {
            return;
        }
        Program program = this.mModel.getProgramPanel(this.mCurrentCol, this.mCurrentRow).getProgram();
        ProgramMouseEventHandler.handleAction(program, action.getContextMenuIf().getContextMenuActions(program), action.getContextMenuActionId());
    }

    public void right() {
        this.repaintCurrentCell();
        int cols = this.mModel.getColumnCount();
        int previousCol = this.mCurrentCol;
        if (cols == 0) {
            return;
        }
        this.mCurrentCol = this.mCurrentCol != -1 ? (this.mCurrentCol < cols - 1 ? ++this.mCurrentCol : 0) : 0;
        boolean found = false;
        boolean find = true;
        int colCount = 0;
        do {
            int rows = this.mModel.getRowCount(this.mCurrentCol);
            if (previousCol != -1 && rows > 0) {
                Rectangle rectPrev = this.getCellRect(previousCol, this.mCurrentRow);
                Rectangle rectCur = this.getCellRect(this.mCurrentCol, 1);
                if (rectCur != null && rectPrev != null) {
                    ProgramPanel panel;
                    Point cellIndex = this.getMatrix(rectCur.x, this.mCurrentY);
                    if (cellIndex.y != -1 && (panel = this.mModel.getProgramPanel(cellIndex.x, cellIndex.y)) != null && !panel.getProgram().isExpired()) {
                        find = false;
                        found = true;
                        this.mCurrentRow = cellIndex.y;
                    }
                }
            }
            if (find) {
                for (int i = 0; i < rows; ++i) {
                    ProgramPanel panel = this.mModel.getProgramPanel(this.mCurrentCol, i);
                    if (!panel.getProgram().isOnAir() && panel.getProgram().isExpired()) continue;
                    found = true;
                    this.mCurrentRow = i;
                    break;
                }
            }
            if (!found) {
                ++colCount;
                this.mCurrentCol = this.mCurrentCol < cols - 1 ? ++this.mCurrentCol : 0;
            }
            if (colCount < cols) continue;
            this.deSelectItem();
            return;
        } while (!found);
        this.repaintCurrentCell();
        this.scrollToSelection();
    }

    public void up() {
        this.repaintCurrentCell();
        if (this.mCurrentCol == -1) {
            this.right();
        } else {
            int rows = this.mModel.getRowCount(this.mCurrentCol);
            ProgramPanel panel = this.mModel.getProgramPanel(this.mCurrentCol, this.mCurrentRow);
            ProgramPanel previous = null;
            if (this.mCurrentRow > 0) {
                previous = this.mModel.getProgramPanel(this.mCurrentCol, this.mCurrentRow - 1);
            }
            this.mCurrentRow = panel.getProgram().isOnAir() || previous != null && previous.getProgram().isExpired() ? rows - 1 : --this.mCurrentRow;
            if (this.mCurrentRow < 0) {
                this.mCurrentRow = rows - 1;
            }
            this.repaintCurrentCell();
            this.mCurrentY = this.getCellRect((int)this.mCurrentCol, (int)this.mCurrentRow).y;
            this.scrollToSelection();
        }
    }

    public void down() {
        this.repaintCurrentCell();
        if (this.mCurrentCol == -1) {
            this.right();
        } else {
            int rows = this.mModel.getRowCount(this.mCurrentCol);
            if (this.mCurrentRow >= rows - 1) {
                for (int i = 0; i < rows; ++i) {
                    ProgramPanel panel = this.mModel.getProgramPanel(this.mCurrentCol, i);
                    if (!panel.getProgram().isOnAir() && panel.getProgram().isExpired()) continue;
                    this.mCurrentRow = i;
                    break;
                }
            } else {
                ++this.mCurrentRow;
            }
            this.repaintCurrentCell();
            this.mCurrentY = this.getCellRect((int)this.mCurrentCol, (int)this.mCurrentRow).y;
            this.scrollToSelection();
        }
    }

    public void left() {
        this.repaintCurrentCell();
        if (this.mCurrentCol == -1) {
            this.right();
        } else {
            int previousCol = this.mCurrentCol;
            boolean found = false;
            boolean find = true;
            block0: do {
                this.mCurrentCol = this.mCurrentCol == 0 ? this.mModel.getColumnCount() - 1 : --this.mCurrentCol;
                int rows = this.mModel.getRowCount(this.mCurrentCol);
                if (previousCol != -1 && rows > 0) {
                    Rectangle rectPrev = this.getCellRect(previousCol, this.mCurrentRow);
                    Rectangle rectCur = this.getCellRect(this.mCurrentCol, 1);
                    if (rectCur != null && rectPrev != null) {
                        ProgramPanel panel;
                        Point cellIndex = this.getMatrix(rectCur.x, this.mCurrentY);
                        if (cellIndex.y != -1 && (panel = this.mModel.getProgramPanel(cellIndex.x, cellIndex.y)) != null && !panel.getProgram().isExpired()) {
                            find = false;
                            found = true;
                            this.mCurrentRow = cellIndex.y;
                        }
                    }
                }
                if (!find) continue;
                for (int i = 0; i < rows; ++i) {
                    ProgramPanel panel = this.mModel.getProgramPanel(this.mCurrentCol, i);
                    if (!panel.getProgram().isOnAir() && panel.getProgram().isExpired()) continue;
                    found = true;
                    this.mCurrentRow = i;
                    continue block0;
                }
            } while (!found);
            this.repaintCurrentCell();
            this.scrollToSelection();
        }
    }

    private void scrollToSelection() {
        int height = this.getVisibleRect().height;
        int width = this.getVisibleRect().width;
        Rectangle cell = this.getCellRect(this.mCurrentCol, this.mCurrentRow);
        if (cell.height > height) {
            cell.setSize(cell.width, height);
        }
        if (cell.width > width) {
            cell.setSize(width, cell.height);
        }
        this.scrollRectToVisible(cell);
    }

    @Override
    public void deSelectItem() {
        this.deSelectItem(false);
    }

    public Program deSelectItem(boolean getProgram) {
        Program selected = null;
        if (getProgram && this.mCurrentRow >= 0 && this.mCurrentCol >= 0) {
            selected = this.mModel.getProgramPanel(this.mCurrentCol, this.mCurrentRow).getProgram();
        }
        this.repaintCurrentCell();
        this.mCurrentRow = -1;
        this.mCurrentCol = -1;
        return selected;
    }

    private Point getMatrix(int pointX, int pointY) {
        int col = pointX / this.mColumnWidth;
        if (col < 0 || col >= this.mModel.getColumnCount()) {
            return new Point(-1, -1);
        }
        int currY = this.mLayout.getColumnStart(col);
        if (pointY < currY) {
            return new Point(-1, -1);
        }
        int rowCount = this.mModel.getRowCount(col);
        for (int row = 0; row < rowCount; ++row) {
            ProgramPanel panel = this.mModel.getProgramPanel(col, row);
            if (pointY >= (currY += panel.getHeight())) continue;
            return new Point(col, row);
        }
        return new Point(-1, -1);
    }

    @Override
    public void selectItemAt(int pointX, int pointY) {
        this.repaintCurrentCell();
        Point cellIndex = this.getMatrix(pointX, pointY);
        this.mCurrentCol = cellIndex.x;
        this.mCurrentRow = cellIndex.y;
        this.repaintCurrentCell();
    }

    @Override
    public boolean isSelectedItemAt(int x, int y) {
        Point cellIndex = this.getMatrix(x, y);
        return this.mCurrentRow == cellIndex.y && this.mCurrentCol == cellIndex.x;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        if (!evt.getTriggerEvent().isShiftDown()) {
            return;
        }
        this.mMouse = evt.getDragOrigin();
        Program program = this.getProgramAt(this.mMouse.x, this.mMouse.y);
        if (program != null) {
            if (!this.isSelectedItemAt(this.mMouse.x, this.mMouse.y)) {
                this.selectItemAt(this.mMouse.x, this.mMouse.y);
            }
            evt.startDrag(null, new TransferProgram(program), this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.deSelectItem();
    }

    public void selectProgram(Program program) {
        int columnCount = this.mModel.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            int rowCount = this.mModel.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = this.mModel.getProgramPanel(col, row);
                if (!panel.getProgram().equals(program)) continue;
                this.mCurrentCol = col;
                this.mCurrentRow = row;
                this.repaintCurrentCell();
                return;
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        PluginProxyManager.getInstance().addPluginStateListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        PluginProxyManager.getInstance().removePluginStateListener(this);
    }

    @Override
    public void pluginActivated(PluginProxy plugin) {
        if (plugin.getProgramTableIcons(Plugin.getPluginManager().getExampleProgram()) != null) {
            this.updatePrograms();
        }
    }

    @Override
    public void pluginDeactivated(PluginProxy plugin) {
        SwingUtilities.invokeLater(() -> this.updatePrograms());
    }

    private void updatePrograms() {
        ProgramTableModel model = this.getModel();
        int cols = model.getColumnCount();
        for (int c = 0; c < cols; ++c) {
            int rows = model.getRowCount(c);
            for (int r = 0; r < rows; ++r) {
                ProgramPanel programPanel = model.getProgramPanel(c, r);
                programPanel.programHasChanged();
            }
        }
        this.repaint();
    }

    @Override
    public void pluginLoaded(PluginProxy plugin) {
    }

    @Override
    public void pluginUnloaded(PluginProxy plugin) {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        int fullColumns = (int)((visibleRect.getWidth() + 8.0) / (double)this.mColumnWidth);
        if (fullColumns < 1) {
            fullColumns = 1;
        }
        return fullColumns * this.mColumnWidth;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return this.mColumnWidth;
        }
        return 50;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point mousePoint = event.getPoint();
        Point panelIndex = this.getMatrix(mousePoint.x, mousePoint.y);
        if (panelIndex.x != -1) {
            ProgramPanel nextPanel;
            boolean showTime;
            ProgramPanel panel = this.mModel.getProgramPanel(panelIndex.x, panelIndex.y);
            int currY = this.mLayout.getColumnStart(panelIndex.x);
            for (int row = 0; row < panelIndex.y; ++row) {
                currY += this.mModel.getProgramPanel(panelIndex.x, row).getHeight();
            }
            int panelX = mousePoint.x - panelIndex.x * this.mColumnWidth;
            int panelY = mousePoint.y - currY;
            StringBuilder buffer = new StringBuilder();
            String tooltip = panel.getToolTipText(panelX, panelY);
            if (tooltip != null && tooltip.length() > 0) {
                buffer.append(tooltip);
            }
            JViewport viewport = MainFrame.getInstance().getProgramTableScrollPane().getViewport();
            Point viewPos = viewport.getViewPosition();
            Dimension viewSize = viewport.getSize();
            Program program = panel.getProgram();
            if ((currY < viewPos.y || panelIndex.x * this.mColumnWidth + panel.getTitleX() < viewPos.x || (panelIndex.x + 1) * this.mColumnWidth - 1 > viewPos.x + viewSize.width) && buffer.indexOf(program.getTitle()) < 0) {
                this.appendTooltip(buffer, program.getTitle());
            }
            boolean bl = showTime = (nextPanel = this.mModel.getProgramPanel(panelIndex.x, panelIndex.y + 1)) == null && program.getLength() > 0;
            if (nextPanel != null) {
                int length = program.getLength();
                int nextStartTime = nextPanel.getProgram().getStartTime();
                if (nextStartTime < program.getStartTime()) {
                    nextStartTime += 1440;
                }
                if (length > 0 && program.getStartTime() + length + 1 < nextStartTime) {
                    showTime = true;
                }
            }
            if (showTime) {
                this.appendTooltip(buffer, mLocalizer.msg("until", "until {0}", program.getEndTimeString()));
            }
            if (buffer.length() > 0) {
                return buffer.toString();
            }
        }
        return null;
    }

    private void appendTooltip(StringBuilder buffer, String text) {
        if (buffer.length() > 0) {
            buffer.append(" - ");
        }
        buffer.append(text);
    }

    public boolean isSelected() {
        return this.mCurrentRow != -1 && this.mCurrentCol != -1;
    }

    @Override
    public Program getProgramForMouseEvent(MouseEvent e) {
        if (this.mAutoScroller.isScrolling()) {
            return null;
        }
        this.mAutoScroller.stopClickIfNecessary();
        this.mMouse = e.getPoint();
        this.repaint();
        Program program = this.getProgramAt(e.getX(), e.getY());
        if (program != null) {
            this.deSelectItem();
        }
        return program;
    }

    @Override
    public void mouseEventActionFinished() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void showContextMenu(MouseEvent e) {
        this.mAutoScroller.stopAutoScroll(true);
        this.mMouse = e.getPoint();
        this.repaint();
        Program program = this.getProgramAt(e.getX(), e.getY());
        if (program != null) {
            this.deSelectItem();
            this.mPopupMenu = this.createPluginContextMenu(program);
            this.mPopupMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void handleMousePressed(MouseEvent evt) {
    }

    @Override
    public void handleMouseReleased(MouseEvent evt) {
    }

    public boolean stopAutoScroll() {
        return this.mAutoScroller.stopAutoScroll(true);
    }

    @Override
    public boolean isAutoScrollingEnabled() {
        return Settings.ProgramTable.MOUSE_AUTO_SCROLL.getBoolean();
    }

    @Override
    public boolean isClickAndContextMenuHandlingEnabled() {
        return true;
    }
}

