/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.PluginCenterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ProgramTableScrollPane;
import util.i18n.Localizer;

public class ProgramTableScrollPaneWrapper
extends PluginCenterPanel {
    public static final int INFO_EMPTY_FILTER_RESULT = 0;
    public static final int INFO_NO_CHANNELS_SUBSCRIBED = 1;
    public static final int INFO_EMPTY_CHANNEL_GROUP = 2;
    public static final int INFO_NO_DATA = 3;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramTableScrollPaneWrapper.class);
    private ProgramTableScrollPane mProgramTableScrollPane;
    private JPanel mMainPanel;
    private InfoPanel mInfoPanel = null;

    public ProgramTableScrollPaneWrapper(ProgramTableScrollPane scrollPane) {
        this.mProgramTableScrollPane = scrollPane;
        this.mMainPanel = new JPanel(new BorderLayout());
        this.mMainPanel.setOpaque(false);
        this.mMainPanel.add((Component)this.mProgramTableScrollPane, "Center");
    }

    @Override
    public String getName() {
        return mLocalizer.msg("name", "Program table");
    }

    @Override
    public JPanel getPanel() {
        return this.mMainPanel;
    }

    public void showInfoPanel(int type, String name) {
        this.mMainPanel.removeAll();
        this.mInfoPanel = new InfoPanel(type, name);
        this.mMainPanel.add((Component)this.mInfoPanel, "Center");
        this.mMainPanel.repaint();
    }

    public void removeInfoPanel(int type) {
        if (this.mInfoPanel != null && this.mInfoPanel.isType(type)) {
            this.mMainPanel.removeAll();
            this.mInfoPanel = null;
            this.mMainPanel.add((Component)this.mProgramTableScrollPane, "Center");
            this.mMainPanel.repaint();
        }
    }

    public boolean hasInfoPanel(int type) {
        return this.mInfoPanel != null && this.mInfoPanel.isType(type);
    }

    private static final class InfoPanel
    extends JPanel {
        private int mType;

        public InfoPanel(int type, String name) {
            this.mType = type;
            this.setLayout((LayoutManager)new FormLayout("5dlu:grow,default,5dlu:grow", "fill:5dlu:grow,default,5dlu,default,fill:5dlu:grow"));
            String infoText = null;
            String buttonText = null;
            switch (type) {
                case 0: {
                    infoText = mLocalizer.msg("infoEmptyFilter", "The selected filter '{0}' doesn't accepts any programs.", name);
                    buttonText = mLocalizer.msg("buttonEmptyFilter", "Deactivate filter to show all programs");
                    break;
                }
                case 1: {
                    infoText = mLocalizer.msg("infoNoChannels", "No channels are subscribed.");
                    buttonText = mLocalizer.msg("buttonNoChannels", "Select channels now");
                    break;
                }
                case 2: {
                    infoText = mLocalizer.msg("infoEmptyChannelGroup", "The used channel group '{0}' seems to be empty.", name);
                    buttonText = mLocalizer.msg("buttonEmptyChanenlGroup", "Deactivate channel group");
                    break;
                }
                case 3: {
                    infoText = mLocalizer.msg("infoNoDate", "No data is available.");
                    buttonText = mLocalizer.msg("buttonLoadData", "Update data");
                }
            }
            JButton action = new JButton(buttonText);
            action.addActionListener(e -> {
                switch (type) {
                    case 0: {
                        MainFrame.getInstance().setProgramFilter(FilterManagerImpl.getInstance().getAllFilter());
                        break;
                    }
                    case 1: {
                        PluginManagerImpl.getInstance().showSettings("#channels");
                        break;
                    }
                    case 2: {
                        MainFrame.getInstance().setChannelFilter(null);
                        break;
                    }
                    case 3: {
                        MainFrame.getInstance().updateTvData();
                    }
                }
            });
            this.add((Component)new JLabel(infoText), CC.xy((int)2, (int)2));
            this.add((Component)action, CC.xy((int)2, (int)4));
        }

        boolean isType(int type) {
            return this.mType == type;
        }
    }
}

