/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Program;
import tvbrowser.ui.programtable.AbstractProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import util.ui.ProgramPanel;

public class RealTimeSynchronousLayout
extends AbstractProgramTableLayout {
    @Override
    public void updateLayout(ProgramTableModel model) {
        ProgramPanel panel;
        int row;
        int rowCount;
        int col;
        int columnCount = model.getColumnCount();
        int[] columnStartArr = new int[columnCount];
        float scaleValue = 1.0f;
        int minLength = 10000;
        for (col = 0; col < columnCount; ++col) {
            rowCount = model.getRowCount(col);
            for (row = 0; row < rowCount; ++row) {
                panel = model.getProgramPanel(col, row);
                if (panel.getProgram().getLength() <= 0) continue;
                Program p = panel.getProgram();
                float scale = (float)panel.getMinimumHeight() / (float)p.getLength();
                if (!(scale > scaleValue) || minLength < p.getLength()) continue;
                scaleValue = scale;
                minLength = p.getLength();
            }
        }
        for (col = 0; col < columnCount; ++col) {
            rowCount = model.getRowCount(col);
            for (row = 0; row < rowCount; ++row) {
                panel = model.getProgramPanel(col, row);
                Program program = panel.getProgram();
                if (row == 0) {
                    columnStartArr[col] = model.getDate().compareTo(program.getDate()) < 0 ? (int)((float)(program.getStartTime() + 1440) * scaleValue) : (int)((float)program.getStartTime() * scaleValue);
                }
                if (row != rowCount - 1) {
                    Program next = model.getProgramPanel(col, row + 1).getProgram();
                    int startTime = program.getStartTime();
                    int endTime = next.getStartTime();
                    if (endTime < startTime) {
                        endTime += 1440;
                    }
                    int length = endTime - startTime;
                    panel.setHeight((int)((float)length * scaleValue));
                    continue;
                }
                panel.setHeight(panel.getProgram().getLength() > 0 ? (int)((float)panel.getProgram().getLength() * scaleValue) : panel.getPreferredHeight());
            }
        }
        this.setColumnStarts(columnStartArr);
    }
}

