/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Program;
import tvbrowser.core.Settings;
import tvbrowser.ui.programtable.AbstractProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import util.ui.ProgramPanel;

public class TimeSynchronousLayout
extends AbstractProgramTableLayout {
    @Override
    public void updateLayout(ProgramTableModel model) {
        Program minProgram;
        int columnCount = model.getColumnCount();
        int[] columnStartArr = new int[columnCount];
        int[] rowIdxArr = new int[columnCount];
        int[] colYArr = new int[columnCount];
        int minY = 0;
        int maxY = 0;
        int minSameTimeY = -1;
        long lastStartTime = 0L;
        do {
            minProgram = null;
            ProgramPanel minPanel = null;
            int programCol = 0;
            long minStartTime = Long.MAX_VALUE;
            for (int col = 0; col < columnCount; ++col) {
                long startTime;
                Program program;
                ProgramPanel panel = model.getProgramPanel(col, rowIdxArr[col]);
                if (panel == null || (program = panel.getProgram()) == null || (startTime = program.getDate().getValue() * 10000L + (long)program.getStartTime()) >= minStartTime) continue;
                minStartTime = startTime;
                minProgram = program;
                minPanel = panel;
                programCol = col;
            }
            if (minProgram == null) continue;
            int programRow = rowIdxArr[programCol];
            int y = Math.max(minY, colYArr[programCol]);
            if (minStartTime == lastStartTime) {
                y = Math.max(minSameTimeY, colYArr[programCol]);
            }
            if (programRow == 0) {
                columnStartArr[programCol] = y;
            } else {
                ProgramPanel lastPanel = model.getProgramPanel(programCol, programRow - 1);
                int height = lastPanel.getPreferredHeight();
                int heightDiff = y - colYArr[programCol];
                lastPanel.setHeight(height += heightDiff);
            }
            int preferredHeight = minPanel.getPreferredHeight();
            if (programRow + 1 == model.getRowCount(programCol)) {
                minPanel.setHeight(preferredHeight);
            }
            if (minStartTime != lastStartTime) {
                minSameTimeY = y;
            }
            minY = Math.max(y, minY);
            lastStartTime = minStartTime;
            colYArr[programCol] = y + preferredHeight;
            maxY = Math.max(maxY, colYArr[programCol]);
            int n = programCol;
            rowIdxArr[n] = rowIdxArr[n] + 1;
        } while (minProgram != null);
        for (int col = 0; col < columnCount; ++col) {
            ProgramPanel panel;
            Program program;
            int count = model.getRowCount(col);
            if (count <= 0 || (program = (panel = model.getProgramPanel(col, count - 1)).getProgram()).getStartTime() > Settings.ProgramTable.END_OF_DAY.getInt() || program.getStartTime() + program.getLength() < Settings.ProgramTable.END_OF_DAY.getInt()) continue;
            panel.setHeight(maxY - colYArr[col] + panel.getHeight());
        }
        this.setColumnStarts(columnStartArr);
    }
}

