/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import devplugin.PluginAccess;
import devplugin.Version;
import util.misc.HashCodeUtilities;

public final class BlockedPlugin {
    private static final Version NULL_VERSION = new Version(0, 0, 0, true);
    private Version mBlockStart;
    private Version mBlockEnd;
    private String mPluginId;

    BlockedPlugin(Version blockStart, Version blockEnd, String pluginId) {
        this.mBlockStart = blockStart;
        this.mBlockEnd = blockEnd;
        this.mPluginId = pluginId;
    }

    BlockedPlugin(String asString) {
        String[] versionPart;
        String[] partA = asString.split(";");
        this.mPluginId = partA[0];
        if (partA[1].equals("null")) {
            this.mBlockStart = null;
        } else {
            versionPart = partA[1].split(",");
            this.mBlockStart = new Version((int)Integer.valueOf(versionPart[0]), (int)Integer.valueOf(versionPart[1]), Integer.valueOf(versionPart[2]), Boolean.valueOf(versionPart[3]));
        }
        if (partA[2].equals("null")) {
            this.mBlockStart = null;
        } else {
            versionPart = partA[2].split(",");
            this.mBlockEnd = new Version((int)Integer.valueOf(versionPart[0]), (int)Integer.valueOf(versionPart[1]), Integer.valueOf(versionPart[2]), Boolean.valueOf(versionPart[3]));
        }
    }

    public boolean isBlockedVersion(PluginAccess plugin) {
        return !(plugin == null || !plugin.getId().equals(this.mPluginId) || (this.mBlockEnd != null && !plugin.getInfo().getVersion().isOlderThanOrEqualTo(this.mBlockEnd) || this.mBlockStart != null && !plugin.getInfo().getVersion().isNewerThanOrEqualTo(this.mBlockStart)) && !plugin.getInfo().getVersion().isOlderThanOrEqualTo(NULL_VERSION));
    }

    public boolean isBlockedVersion(String pluginId, Version version) {
        return !(pluginId == null || version == null || !pluginId.equals(this.mPluginId) || (this.mBlockEnd != null && !version.isOlderThanOrEqualTo(this.mBlockEnd) || this.mBlockStart != null && !version.isNewerThanOrEqualTo(this.mBlockStart)) && !version.isOlderThanOrEqualTo(NULL_VERSION));
    }

    String getPropertyString() {
        StringBuilder asString = new StringBuilder(this.mPluginId);
        asString.append(';');
        if (this.mBlockStart == null) {
            asString.append("null");
        } else {
            asString.append(this.mBlockStart.getMajor());
            asString.append(',');
            asString.append(this.mBlockStart.getMinor());
            asString.append(',');
            asString.append(this.mBlockStart.getSubMinor());
            asString.append(',');
            asString.append(this.mBlockStart.isStable());
        }
        asString.append(';');
        if (this.mBlockEnd == null) {
            asString.append("null");
        } else {
            asString.append(this.mBlockEnd.getMajor());
            asString.append(',');
            asString.append(this.mBlockEnd.getMinor());
            asString.append(',');
            asString.append(this.mBlockEnd.getSubMinor());
            asString.append(',');
            asString.append(this.mBlockEnd.isStable());
        }
        return asString.toString();
    }

    public String toString() {
        return "Blocked from: '" + this.mBlockStart + "' to: '" + this.mBlockEnd + "' for ID: '" + this.mPluginId + "'.";
    }

    public boolean equals(Object o) {
        if (o instanceof BlockedPlugin) {
            BlockedPlugin otherPlugin = (BlockedPlugin)o;
            return this.mPluginId.equals(otherPlugin.mPluginId) && this.mBlockStart.equals(otherPlugin.mBlockStart) && this.mBlockEnd.equals(otherPlugin.mBlockEnd);
        }
        if (o instanceof String) {
            return this.mPluginId.equals(o);
        }
        return false;
    }

    public int hashCode() {
        int result = HashCodeUtilities.hash(this.mPluginId);
        result = HashCodeUtilities.hash(result, this.mBlockStart);
        result = HashCodeUtilities.hash(result, this.mBlockEnd);
        return result;
    }

    public String getPluginId() {
        return this.mPluginId;
    }

    public Version getBlockStart() {
        return this.mBlockStart;
    }

    public Version getBlockEnd() {
        return this.mBlockEnd;
    }
}

