/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Channel;
import devplugin.PluginAccess;
import devplugin.PluginCommunication;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.ChannelGroupManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.ChannelListChangesDialog;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.channel.ChannelConfigDlg;
import tvbrowser.ui.settings.channel.ChannelFilter;
import tvbrowser.ui.settings.channel.ChannelJList;
import tvbrowser.ui.settings.channel.ChannelListModel;
import tvbrowser.ui.settings.channel.FilterItem;
import tvbrowser.ui.settings.channel.FilteredChannelListCellRenderer;
import tvbrowser.ui.settings.channel.MultiChannelConfigDlg;
import tvbrowser.ui.settings.util.LineButton;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.io.NetworkUtilities;
import util.ui.ChannelContextMenu;
import util.ui.ChannelListCellRenderer;
import util.ui.DragAndDropMouseListener;
import util.ui.LinkButton;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.customizableitems.SortableItemList;
import util.ui.progress.Progress;
import util.ui.progress.ProgressWindow;

public class ChannelsSettingsTab
implements SettingsTab,
ListDropAction<Object> {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ChannelsSettingsTab.class);
    private JList<Object> mAllChannels;
    private JList<Object> mSubscribedChannels;
    private ChannelListModel mChannelListModel;
    private DragAndDropMouseListener<Object> mSubscribedChannelListener;
    private ListDragAndDropHandler mDnDHandler;
    private JComboBox<FilterItem> mCategoryCB;
    private JComboBox<FilterItem> mCountryCB;
    private JComboBox<FilterItem> mPluginCB;
    private JTextField mChannelName;
    private ChannelFilter mFilter;
    private boolean mListUpdating = false;
    private static final int REFRESH_AFTER_MS = 200;
    private JComponent mAvailableSeparator;
    private JComponent mSubscribedSeparator;
    private Timer mRefreshListTimer;
    private boolean mInitChannelsAsked = false;
    private JButton mLeftButton;
    private JButton mRightButton;
    private JButton mButtonAddSeparator;
    private JButton mButtonDeleteSeparator;
    private boolean mShowPlugins = TvDataServiceProxyManager.getInstance().getDataServices().length > 1;
    private JButton mImExportChannels;
    private PluginCommunication mSyncCommunication;
    private long mLastImExportChannelsPopupClosed = 0L;
    private boolean mIsWizard = false;

    public ChannelsSettingsTab() {
        this(false);
    }

    public ChannelsSettingsTab(boolean isWizard) {
        this.mIsWizard = isWizard;
    }

    @Override
    public JPanel createSettingsPanel() {
        final JPanel result = new JPanel(new BorderLayout());
        if (TvDataServiceProxyManager.getInstance().getDataServices().length >= 1) {
            this.mChannelListModel = new ChannelListModel();
            JPanel panel = new JPanel(new BorderLayout());
            JPanel northPn = new JPanel(new GridLayout(1, 2));
            JPanel centerPn = new JPanel(new GridLayout(1, 2));
            JPanel southPn = new JPanel(new BorderLayout());
            southPn.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            panel.add((Component)northPn, "North");
            panel.add((Component)centerPn, "Center");
            panel.add((Component)southPn, "South");
            this.mAvailableSeparator = DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("availableChannels", "Available channels") + ":");
            this.mAvailableSeparator.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            this.mSubscribedSeparator = DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("subscribedChannels", "Subscribed channels") + ":");
            this.mSubscribedSeparator.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            northPn.add((Component)this.mAvailableSeparator, "North");
            northPn.add((Component)this.mSubscribedSeparator, "North");
            JPanel listBoxPnLeft = new JPanel(new BorderLayout());
            this.mAllChannels = new ChannelJList(new DefaultListModel<Object>());
            this.mAllChannels.setCellRenderer(new ChannelListCellRenderer(true, true, true, true, false, true));
            listBoxPnLeft.add((Component)new JScrollPane(this.mAllChannels), "Center");
            centerPn.add(listBoxPnLeft);
            this.mRightButton = new JButton(TVBrowserIcons.right(22));
            this.mRightButton.addActionListener(e -> this.moveChannelsToRight());
            this.mLeftButton = new JButton(TVBrowserIcons.left(22));
            this.mLeftButton.addActionListener(e -> this.moveChannelsToLeft());
            this.mButtonAddSeparator = new LineButton();
            this.mButtonAddSeparator.setToolTipText(LOCALIZER.msg("addSeparator", "Add separator"));
            this.mButtonAddSeparator.addActionListener(e -> {
                int index = this.mSubscribedChannels.getSelectedIndex() + 1;
                Object test = this.mSubscribedChannels.getSelectedValue();
                if (test instanceof Channel && ((Channel)test).getJointChannel() != null) {
                    ++index;
                }
                ((DefaultListModel)this.mSubscribedChannels.getModel()).insertElementAt("##SEPARATOR##", index);
            });
            this.mButtonAddSeparator.setSize(22, 22);
            new DragSource().createDefaultDragGestureRecognizer(this.mButtonAddSeparator, 2, new DragGestureListener(){

                @Override
                public void dragGestureRecognized(DragGestureEvent dge) {
                    dge.startDrag(null, new StringSelection("##SEPARATOR##"));
                    dge.getComponent().dispatchEvent(new MouseEvent(dge.getComponent(), 505, System.currentTimeMillis(), 0, 0, 0, 0, false, 0));
                }
            });
            this.mButtonDeleteSeparator = new JButton(TVBrowserIcons.delete(22));
            this.mButtonDeleteSeparator.setToolTipText(LOCALIZER.msg("deleteSeparator", "Delete selected separator"));
            this.mButtonDeleteSeparator.addActionListener(e -> {
                int index = this.mSubscribedChannels.getSelectedIndex();
                ((DefaultListModel)this.mSubscribedChannels.getModel()).remove(index);
                this.mButtonDeleteSeparator.setEnabled(false);
                if (index < this.mSubscribedChannels.getModel().getSize()) {
                    this.mSubscribedChannels.setSelectedIndex(index);
                }
            });
            this.mButtonDeleteSeparator.setEnabled(false);
            JPanel btnPanel = this.createButtonPn(this.mRightButton, this.mLeftButton, this.mButtonAddSeparator, this.mButtonDeleteSeparator);
            btnPanel.setBorder(BorderFactory.createEmptyBorder(0, Sizes.dialogUnitXAsPixel((int)3, (Component)btnPanel), 0, Sizes.dialogUnitXAsPixel((int)3, (Component)btnPanel)));
            listBoxPnLeft.add((Component)btnPanel, "East");
            JPanel listBoxPnRight = new JPanel(new BorderLayout());
            SortableItemList<Object> channelList = new SortableItemList<Object>(new ChannelJList());
            this.mSubscribedChannels = channelList.getList();
            this.mFilter = new ChannelFilter();
            this.mSubscribedChannels.setCellRenderer(new FilteredChannelListCellRenderer(this.mFilter));
            this.mDnDHandler = new ListDragAndDropHandler(this.mAllChannels, this.mSubscribedChannels, this, false, true);
            this.mDnDHandler.setPaintCueLine(false, true);
            new DragAndDropMouseListener<Object>(this.mAllChannels, this.mSubscribedChannels, this, this.mDnDHandler);
            this.mSubscribedChannelListener = new DragAndDropMouseListener<Object>(this.mSubscribedChannels, this.mAllChannels, this, this.mDnDHandler);
            this.restoreForPopup();
            this.mImExportChannels = new JButton(LOCALIZER.msg("imExportChannels", "Export/import channels"));
            this.mImExportChannels.addActionListener(e -> this.showImExportSelection());
            this.loadSyncCommunication();
            listBoxPnRight.add((Component)this.mImExportChannels, "North");
            listBoxPnRight.add((Component)new JScrollPane(this.mSubscribedChannels), "Center");
            JButton setSortNumbers = new JButton(LOCALIZER.msg("setSortNumbers", "Set sort numbers"));
            setSortNumbers.setEnabled(false);
            setSortNumbers.addActionListener(e -> this.setSortNumbers());
            JButton configureChannels = new JButton(LOCALIZER.msg("configSelectedChannels", "Configure selected channels"));
            configureChannels.setEnabled(false);
            configureChannels.addActionListener(e -> this.configChannels());
            this.mSubscribedChannels.addListSelectionListener(e -> {
                if (this.mSubscribedChannels.getSelectedValuesList().size() > 0 && !(this.mSubscribedChannels.getSelectedValue() instanceof DummyChannel) && !(this.mSubscribedChannels.getSelectedValue() instanceof String)) {
                    configureChannels.setEnabled(true);
                    setSortNumbers.setEnabled(true);
                    this.mButtonDeleteSeparator.setEnabled(false);
                } else {
                    configureChannels.setEnabled(false);
                    setSortNumbers.setEnabled(false);
                    if (this.mSubscribedChannels.getSelectedValue() instanceof String) {
                        this.mButtonDeleteSeparator.setEnabled(true);
                    }
                }
            });
            this.mAllChannels.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 155) {
                        ChannelsSettingsTab.this.moveChannelsToRight();
                    }
                }
            });
            this.mSubscribedChannels.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        ChannelsSettingsTab.this.moveChannelsToLeft();
                    }
                }
            });
            JPanel btnPanel2 = this.createButtonPn(channelList.getTopButton(), channelList.getUpButton(), channelList.getDownButton(), channelList.getBottomButton());
            btnPanel2.setBorder(BorderFactory.createEmptyBorder(0, Sizes.dialogUnitXAsPixel((int)3, (Component)btnPanel2), 0, 0));
            listBoxPnRight.add((Component)btnPanel2, "East");
            centerPn.add(listBoxPnRight);
            result.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    if (e.getComponent() == result) {
                        ChannelsSettingsTab.this.mRefreshListTimer = null;
                    }
                }
            });
            result.add((Component)this.createFilterPanel(), "North");
            result.add((Component)panel, "Center");
            LinkButton urlLabel = new LinkButton(LOCALIZER.msg("addMoreChannels", "You want to add your own channels? Click here!"), LOCALIZER.msg("addMoreChannelsUrl", "http://enwiki.tvbrowser.org/index.php/Available_stations"));
            JPanel buttonsPanel = new JPanel(new BorderLayout());
            buttonsPanel.add((Component)urlLabel, "South");
            result.add((Component)buttonsPanel, "South");
            JButton refreshList = new JButton(LOCALIZER.msg("updateChannelList", "Update channel list"), TVBrowserIcons.refresh(16));
            refreshList.addActionListener(e -> this.refreshChannelList());
            southPn.add((Component)refreshList, "West");
            JPanel buttons = new JPanel((LayoutManager)new FormLayout("default,3dlu,default", "default"));
            buttons.add((Component)setSortNumbers, CC.xy((int)1, (int)1));
            buttons.add((Component)configureChannels, CC.xy((int)3, (int)1));
            southPn.add((Component)buttons, "East");
            this.mListUpdating = true;
            this.updateFilterPanel();
            this.fillSubscribedChannelsListBox();
            this.fillAvailableChannelsListBox();
            this.mListUpdating = false;
            panel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    Object object;
                    Settings.Channels.SELECTED_CATEGORY_INDEX.setByte((byte)ChannelsSettingsTab.this.mCategoryCB.getSelectedIndex());
                    String country = "";
                    if (ChannelsSettingsTab.this.mCountryCB.getSelectedIndex() >= 0 && (object = ((FilterItem)ChannelsSettingsTab.this.mCountryCB.getSelectedItem()).getValue()) != null) {
                        country = object.toString();
                    }
                    Settings.Channels.SELECTED_COUNTRY.setString(country);
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    if (!ChannelsSettingsTab.this.mInitChannelsAsked && ChannelsSettingsTab.this.mChannelListModel.getAvailableChannels().length == 0) {
                        ChannelsSettingsTab.this.mInitChannelsAsked = true;
                        int ret = JOptionPane.showConfirmDialog(result, LOCALIZER.msg("loadChannelsQuestion", "Should I download the channel list?"), LOCALIZER.msg("loadChannelsTitle", "No channels found"), 0);
                        if (ret == 0) {
                            ChannelsSettingsTab.this.refreshChannelList();
                        }
                    }
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
            if (this.mIsWizard) {
                SwingUtilities.invokeLater(() -> this.askForSynchronization(this.mSyncCommunication == null));
            }
        } else {
            JEditorPane pane = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("noDataPlugins", "<html>You need to <a href=\"#plugins\">install</a> at least one data plugin before you can configure the channels.</html>"), e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#plugins");
                }
            });
            result.add((Component)pane, "Center");
        }
        result.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        return result;
    }

    private void loadSyncCommunication() {
        PluginAccess androidSync = PluginManagerImpl.getInstance().getActivatedPluginForId("java.androidsync.AndroidSync");
        if (androidSync != null) {
            this.mSyncCommunication = androidSync.getCommunicationClass();
        }
    }

    private void askForSynchronization(boolean installPlugin) {
        block11: {
            try {
                PluginProxy plugin = null;
                if (!installPlugin) break block11;
                plugin = PluginProxyManager.getInstance().getPluginForId("java.androidsync.AndroidSync");
                if (plugin == null) {
                    if (UiUtilities.showConfirmDialogOnMouseScreen(LOCALIZER.msg("syncInstallPluginMsg", "You can synchronize your channels with the AndroidSync plugin, therefor it needs to be installed.\n\nDo you want to install the AndroidSync plugin now and synchronize the channels?"), LOCALIZER.msg("syncInstallPluginTitle", "Install AndroidSync plugin?"), 2, 3) != 0) break block11;
                    File target = new File(Settings.Directories.PLUGINS.getString(), "AndroidSync.jar");
                    boolean error = false;
                    try {
                        IOUtilities.download(new URL("https://www.tvbrowser.org/scripts/download-plugin.php?plugin=1381591864575_786"), target);
                        PluginLoader.getInstance().loadPlugin(target, true);
                        plugin = PluginProxyManager.getInstance().getPluginForId("java.androidsync.AndroidSync");
                        PluginProxyManager.getInstance().activatePlugin(plugin);
                        this.loadSyncCommunication();
                        if (!this.synchronizeChannels()) {
                            UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("syncNotPossibleMsg", "Channels could not be synchronized.\n\nPlease select the channels manually"), LOCALIZER.msg("syncNotPossibleTitle", "Channels were not synchronized"), 0);
                        }
                    }
                    catch (MalformedURLException e) {
                        error = true;
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        error = true;
                        e.printStackTrace();
                    }
                    if (error) {
                        UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("syncNotInstalledMsg", "Plugin could not be installed.\n\nPlease select the channels manually"), LOCALIZER.msg("syncNotInstalledTitle", "AndroidSync could not be installed"), 0);
                    }
                    break block11;
                }
                if (plugin.isActivated() || UiUtilities.showConfirmDialogOnMouseScreen(LOCALIZER.msg("syncActivateMsg", "You can synchronize your channels with the AndroidSync plugin, therefor it needs to be activated.\n\nDo you want to activate the AndroidSync plugin now?"), LOCALIZER.msg("syncActivateTitle", "Activate AndroidSync?"), 2, 3) != 0) break block11;
                try {
                    PluginProxyManager.getInstance().activatePlugin(plugin);
                    this.loadSyncCommunication();
                    if (!this.synchronizeChannels()) {
                        UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("syncNotPossibleMsg", "Channels could not be synchronized.\n\nPlease select the channels manually"), LOCALIZER.msg("syncNotPossibleTitle", "Channels were not synchronized"), 0);
                    }
                }
                catch (TvBrowserException e) {
                    UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("syncNotActivatedMsg", "Plugin could not be activated.\n\nPlease select the channels manually"), LOCALIZER.msg("syncNotActivatedTitle", "AndroidSync could not be activated"), 0);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void showImExportSelection() {
        if (this.mLastImExportChannelsPopupClosed + 200L < System.currentTimeMillis()) {
            JMenuItem item;
            JPopupMenu imExportChannelsPopup = new JPopupMenu();
            imExportChannelsPopup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    ChannelsSettingsTab.this.mLastImExportChannelsPopupClosed = System.currentTimeMillis();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            if (this.mSyncCommunication != null) {
                item = new JMenuItem(LOCALIZER.msg("synchronize", "Synchronize channels with AndroidSync"));
                item.addActionListener(e -> this.synchronizeChannels());
                imExportChannelsPopup.add(item);
                imExportChannelsPopup.addSeparator();
            }
            item = new JMenuItem(LOCALIZER.msg("exportChannelsBtn", "Export channels to file"));
            item.addActionListener(e -> this.exportChannelsToFile());
            imExportChannelsPopup.add(item);
            item = new JMenuItem(LOCALIZER.msg("importChannelsBtn", "Import channels from file"));
            item.addActionListener(e -> this.importChannelsFromFile());
            imExportChannelsPopup.add(item);
            imExportChannelsPopup.show(this.mImExportChannels, 0, this.mImExportChannels.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importChannelsFromFile() {
        File file;
        FileNameExtensionFilter filter = new FileNameExtensionFilter(LOCALIZER.msg("textFileType", "Text files"), "txt");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(LOCALIZER.msg("exportChannels", "Export channels"));
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        chooser.setSelectedFile(new File(IOUtilities.translateRelativePath(Settings.Channels.LAST_EXPORT_FILE.getString())));
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance())) == 0 && (file = chooser.getSelectedFile()) != null && file.isFile()) {
            ArrayList<String> channelList = new ArrayList<String>();
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String line = null;
                while ((line = in.readLine()) != null) {
                    channelList.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!channelList.isEmpty() && this.importChannels(channelList.toArray(new String[channelList.size()]))) {
                UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("synched", "Channels were successfully synchronized."), LOCALIZER.msg("importSuccess", "Channels were imported successfully."), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportChannelsToFile() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter(LOCALIZER.msg("textFileType", "Text files"), "txt");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(LOCALIZER.msg("exportChannels", "Export channels"));
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        chooser.setSelectedFile(new File(IOUtilities.translateRelativePath(Settings.Channels.LAST_EXPORT_FILE.getString())));
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showSaveDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance())) == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".txt")) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            boolean save = true;
            if (file.isFile() && JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("exportOverrideMsg", "The file already exists.\nDo you want to override it?"), LOCALIZER.msg("exportOverrideTitle", "Override file?"), 0, 3) != 0) {
                save = false;
            }
            if (save) {
                Settings.Channels.LAST_EXPORT_FILE.setString(IOUtilities.checkForRelativePath(file.getAbsolutePath()));
                BufferedWriter out = null;
                try {
                    FileOutputStream fOut = new FileOutputStream(file);
                    fOut.getChannel().truncate(0L);
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)fOut, "UTF-8"));
                    for (int i = 0; i < this.mSubscribedChannels.getModel().getSize(); ++i) {
                        Object value = this.mSubscribedChannels.getModel().getElementAt(i);
                        if (!(value instanceof Channel)) continue;
                        Channel ch = (Channel)value;
                        out.write(ch.getDataServicePackageName());
                        out.write(":");
                        if (!ch.getDataServicePackageName().equals("epgdonatedata")) {
                            out.write(ch.getGroup().getId());
                            out.write(":");
                        }
                        out.write(ch.getId());
                        if (ch.getSortNumber().trim().length() > 0) {
                            out.write(":");
                            out.write(ch.getSortNumber());
                        }
                        out.write("\n");
                    }
                    out.flush();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
    }

    private boolean importChannels(String[] channels) {
        boolean result = false;
        if (channels != null && channels.length > 0) {
            Channel[] available = ChannelList.getAvailableChannels();
            block0: for (String syncChannel : channels) {
                for (Channel ch : available) {
                    String[] parts = syncChannel.split(":");
                    int index = -1;
                    if (ch.getDataServicePackageName().equals(parts[0])) {
                        if (parts[0].equals("epgdonatedata")) {
                            if (ch.getId().equals(parts[1])) {
                                index = ((DefaultListModel)this.mAllChannels.getModel()).indexOf(ch);
                                if (parts.length > 2) {
                                    ch.setSortNumber(parts[2]);
                                }
                            }
                        } else if (ch.getGroup().getId().equals(parts[1]) && ch.getId().equals(parts[2])) {
                            index = ((DefaultListModel)this.mAllChannels.getModel()).indexOf(ch);
                            if (parts.length > 3) {
                                ch.setSortNumber(parts[3]);
                            }
                        }
                    }
                    if (index == -1) continue;
                    this.mAllChannels.setSelectedIndex(index);
                    UiUtilities.moveSelectedItems(this.mAllChannels, this.mSubscribedChannels);
                    result = true;
                    continue block0;
                }
            }
        }
        return result;
    }

    private boolean synchronizeChannels() {
        boolean methodResult;
        block11: {
            methodResult = false;
            try {
                if (this.mSyncCommunication == null) break block11;
                try {
                    Method getStoredChannels = this.mSyncCommunication.getClass().getMethod("getStoredChannels", new Class[0]);
                    Object result = getStoredChannels.invoke((Object)this.mSyncCommunication, new Object[0]);
                    if (result != null) {
                        this.mCountryCB.setSelectedIndex(0);
                        this.mCategoryCB.setSelectedIndex(0);
                        this.mPluginCB.setSelectedItem(0);
                        this.fillAvailableChannelsListBox();
                        if (this.mSubscribedChannels.getModel().getSize() > 0) {
                            this.mSubscribedChannels.setSelectionInterval(0, this.mSubscribedChannels.getModel().getSize() - 1);
                            UiUtilities.moveSelectedItems(this.mSubscribedChannels, this.mAllChannels);
                        }
                        if (methodResult = this.importChannels((String[])result)) {
                            UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("synched", "Channels were successfully synchronized."), LOCALIZER.msg("syncSuccess", "Synchronization success"), 1);
                        }
                    }
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (NoSuchMethodException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return methodResult;
    }

    private JPanel createFilterPanel() {
        JPanel filter = new JPanel((LayoutManager)new FormLayout("fill:pref:grow", "pref, 3dlu, pref, 3dlu"));
        CellConstraints cc = new CellConstraints();
        JComponent filterSeparator = DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("channelFilter", "Channel Filter") + ":");
        filterSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        filter.add((Component)filterSeparator, cc.xy(1, 1));
        JPanel filterPanel = new JPanel((LayoutManager)new FormLayout("pref, 3dlu, pref:grow, fill:60dlu, 3dlu, pref, 3dlu, pref:grow, pref", "pref, 3dlu, pref, pref"));
        this.mCountryCB = new JComboBox();
        filterPanel.add((Component)new JLabel(LOCALIZER.msg("country", "Country") + ":"), cc.xy(1, 1));
        filterPanel.add(this.mCountryCB, cc.xyw(3, 1, 2));
        this.mCategoryCB = new JComboBox();
        this.mCategoryCB.setMaximumRowCount(20);
        filterPanel.add((Component)new JLabel(LOCALIZER.msg("category", "Category") + ":"), cc.xy(6, 1));
        filterPanel.add(this.mCategoryCB, cc.xyw(8, 1, 2));
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add((Component)new JLabel(LOCALIZER.msg("filterText", "With the following Text") + ": "), "West");
        this.mChannelName = new JTextField();
        namePanel.add((Component)this.mChannelName, "Center");
        filterPanel.add((Component)namePanel, cc.xyw(1, 3, 4));
        this.mPluginCB = new JComboBox();
        this.mPluginCB.setMaximumRowCount(20);
        if (this.mShowPlugins) {
            filterPanel.add((Component)new JLabel(LOCALIZER.msg("plugin", "Plugin") + ":"), cc.xy(6, 3));
            filterPanel.add(this.mPluginCB, cc.xyw(8, 3, 2));
        }
        JButton reset = new JButton(LOCALIZER.msg("reset", "Reset"));
        reset.addActionListener(e -> {
            this.mChannelName.setText("");
            this.mCategoryCB.setSelectedIndex(1);
            this.mCountryCB.setSelectedIndex(0);
            this.mPluginCB.setSelectedIndex(0);
        });
        if (this.mShowPlugins) {
            filterPanel.add((Component)reset, cc.xy(9, 4));
        } else {
            filterPanel.add((Component)reset, cc.xy(9, 3));
        }
        filter.add((Component)filterPanel, cc.xy(1, 3));
        ItemListener filterItemListener = e -> {
            if (!(e != null && e.getStateChange() != 1 || this.mListUpdating)) {
                SwingUtilities.invokeLater(() -> {
                    this.mListUpdating = true;
                    this.fillAvailableChannelsListBox();
                    this.mListUpdating = false;
                });
            }
        };
        this.mCountryCB.addItemListener(filterItemListener);
        this.mCategoryCB.addItemListener(filterItemListener);
        this.mPluginCB.addItemListener(filterItemListener);
        this.mChannelName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ChannelsSettingsTab.this.startTimer();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ChannelsSettingsTab.this.startTimer();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ChannelsSettingsTab.this.startTimer();
            }
        });
        return filter;
    }

    protected void startTimer() {
        if (this.mRefreshListTimer != null) {
            this.mRefreshListTimer.cancel();
        }
        this.mRefreshListTimer = new Timer("Refresh channel list");
        this.mRefreshListTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!ChannelsSettingsTab.this.mListUpdating) {
                    ChannelsSettingsTab.this.mListUpdating = true;
                    ChannelsSettingsTab.this.fillAvailableChannelsListBox();
                    ChannelsSettingsTab.this.mListUpdating = false;
                    ChannelsSettingsTab.this.mRefreshListTimer = null;
                } else {
                    ChannelsSettingsTab.this.startTimer();
                }
            }
        }, 200L);
    }

    private void updateFilterPanel() {
        Channel[] allChannels = ChannelList.getAvailableChannels();
        this.mCategoryCB.removeAllItems();
        this.mCategoryCB.addItem(new FilterItem(LOCALIZER.msg("allCategories", "All Categories"), null));
        this.mCategoryCB.addItem(new FilterItem(LOCALIZER.msg("allExceptEventCinema", "All except Event/Cinema"), new Integer[]{1, 2, 0}));
        if (this.channelListContains(allChannels, 1)) {
            this.addCategoryFilter(1);
            if (this.channelListContains(allChannels, 1)) {
                this.mCategoryCB.addItem(new FilterItem(LOCALIZER.msg("categoryNotSpecial", "TV"), new Integer[]{1, -32, -64, -128, -256}));
            }
            if (this.channelListContains(allChannels, 16)) {
                this.addCategoryFilter(16);
            }
            if (this.channelListContains(allChannels, 32)) {
                this.addCategoryFilter(32);
            }
            if (this.channelListContains(allChannels, 64)) {
                this.addCategoryFilter(64);
            }
            if (this.channelListContains(allChannels, 128)) {
                this.addCategoryFilter(128);
            }
            if (this.channelListContains(allChannels, 256)) {
                this.addCategoryFilter(256);
            }
            if (this.channelListContains(allChannels, 1)) {
                this.mCategoryCB.addItem(new FilterItem(LOCALIZER.msg("categoryFreeTv", "TV"), new Integer[]{1, -512}));
            }
            if (this.channelListContains(allChannels, 512)) {
                this.addCategoryFilter(512);
            }
            if (this.channelListContains(allChannels, 2)) {
                this.addCategoryFilter(2);
            }
        }
        if (this.channelListContains(allChannels, 4)) {
            this.addCategoryFilter(4);
        }
        if (this.channelListContains(allChannels, 8)) {
            this.addCategoryFilter(8);
        }
        if (this.channelListContains(allChannels, 1024)) {
            this.addCategoryFilter(1024);
        }
        if (this.channelListContains(allChannels, 0)) {
            this.addCategoryFilter(0);
        }
        if (this.mCategoryCB.getItemCount() > Settings.Channels.SELECTED_CATEGORY_INDEX.getByte()) {
            this.mCategoryCB.setSelectedIndex(Settings.Channels.SELECTED_CATEGORY_INDEX.getByte());
        }
        HashSet<String> countries = new HashSet<String>();
        for (Channel allChannel : allChannels) {
            String[] allCountries = allChannel.getAllCountries();
            if (allCountries == null) continue;
            for (String country : allCountries) {
                if (country == null) continue;
                countries.add(country.toLowerCase());
            }
        }
        this.mCountryCB.removeAllItems();
        this.mCountryCB.addItem(new FilterItem(LOCALIZER.msg("allCountries", "All Countries"), null));
        ArrayList<FilterItem> items = new ArrayList<FilterItem>(countries.size());
        for (String country : countries) {
            Locale locale = new Locale(Locale.getDefault().getLanguage(), country);
            items.add(new FilterItem(locale.getDisplayCountry(), country));
        }
        Collections.sort(items);
        String defaultCountry = Settings.Channels.SELECTED_COUNTRY.getString();
        for (FilterItem item : items) {
            this.mCountryCB.addItem(item);
            if (defaultCountry.isEmpty() || !defaultCountry.equalsIgnoreCase(item.getValue().toString())) continue;
            this.mCountryCB.setSelectedIndex(this.mCountryCB.getItemCount() - 1);
        }
        if (this.mCountryCB.getSelectedIndex() == -1) {
            this.mCountryCB.setSelectedIndex(0);
        }
        this.mPluginCB.removeAllItems();
        this.mPluginCB.addItem(new FilterItem(LOCALIZER.msg("allPlugins", "All Plugins"), null));
        items = new ArrayList();
        for (TvDataServiceProxy dataService : TvDataServiceProxyManager.getInstance().getDataServices()) {
            String name = dataService.getInfo().getName();
            items.add(new FilterItem(name, name));
        }
        Collections.sort(items);
        String defaultPlugin = Settings.Channels.SELECTED_PLUGIN.getString();
        for (FilterItem item : items) {
            this.mPluginCB.addItem(item);
            if (defaultPlugin.isEmpty() || !defaultPlugin.equalsIgnoreCase(item.getValue().toString())) continue;
            this.mPluginCB.setSelectedIndex(this.mPluginCB.getItemCount() - 1);
        }
        if (this.mPluginCB.getSelectedIndex() == -1 || !this.mShowPlugins) {
            this.mPluginCB.setSelectedIndex(0);
        }
    }

    private void addCategoryFilter(int category) {
        this.mCategoryCB.addItem(new FilterItem(Channel.getLocalizedCategory(category), category));
    }

    private boolean channelListContains(Channel[] allChannels, int category) {
        for (int i = allChannels.length - 1; i >= 0; --i) {
            if ((allChannels[i].getCategories() & category) > 0) {
                return true;
            }
            if (allChannels[i].getCategories() != 0 || category != 0) continue;
            return true;
        }
        return false;
    }

    private void restoreForPopup() {
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ChannelJList channelJList = (ChannelJList)e.getSource();
                    channelJList.setSelectedIndex(channelJList.locationToIndex(e.getPoint()));
                }
                ChannelsSettingsTab.this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ChannelsSettingsTab.this.showPopup(e);
            }
        };
        this.mSubscribedChannels.addMouseListener(listener);
        this.mAllChannels.addMouseListener(listener);
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            ChannelJList channelJList = (ChannelJList)e.getSource();
            new ChannelContextMenu(e, (Channel)channelJList.getModel().getElementAt(channelJList.locationToIndex(e.getPoint())), this);
        }
    }

    private JPanel createButtonPn(JButton btn1, JButton btn2, JButton btn3, JButton btn4) {
        JPanel result = new JPanel((LayoutManager)new FormLayout("pref", "fill:pref:grow, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, fill:pref:grow"));
        CellConstraints cc = new CellConstraints();
        result.add((Component)btn1, cc.xy(1, 2));
        result.add((Component)btn2, cc.xy(1, 4));
        result.add((Component)btn3, cc.xy(1, 6));
        result.add((Component)btn4, cc.xy(1, 8));
        return result;
    }

    private void saveSettingsInternal(boolean autoUpdate) {
        ChannelsSettingsTab.saveChannels(((DefaultListModel)this.mSubscribedChannels.getModel()).toArray(), autoUpdate);
        MainFrame.getInstance().updateChannelChooser();
    }

    static void saveChannels(Object[] list, boolean autoUpdate) {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        ArrayList<Object> separators = new ArrayList<Object>();
        Object lastChannelId = "";
        for (int i = 0; i < list.length; ++i) {
            if (list[i] instanceof Channel) {
                channels.add((Channel)list[i]);
                if (!groups.contains(((Channel)channels.get(channels.size() - 1)).getGroup().getId())) {
                    groups.add(((Channel)channels.get(channels.size() - 1)).getDataServiceId() + '.' + ((Channel)channels.get(channels.size() - 1)).getGroup().getId());
                }
                if (((String)lastChannelId).endsWith("##SEPARATOR##")) {
                    separators.add((String)lastChannelId + ";" + ((Channel)channels.get(channels.size() - 1)).getUniqueId());
                    lastChannelId = "";
                }
                lastChannelId = ((Channel)channels.get(channels.size() - 1)).getUniqueId();
                continue;
            }
            if (!(list[i] instanceof String) || ((String)lastChannelId).endsWith("##SEPARATOR##")) continue;
            lastChannelId = (String)lastChannelId + ";##SEPARATOR##";
        }
        if (((String)lastChannelId).endsWith("##SEPARATOR##")) {
            separators.add(lastChannelId);
        }
        Channel[] channelArr = channels.toArray(new Channel[channels.size()]);
        ChannelList.setSubscribeChannels(channelArr, autoUpdate);
        ChannelList.storeAllSettings();
        Settings.Channels.SUBSCRIBED_SEPARATORS.setStringArray(separators.toArray(new String[separators.size()]));
        Settings.Channels.SUBSCRIBED.setChannelArray(channelArr);
        Settings.Channels.USED_CHANNEL_GROUPS.setStringArray(groups.toArray(new String[groups.size()]));
        Settings.Channels.WERE_CONFIGURED.setBoolean(ChannelList.getNumberOfSubscribedChannels() > 0);
        Settings.updateChannelFilters(channelArr);
        if (!Settings.Tray.Channels.SPECIAL_USE.getBoolean()) {
            Channel[] tempArr = new Channel[channelArr.length > 10 ? 10 : channelArr.length];
            System.arraycopy(channelArr, 0, tempArr, 0, tempArr.length);
            Settings.Tray.Channels.SPECIAL.setChannelArray(tempArr);
        }
    }

    @Override
    public void saveSettings() {
        this.saveSettingsInternal(true);
    }

    public void saveSettingsWithoutDataUpdate() {
        this.saveSettingsInternal(false);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "scroll-to-channel", 16);
    }

    @Override
    public String getTitle() {
        return Localizer.getLocalization("i18n_channels");
    }

    private void fillSubscribedChannelsListBox() {
        Channel[] channels;
        Channel[] subscribedChannelArr = new Channel[this.mChannelListModel.getSubscribedChannels().size()];
        ((DefaultListModel)this.mSubscribedChannels.getModel()).clear();
        for (Channel channel : channels = this.mChannelListModel.getAvailableChannels()) {
            int pos = ChannelList.getPos(channel);
            if (pos == -1 || pos >= subscribedChannelArr.length) continue;
            subscribedChannelArr[pos] = channel;
        }
        String[] separatorArr = Settings.Channels.SUBSCRIBED_SEPARATORS.getStringArray();
        Channel previousChannel = null;
        int lastSeparatorIndex = 0;
        for (Channel aSubscribedChannelArr : subscribedChannelArr) {
            if (aSubscribedChannelArr == null) continue;
            for (int i = lastSeparatorIndex; i < separatorArr.length; ++i) {
                String separator = separatorArr[i];
                if (!separator.endsWith(aSubscribedChannelArr.getUniqueId()) || previousChannel == null || !separator.startsWith(previousChannel.getUniqueId())) continue;
                ((DefaultListModel)this.mSubscribedChannels.getModel()).addElement("##SEPARATOR##");
                lastSeparatorIndex = i + 1;
            }
            previousChannel = aSubscribedChannelArr;
            ((DefaultListModel)this.mSubscribedChannels.getModel()).addElement(aSubscribedChannelArr);
        }
        this.mLeftButton.setEnabled(this.mSubscribedChannels.getModel().getSize() > 0);
        this.updateChannelNumbers();
    }

    private void updateChannelNumbers() {
        String text = LOCALIZER.msg("channelCount", "subscribed to {0} of {1} channels", this.mSubscribedChannels.getModel().getSize(), this.mAllChannels.getModel().getSize());
        this.mAvailableSeparator.setToolTipText(text);
        this.mSubscribedSeparator.setToolTipText(text);
    }

    private void fillAvailableChannelsListBox() {
        Object categoryInt;
        Object oldSelectedChannel = this.mAllChannels.getSelectedValue();
        FilterItem selectedCountry = (FilterItem)this.mCountryCB.getSelectedItem();
        FilterItem selectedCategory = (FilterItem)this.mCategoryCB.getSelectedItem();
        FilterItem selectedPlugin = (FilterItem)this.mPluginCB.getSelectedItem();
        if (selectedCountry == null || selectedCategory == null || selectedPlugin == null) {
            return;
        }
        String country = (String)selectedCountry.getValue();
        String plugin = (String)selectedPlugin.getValue();
        if (selectedCategory.getValue() instanceof Integer[]) {
            categoryInt = (Integer[])selectedCategory.getValue();
            int[] categories = new int[((Integer[])categoryInt).length];
            int max = ((Integer[])categoryInt).length;
            for (int i = 0; i < max; ++i) {
                categories[i] = categoryInt[i] != null ? (Integer)categoryInt[i] : Integer.MAX_VALUE;
            }
            this.mFilter.setFilter(country, categories, this.mChannelName.getText(), plugin);
        } else {
            categoryInt = (Integer)selectedCategory.getValue();
            int categories = Integer.MAX_VALUE;
            if (categoryInt != null) {
                categories = (Integer)categoryInt;
            }
            this.mFilter.setFilter(country, categories, this.mChannelName.getText(), plugin);
        }
        Channel[] channels = this.mChannelListModel.getAvailableChannels();
        ArrayList<Channel> availableChannelList = new ArrayList<Channel>();
        for (Channel channel : channels) {
            if (((DefaultListModel)this.mSubscribedChannels.getModel()).contains(channel) || !this.mFilter.accept(channel)) continue;
            availableChannelList.add(channel);
        }
        Channel[] availableChannelArr = new Channel[availableChannelList.size()];
        availableChannelList.toArray(availableChannelArr);
        Arrays.sort(availableChannelArr, this.createChannelComparator());
        DefaultListModel<Channel> newModel = new DefaultListModel<Channel>();
        for (Channel anAvailableChannelArr : availableChannelArr) {
            newModel.addElement(anAvailableChannelArr);
        }
        this.mAllChannels.setModel(newModel);
        this.mRightButton.setEnabled(!newModel.isEmpty());
        this.mAllChannels.setEnabled(!newModel.isEmpty());
        if (this.mAllChannels.getModel().getSize() == 0) {
            ((DefaultListModel)this.mAllChannels.getModel()).addElement(LOCALIZER.msg("noChannelFound", "No Channel Found"));
            if (this.mCountryCB.getSelectedIndex() == 0 && this.mCategoryCB.getSelectedIndex() <= 1 && this.mPluginCB.getSelectedIndex() > 0 && this.mChannelName.getText().isBlank()) {
                SwingUtilities.invokeLater(() -> {
                    int ret = JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("loadChannelsQuestion", "Should I download the channel list?"), LOCALIZER.msg("loadChannelsTitle", "No channels found"), 0);
                    if (ret == 0) {
                        this.refreshChannelList();
                    }
                });
            }
        } else {
            Object newSelection = availableChannelArr[0];
            if (oldSelectedChannel != null && newModel.contains(oldSelectedChannel)) {
                newSelection = oldSelectedChannel;
            }
            this.mAllChannels.setSelectedValue(newSelection, true);
        }
        this.mSubscribedChannels.repaint();
        this.mSubscribedChannelListener.restore();
        this.restoreForPopup();
        this.updateChannelNumbers();
    }

    private Comparator<Channel> createChannelComparator() {
        return new Comparator<Channel>(){

            @Override
            public int compare(Channel o1, Channel o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
    }

    private void refreshChannelList() {
        if (!NetworkUtilities.checkConnection()) {
            UiUtilities.showMessageDialogOnMouseScreen(LOCALIZER.msg("noConnection.message", "No connection to the Internet established.\n\nThe channel list can only be updated if a connection\nto the Internet is available."), LOCALIZER.msg("noConnection.title", "No connection!"), 0);
            return;
        }
        final ProgressWindow win = new ProgressWindow(MainFrame.getInstance());
        win.run(new Progress(){

            @Override
            public void run() {
                Channel[] channels = ChannelsSettingsTab.this.mChannelListModel.getAvailableChannels();
                ArrayList<Channel> before = new ArrayList<Channel>();
                for (Channel channel : channels) {
                    before.add(channel);
                }
                ChannelGroupManager.getInstance().checkForAvailableGroupsAndChannels(win);
                SwingUtilities.invokeLater(() -> {
                    ChannelsSettingsTab.this.mChannelListModel.refresh();
                    ChannelsSettingsTab.this.updateFilterPanel();
                    ChannelsSettingsTab.this.fillSubscribedChannelsListBox();
                    ChannelsSettingsTab.this.fillAvailableChannelsListBox();
                    ChannelsSettingsTab.this.showChannelChanges(before);
                });
            }
        });
    }

    private void showChannelChanges(ArrayList<Channel> channelsBefore) {
        Channel[] channels = this.mChannelListModel.getAvailableChannels();
        Channel[] channelsAfterArr = new Channel[channels.length];
        System.arraycopy(channels, 0, channelsAfterArr, 0, channelsAfterArr.length);
        List<Channel> channelsAfter = Arrays.asList(channelsAfterArr);
        ChannelListChangesDialog.showChannelChanges(SettingsDialog.getInstance().getDialog(), channelsBefore, channelsAfter, false);
        Settings.updateChannelFilters(ChannelList.getSubscribedChannels());
    }

    private void setSortNumbers() {
        Channel ch;
        int smallest = this.mSubscribedChannels.getSelectedIndex();
        if (smallest > 1 && (ch = (Channel)this.mSubscribedChannels.getModel().getElementAt(smallest - 1)).getSortNumber().trim().length() > 0) {
            smallest = Integer.parseInt(ch.getSortNumber());
        }
        JSpinner start = new JSpinner(new SpinnerNumberModel(++smallest, 1, 10000, 1));
        Object[] message = new Object[]{LOCALIZER.msg("numberChannels", "Create channel numbers (up), start with:"), start};
        if (JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), message, LOCALIZER.msg("setSortNumbers", "Set sort numbers"), 2, -1) == 0) {
            List<Object> list = this.mSubscribedChannels.getSelectedValuesList();
            int value = (Integer)start.getValue();
            Channel previous = null;
            for (Object channel : list) {
                if (channel instanceof DummyChannel || channel instanceof String) continue;
                if (previous == null || previous.getJointChannel() == null || previous.getJointChannel().equals(channel)) {
                    // empty if block
                }
                int n = --value;
                ++value;
                ((Channel)channel).setSortNumber(String.valueOf(n));
                previous = (Channel)channel;
            }
            this.mSubscribedChannels.repaint();
            MainFrame.getInstance().getProgramTableScrollPane().updateChannelPanel();
            MainFrame.getInstance().updateChannelChooser();
        }
    }

    public void configChannels() {
        JDialog dialog;
        Window parent;
        List<Object> list = this.mSubscribedChannels.getSelectedValuesList();
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        for (Object o : list) {
            if (o instanceof DummyChannel) continue;
            channelList.add((Channel)o);
        }
        if (channelList.size() == 1) {
            parent = UiUtilities.getBestDialogParent(this.mAllChannels);
            dialog = new ChannelConfigDlg(parent, (Channel)channelList.get(0));
            ((ChannelConfigDlg)dialog).centerAndShow();
            ChannelList.checkForJointChannels();
            MainFrame.getInstance().getProgramTableScrollPane().updateChannelLabelForChannel((Channel)channelList.get(0));
        } else if (channelList.size() > 1) {
            parent = UiUtilities.getBestDialogParent(this.mAllChannels);
            dialog = new MultiChannelConfigDlg(parent, channelList.toArray(new Channel[channelList.size()]));
            Settings.layoutWindow("multiChannelConfigDlg", dialog);
            dialog.setVisible(true);
        }
        this.mSubscribedChannels.repaint();
        this.mSubscribedChannelListener.restore();
        this.restoreForPopup();
    }

    private void moveChannelsToRight() {
        Object[] objects = UiUtilities.moveSelectedItems(this.mAllChannels, this.mSubscribedChannels);
        boolean missingIcon = false;
        for (Object object : objects) {
            if (!(object instanceof Channel)) continue;
            Channel channel = (Channel)object;
            this.mChannelListModel.subscribeChannel(channel);
            if (channel.getIcon() != null) continue;
            missingIcon = true;
        }
        if (missingIcon) {
            DontShowAgainOptionBox.showOptionDialog("missingIcon", MainFrame.getInstance(), LOCALIZER.msg("noIconAvailable.message", "You have added a channel without channel icon. Due to copyright reasons we cannot provide icons for each channel.\nFor better visual differentiation you can add your icon to the channel using the right mouse menu in the channel list."), LOCALIZER.msg("noIconAvailable.title", "No channel icon"));
        }
    }

    private void moveChannelsToLeft() {
        Object[] objects;
        for (Object object : objects = UiUtilities.moveSelectedItems(this.mSubscribedChannels, this.mAllChannels, String.class)) {
            if (!(object instanceof Channel)) continue;
            this.mChannelListModel.unsubscribeChannel((Channel)object);
        }
        this.mLeftButton.setEnabled(this.mSubscribedChannels.getModel().getSize() > 0);
        this.fillAvailableChannelsListBox();
    }

    private void moveChannels(int row) {
        Object[] objects;
        for (Object object : objects = UiUtilities.moveSelectedItems(this.mAllChannels, this.mSubscribedChannels, row)) {
            this.mChannelListModel.subscribeChannel((Channel)object);
        }
    }

    @Override
    public void drop(JList<Object> source, JList<Object> target, int n, boolean move) {
        if (source.equals(this.mAllChannels) && !source.equals(target) && move) {
            this.moveChannelsToRight();
        } else if (source.equals(this.mSubscribedChannels) && !source.equals(target) && move) {
            this.moveChannelsToLeft();
        } else if (source.equals(this.mSubscribedChannels) && target.equals(this.mSubscribedChannels)) {
            Object test;
            if (n > 0 && (test = this.mSubscribedChannels.getSelectedValue()) instanceof String) {
                Object targetObject2;
                Object targetObject = this.mSubscribedChannels.getModel().getElementAt(n - 1);
                Object object = targetObject2 = n < this.mSubscribedChannels.getModel().getSize() - 1 ? this.mSubscribedChannels.getModel().getElementAt(n) : null;
                if (targetObject instanceof Channel && ((Channel)targetObject).getJointChannel() != null && targetObject2 instanceof Channel && ((Channel)targetObject2).getBaseChannel() != null && ((Channel)targetObject2).getBaseChannel().equals(targetObject)) {
                    List<Object> values = this.mSubscribedChannels.getSelectedValuesList();
                    boolean containsChannel = false;
                    for (Object value : values) {
                        if (!(value instanceof Channel)) continue;
                        containsChannel = true;
                        break;
                    }
                    if (!containsChannel) {
                        ++n;
                    }
                }
            }
            UiUtilities.moveSelectedItems(target, n, true);
        } else if (source.equals(this.mAllChannels) && target.equals(this.mSubscribedChannels)) {
            this.moveChannels(n);
        } else if (source.equals(this.mSubscribedChannels) && target.equals(this.mAllChannels)) {
            this.moveChannelsToLeft();
        }
    }
}

