/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.TVBrowser;
import tvbrowser.core.JREUpdater;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.protocolhandler.ProtocolHandler;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.PeriodItem;
import util.browserlauncher.Launch;
import util.i18n.Localizer;
import util.io.windows.registry.RegistryKey;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;
import util.ui.WideComboBox;

public class GeneralSettingsTab
implements SettingsTab {
    public static final int VALUE_AUTO_CHANNEL_UPDATE_DISABLED = -1;
    private static final DayPeriod VALUE_AUTO_CHANNEL_UPDATE_PERIOD_DEFAULT = new DayPeriod(14);
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(GeneralSettingsTab.class);
    private JPanel mSettingsPn;
    private JCheckBox mShowStartScreenChB;
    private JCheckBox mMinimizeAfterStartUpChB;
    private JCheckBox mStartFullscreen;
    private JCheckBox mAutostart;
    private JCheckBox mServerForRestore;
    private JCheckBox mProtocolHandler;
    private File mLinkFileFile;
    private LinkFile mLinkFile;
    private static final String[] AUTO_DOWNLOAD_MSG_ARR = new String[]{LOCALIZER.msg("autoDownload.daily", "Once a day"), LOCALIZER.msg("autoDownload.every3days", "Every three days"), LOCALIZER.msg("autoDownload.weekly", "Weekly")};
    private JCheckBox mAutoDownload;
    private JCheckBox mAutoDownloadPrimeTime;
    private JCheckBox mAutoChannelDownload;
    private JCheckBox mAutoJREUpdate;
    private JCheckBox mInformTestVersions;
    private JRadioButton mStartDownload;
    private JRadioButton mRecurrentDownload;
    private JComboBox<String> mAutoDownloadCombo;
    private WideComboBox<DayPeriod> mAutoChannelDownloadPeriod;
    private JComboBox<PeriodItem> mAutoDownloadPeriodCB;
    private JRadioButton mAskBeforeDownloadRadio;
    private JRadioButton mAskTimeRadio;
    private JLabel mHowOften;
    private JCheckBox mDateCheck;
    private JCheckBox mAutoDownloadWaitingTime;
    private JSpinner mAutoDownloadWaitingTimeSp;
    private JCheckBox mOnlyMinimizeWhenWindowClosingChB;
    private JCheckBox mAskForExitConfirmation;
    private JCheckBox mShowFinishDialog;
    private JLabel mSecondsLabel;

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu, default, 3dlu, default, fill:3dlu:grow, 3dlu", "default, 5dlu, default, 1dlu, default, 1dlu, default, 1dlu, default, 1dlu, default, 10dlu, default, 10dlu, default, 5dlu, default, default");
        this.mSettingsPn = new JPanel((LayoutManager)layout);
        this.mSettingsPn.setBorder(Borders.DIALOG);
        int y = 1;
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("title", "Startup")), CC.xyw((int)1, (int)y++, (int)5));
        this.mMinimizeAfterStartUpChB = new JCheckBox(LOCALIZER.msg("minimizeAfterStartup", "Minimize main window after start up"), Settings.General.MINIMIZE_AFTER_STARTUP.getBoolean());
        this.mSettingsPn.add((Component)this.mMinimizeAfterStartUpChB, CC.xy((int)2, (int)(++y)));
        ++y;
        this.mStartFullscreen = new JCheckBox(LOCALIZER.msg("startFullscreen", "Start in fullscreen mode"), Settings.General.IS_USING_FULLSCREEN.getBoolean());
        this.mSettingsPn.add((Component)this.mStartFullscreen, CC.xy((int)2, (int)(++y)));
        this.mMinimizeAfterStartUpChB.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.mStartFullscreen.setSelected(false);
            }
        });
        this.mStartFullscreen.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.mMinimizeAfterStartUpChB.setSelected(false);
            }
        });
        ++y;
        this.mShowStartScreenChB = new JCheckBox(LOCALIZER.msg("showStartScreen", "Show TV-Browser start screen during start up"), Settings.General.START_SCREEN_SHOW.getBoolean());
        this.mSettingsPn.add((Component)this.mShowStartScreenChB, CC.xy((int)2, (int)(++y)));
        ++y;
        this.mServerForRestore = new JCheckBox(LOCALIZER.msg("serverForRestore", "Provide server port for restore running TV-Browser/handling protocol messages"), Settings.General.SERVER_RESTORE_ENABLED.getBoolean());
        this.mSettingsPn.add((Component)this.mServerForRestore, CC.xy((int)2, (int)(++y)));
        if (!TVBrowser.isTransportable() || Launch.getOs() != 0) {
            this.mProtocolHandler = new JCheckBox(LOCALIZER.msg("protocolHandler", "Allow handling of tvb:// protocol messages"), Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.getBoolean() && this.mServerForRestore.isSelected());
            this.mProtocolHandler.setEnabled(this.mServerForRestore.isSelected());
            this.mSettingsPn.add((Component)this.mProtocolHandler, CC.xy((int)2, (int)(y += 2)));
        }
        this.mServerForRestore.addItemListener(e -> this.mProtocolHandler.setEnabled(1 == e.getStateChange()));
        if (Launch.getOs() == 1 && !TVBrowser.isTransportable()) {
            layout.insertRow(++y, RowSpec.decode((String)"1dlu"));
            layout.insertRow(++y, RowSpec.decode((String)"pref"));
            try {
                block25: {
                    RegistryKey shellFolders = new RegistryKey("HKCU", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    String path = shellFolders.getValue("Startup").getData().toString();
                    if (path == null || path.length() < 1 || !new File(path).isDirectory()) {
                        throw new Exception();
                    }
                    this.mLinkFileFile = new File(path, "TV-Browser.url");
                    try {
                        this.mLinkFile = new LinkFile(this.mLinkFileFile);
                        if (!this.mLinkFileFile.isFile()) break block25;
                        try {
                            if (!this.mLinkFile.hasTarget(new File("tvbrowser.exe").getAbsoluteFile())) {
                                this.createLink();
                            }
                        }
                        catch (Exception linkException) {
                            this.mLinkFileFile.delete();
                        }
                    }
                    catch (FileNotFoundException linkException) {
                        // empty catch block
                    }
                }
                this.mAutostart = new JCheckBox(LOCALIZER.msg("autostart", "Start TV-Browser with Windows"), this.mLinkFileFile.isFile());
                this.mSettingsPn.add((Component)this.mAutostart, CC.xy((int)2, (int)y));
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        } else if (Launch.getOs() == 3 && !TVBrowser.isTransportable()) {
            layout.insertRow(++y, RowSpec.decode((String)"1dlu"));
            layout.insertRow(++y, RowSpec.decode((String)"pref"));
            this.mLinkFileFile = new File(System.getProperty("user.home") + "/.config/autostart/tvbrowser.desktop");
            if (this.mLinkFileFile.isFile()) {
                File starter = new File("");
                starter = new File(starter.getAbsolutePath(), "tvbrowser.sh");
                try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.mLinkFileFile), "UTF-8"));){
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        if (!line.startsWith("Exec")) continue;
                        if ((line = line.substring(line.indexOf("=") + 1)).startsWith("/") && !line.startsWith(starter.getAbsolutePath()) || starter.equals("/usr/share/tvbrowser/tvbrowser.sh") && line.startsWith("tvbrowser")) {
                            try {
                                this.createLink();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.mAutostart = new JCheckBox(LOCALIZER.msg("autostartLinux", "Start TV-Browser after login"), this.mLinkFileFile.isFile());
            this.mSettingsPn.add((Component)this.mAutostart, CC.xy((int)2, (int)y));
        }
        ++y;
        this.mSettingsPn.add((Component)this.createRefreshPanel(), CC.xyw((int)1, (int)(++y), (int)5));
        this.mAutoJREUpdate = new JCheckBox(LOCALIZER.msg("autoJREUpdate", "Search and download updates for TV-Browser JRE regularly"), Settings.General.JRE_UPDATE_ENABLED.getBoolean());
        if (JREUpdater.hasTvBrowserJRE()) {
            layout.insertRow(++y, RowSpec.decode((String)"5dlu"));
            layout.insertRow(++y, RowSpec.decode((String)"pref"));
            this.mSettingsPn.add((Component)this.mAutoJREUpdate, CC.xyw((int)2, (int)y, (int)4));
        }
        this.mInformTestVersions = new JCheckBox(LOCALIZER.msg("informTestVersion", "Show info when test versions of TV-Browser are available"), !Settings.General.INFORM_TEST_VERSIONS.isHidden());
        layout.insertRow(++y, RowSpec.decode((String)"5dlu"));
        layout.insertRow(++y, RowSpec.decode((String)"default"));
        this.mSettingsPn.add((Component)this.mInformTestVersions, CC.xyw((int)2, (int)y, (int)4));
        ++y;
        String msg = LOCALIZER.msg("onlyMinimizeWhenWindowClosing", "When closing the main window only minimize TV-Browser, don't quit.");
        this.mOnlyMinimizeWhenWindowClosingChB = new JCheckBox(msg, Settings.General.ONLY_MINIMIZE_WHEN_WINDOW_CLOSING.getBoolean());
        this.mAskForExitConfirmation = new JCheckBox(LOCALIZER.msg("askForExitConfirmation", "Ask for confirmation on TV-Browser exit"), !Settings.General.ASK_FOR_EXIT_CONFIRMATION.isHidden());
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("closing", "Closing")), CC.xyw((int)1, (int)(++y), (int)5));
        ++y;
        this.mSettingsPn.add((Component)this.mOnlyMinimizeWhenWindowClosingChB, CC.xyw((int)2, (int)(++y), (int)4));
        this.mSettingsPn.add((Component)this.mAskForExitConfirmation, CC.xyw((int)2, (int)(++y), (int)4));
        return this.mSettingsPn;
    }

    private void createLink() throws Exception {
        File tvb;
        if (Launch.getOs() == 3) {
            ProtocolHandler.createDesktopFile(this.mLinkFileFile, "TV-Browser", false);
        } else if (Launch.getOs() == 1 && (tvb = new File("tvbrowser.exe")).getAbsoluteFile().isFile()) {
            this.mLinkFile = new LinkFile(this.mLinkFileFile, tvb, new File(tvb.getAbsoluteFile().getParent() + "\\imgs\\desktop.ico"), 0);
        }
    }

    @Override
    public void saveSettings() {
        Settings.General.MINIMIZE_AFTER_STARTUP.setBoolean(this.mMinimizeAfterStartUpChB.isSelected());
        Settings.General.START_SCREEN_SHOW.setBoolean(this.mShowStartScreenChB.isSelected());
        Settings.General.IS_USING_FULLSCREEN.setBoolean(this.mStartFullscreen.isSelected());
        Settings.General.SERVER_RESTORE_ENABLED.setBoolean(this.mServerForRestore.isSelected());
        Settings.General.CAN_RECEIVE_PROTOCOL_MESSAGE.setBoolean(this.mServerForRestore.isSelected() && this.mProtocolHandler.isSelected());
        TVBrowser.updateLockGlobalToggle();
        if (this.mAutoChannelDownload.isSelected()) {
            Settings.General.AUTO_CHANNEL_UPDATE_PERIOD.setInt(((DayPeriod)this.mAutoChannelDownloadPeriod.getSelectedItem()).mDays);
        } else {
            Settings.General.AUTO_CHANNEL_UPDATE_PERIOD.setInt(-1);
        }
        Settings.General.AUTO_UPDATE_PRIME_TIME.setBoolean(this.mAutoDownloadPrimeTime.isSelected());
        if (this.mAutostart != null) {
            if (this.mAutostart.isSelected()) {
                if (!this.mLinkFileFile.isFile()) {
                    try {
                        this.createLink();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.mLinkFileFile.isFile()) {
                        this.mAutostart.setSelected(false);
                        JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("creationError", "Couldn't create autostart shortcut.\nMaybe your have not the right to write in the autostart directory."), Localizer.getLocalization("i18n_error"), 0);
                    }
                }
            } else if (this.mLinkFileFile.isFile() && !this.mLinkFileFile.delete()) {
                this.mAutostart.setSelected(true);
                JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("deletionError", "Couldn't delete autostart shortcut.\nMaybe your have not the right to write in the autostart directory."), LOCALIZER.msg("error", "Error"), 0);
            }
        }
        int inx = this.mAutoDownloadCombo.getSelectedIndex();
        if (!this.mAutoDownload.isSelected()) {
            Settings.General.AUTO_DOWNLOAD_TYPE.setString("never");
        } else if (inx == 0) {
            Settings.General.AUTO_DOWNLOAD_TYPE.setString("daily");
        } else if (inx == 1) {
            Settings.General.AUTO_DOWNLOAD_TYPE.setString("every3days");
        } else if (inx == 2) {
            Settings.General.AUTO_DOWNLOAD_TYPE.setString("weekly");
        }
        Settings.General.DOWNLOAD_DONE.setHidden(!this.mShowFinishDialog.isSelected());
        Settings.General.AUTO_DATA_DOWNLOAD_ENABLED.setBoolean(this.mRecurrentDownload.isSelected() && this.mAutoDownload.isSelected());
        Settings.General.ASK_FOR_AUTO_DOWNLOAD.setBoolean(this.mAskBeforeDownloadRadio.isSelected());
        PeriodItem periodItem = (PeriodItem)this.mAutoDownloadPeriodCB.getSelectedItem();
        Settings.General.AUTO_DOWNLOAD_PERIOD.setInt(periodItem.getDays());
        Settings.General.AUTO_DOWNLOAD_WAITING_TIME.setShort(((Integer)this.mAutoDownloadWaitingTimeSp.getValue()).shortValue());
        Settings.General.AUTO_DOWNLOAD_WAITING_ENABLED.setBoolean(this.mAutoDownloadWaitingTime.isSelected());
        Settings.General.NTP_TIME_CHECK.setBoolean(this.mDateCheck.isSelected());
        if (this.mOnlyMinimizeWhenWindowClosingChB != null) {
            boolean checked = this.mOnlyMinimizeWhenWindowClosingChB.isSelected();
            Settings.General.ONLY_MINIMIZE_WHEN_WINDOW_CLOSING.setBoolean(checked);
        }
        Settings.General.ASK_FOR_EXIT_CONFIRMATION.setHidden(!this.mAskForExitConfirmation.isSelected());
        Settings.General.JRE_UPDATE_ENABLED.setBoolean(this.mAutoJREUpdate.isSelected());
        Settings.General.INFORM_TEST_VERSIONS.setHidden(!this.mInformTestVersions.isSelected());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "document-properties", 16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("general", "General settings");
    }

    private JPanel createRefreshPanel() {
        EnhancedPanelBuilder refreshSettings = new EnhancedPanelBuilder(new FormLayout("5dlu, 9dlu, default, 3dlu, default, fill:3dlu:grow, 3dlu"));
        refreshSettings.addSeparatorRow(false, LOCALIZER.msg("titleRefresh", "Refresh"), 1, 6);
        this.mAutoDownload = new JCheckBox(LOCALIZER.msg("autoUpdate", "Automatically update TV listings"));
        this.mStartDownload = new JRadioButton(LOCALIZER.msg("onStartUp", "Only on TV-Browser startup"));
        this.mRecurrentDownload = new JRadioButton(LOCALIZER.msg("recurrent", "Recurrent"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mStartDownload);
        bg.add(this.mRecurrentDownload);
        refreshSettings.addRow(this.mAutoDownload, 2, 5);
        refreshSettings.addRow("3dlu, default", (Component)this.mStartDownload, 3, 4);
        refreshSettings.addRow(false, (Component)this.mRecurrentDownload, 3, 4);
        this.mAutoDownloadCombo = new JComboBox<String>(AUTO_DOWNLOAD_MSG_ARR);
        String dlType = Settings.General.AUTO_DOWNLOAD_TYPE.getString();
        if (dlType.equals("daily")) {
            this.mAutoDownloadCombo.setSelectedIndex(0);
        } else if (dlType.equals("every3days")) {
            this.mAutoDownloadCombo.setSelectedIndex(1);
        } else if (dlType.equals("weekly")) {
            this.mAutoDownloadCombo.setSelectedIndex(2);
        }
        EnhancedPanelBuilder panel = new EnhancedPanelBuilder(new FormLayout("10dlu, default, 3dlu, default"), "3dlu");
        this.mStartDownload.setSelected(!dlType.equals("never") && !Settings.General.AUTO_DATA_DOWNLOAD_ENABLED.getBoolean());
        this.mRecurrentDownload.setSelected(Settings.General.AUTO_DATA_DOWNLOAD_ENABLED.getBoolean());
        this.mAutoDownload.setSelected(this.mStartDownload.isSelected() || this.mRecurrentDownload.isSelected());
        this.mStartDownload.setSelected(!this.mAutoDownload.isSelected() || this.mStartDownload.isSelected());
        this.mStartDownload.setEnabled(this.mAutoDownload.isSelected());
        this.mRecurrentDownload.setEnabled(this.mAutoDownload.isSelected());
        this.mHowOften = new JLabel(LOCALIZER.msg("autoDownload.howOften", "How often?"));
        panel.addRow(false, (Component)this.mHowOften, 2);
        panel.add(this.mAutoDownloadCombo, 4);
        this.mAskBeforeDownloadRadio = new JRadioButton(LOCALIZER.msg("autoDownload.ask", "Ask before downloading"));
        this.mAutoDownloadPeriodCB = new JComboBox<PeriodItem>(PeriodItem.getPeriodItems());
        int autoDLPeriod = Settings.General.AUTO_DOWNLOAD_PERIOD.getInt();
        PeriodItem pi = new PeriodItem(autoDLPeriod);
        this.mAutoDownloadPeriodCB.setSelectedItem(pi);
        panel.addRowFull(this.mAskBeforeDownloadRadio, 2);
        this.mAskTimeRadio = new JRadioButton(LOCALIZER.msg("autoDownload.duration", "Automatically refresh for"));
        panel.addRow(this.mAskTimeRadio, 2);
        panel.add(this.mAutoDownloadPeriodCB, 4);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mAskBeforeDownloadRadio);
        group.add(this.mAskTimeRadio);
        this.mAskBeforeDownloadRadio.setSelected(Settings.General.ASK_FOR_AUTO_DOWNLOAD.getBoolean());
        this.mAskTimeRadio.setSelected(!Settings.General.ASK_FOR_AUTO_DOWNLOAD.getBoolean());
        this.mAutoDownloadWaitingTime = new JCheckBox(LOCALIZER.msg("autoDownload.waiting", "Delay auto update for"), Settings.General.AUTO_DOWNLOAD_WAITING_ENABLED.getBoolean());
        this.mAutoDownloadWaitingTimeSp = new JSpinner(new SpinnerNumberModel(Settings.General.AUTO_DOWNLOAD_WAITING_TIME.getShort(), 1, 300, 1));
        this.mSecondsLabel = new JLabel(LOCALIZER.msg("autoDownload.seconds", "seconds"));
        this.mAutoDownload.addItemListener(e -> this.setAutoDownloadEnabled(e.getStateChange() == 1));
        this.mAskBeforeDownloadRadio.addItemListener(e -> this.setAutoDownloadEnabled(this.mAutoDownload.isSelected()));
        this.mAskTimeRadio.addActionListener(e -> this.setAutoDownloadEnabled(this.mAskTimeRadio.isSelected()));
        this.mAutoDownloadWaitingTime.addItemListener(e -> this.mAutoDownloadWaitingTimeSp.setEnabled(e.getStateChange() == 1));
        EnhancedPanelBuilder waitingPanel = new EnhancedPanelBuilder(new FormLayout("default,2dlu,default,2dlu,default", "default"));
        waitingPanel.add(this.mAutoDownloadWaitingTime, 1);
        waitingPanel.add(this.mAutoDownloadWaitingTimeSp, 3);
        waitingPanel.add(this.mSecondsLabel, 5);
        panel.addRowFull("5dlu, default", (Component)waitingPanel.getPanel());
        refreshSettings.addRow("3dlu, default", (Component)panel.getPanel(), 3, 4);
        this.mAutoDownloadPrimeTime = new JCheckBox(LOCALIZER.msg("autoUpdatePrimeTime", "Daily auto update prime time data in the evening"));
        this.mAutoDownloadPrimeTime.setSelected(Settings.General.AUTO_UPDATE_PRIME_TIME.getBoolean());
        refreshSettings.addRow(false, (Component)this.mAutoDownloadPrimeTime, 2, 5);
        this.mDateCheck = new JCheckBox(LOCALIZER.msg("checkDate", "Check date via NTP if data download fails"));
        this.mDateCheck.setSelected(Settings.General.NTP_TIME_CHECK.getBoolean());
        refreshSettings.addRow(this.mDateCheck, 2, 5);
        this.mShowFinishDialog = new JCheckBox(LOCALIZER.msg("showFinishDialog", "Show dialog when update is done"));
        this.mShowFinishDialog.setSelected(!Settings.General.DOWNLOAD_DONE.isHidden());
        refreshSettings.addRow("3dlu, default", (Component)this.mShowFinishDialog, 2, 5);
        this.setAutoDownloadEnabled(this.mAutoDownload.isSelected());
        this.mAutoChannelDownload = new JCheckBox(LOCALIZER.msg("autoChannelUpdate", "Automatically update available channels"));
        this.mAutoChannelDownloadPeriod = new WideComboBox();
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(1));
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(7));
        this.mAutoChannelDownloadPeriod.addItem(VALUE_AUTO_CHANNEL_UPDATE_PERIOD_DEFAULT);
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(30));
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(61));
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(183));
        if (Settings.General.AUTO_CHANNEL_UPDATE_PERIOD.getInt() > -1) {
            this.mAutoChannelDownload.setSelected(true);
            this.mAutoChannelDownloadPeriod.setSelectedItem(new DayPeriod(Settings.General.AUTO_CHANNEL_UPDATE_PERIOD.getInt()));
        } else {
            this.mAutoChannelDownloadPeriod.setSelectedItem(VALUE_AUTO_CHANNEL_UPDATE_PERIOD_DEFAULT);
            this.mAutoChannelDownloadPeriod.setEnabled(false);
        }
        this.mAutoChannelDownload.addItemListener(e -> this.mAutoChannelDownloadPeriod.setEnabled(e.getStateChange() == 1));
        refreshSettings.addRow("10dlu,default", (Component)this.mAutoChannelDownload, 2, 5);
        refreshSettings.addRow("3dlu,default", this.mAutoChannelDownloadPeriod, 3);
        return refreshSettings.getPanel();
    }

    private void setAutoDownloadEnabled(boolean enabled) {
        this.mRecurrentDownload.setEnabled(enabled);
        this.mStartDownload.setEnabled(enabled);
        this.mAskBeforeDownloadRadio.setEnabled(enabled);
        this.mHowOften.setEnabled(enabled);
        this.mAutoDownloadCombo.setEnabled(enabled);
        this.mAskTimeRadio.setEnabled(enabled);
        this.mAutoDownloadWaitingTime.setEnabled(enabled);
        this.mAutoDownloadWaitingTimeSp.setEnabled(enabled && this.mAutoDownloadWaitingTime.isSelected());
        this.mSecondsLabel.setEnabled(enabled);
        enabled = !this.mAskBeforeDownloadRadio.isSelected() && enabled;
        this.mAutoDownloadPeriodCB.setEnabled(enabled);
    }

    private static final class DayPeriod {
        int mDays;

        DayPeriod(int days) {
            this.mDays = days;
        }

        public String toString() {
            return LOCALIZER.msg("autoChannelUpdate.every" + this.mDays + "days", "Every " + this.mDays + " days");
        }

        public boolean equals(Object obj) {
            if (obj instanceof DayPeriod) {
                return this.mDays == ((DayPeriod)obj).mDays;
            }
            return super.equals(obj);
        }
    }

    private static class LinkFile {
        private String mTarget;

        private LinkFile(File linkFile, File target, File icon, int iconIndex) throws IOException {
            RandomAccessFile write = new RandomAccessFile(linkFile, "rw");
            write.getChannel().truncate(0L);
            write.writeBytes("[InternetShortcut]\r\n");
            write.writeBytes("URL=" + target.getAbsoluteFile().toURI().toURL() + "\r\n");
            write.writeBytes("WorkingDirectory=" + target.getParent());
            if (icon != null && icon.isFile()) {
                write.writeBytes("\r\nIconFile=" + icon.getAbsolutePath() + "\r\n");
                write.writeBytes("IconIndex=" + iconIndex);
            }
            write.close();
        }

        public LinkFile(File linkFile) throws IOException {
            RandomAccessFile read = new RandomAccessFile(linkFile, "r");
            String line = null;
            while ((line = read.readLine()) != null) {
                if (!line.startsWith("URL")) continue;
                this.mTarget = line.substring(line.indexOf(":/") + 2);
            }
            read.close();
        }

        public boolean hasTarget(File file) {
            return new File(this.mTarget).equals(file);
        }
    }
}

