/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import devplugin.SettingsTab;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import util.i18n.Localizer;
import util.io.NetworkUtilities;
import util.ui.EnhancedPanelBuilder;

public class NetworkSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(NetworkSettingsTab.class);
    private JSpinner mConnectionTimeout;
    private JSpinner mNetworkCheckTimeout;
    private JCheckBox mConnectionTest;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder("5dlu, pref, 3dlu, 0dlu:grow");
        pb.border(Borders.DIALOG);
        pb.addParagraph(LOCALIZER.msg("connectionTestTitle", "Internet connection test"));
        this.mConnectionTest = new JCheckBox(LOCALIZER.msg("connectionTestText", "Internet connection test activated"), Settings.Network.INTERNET_CONNECTION_CHECK.getBoolean());
        pb.addRowFull(this.mConnectionTest, 2);
        this.mNetworkCheckTimeout = new JSpinner(new SpinnerNumberModel(Settings.Network.CHECK_TIMEOUT.getInt() / 1000, 10, 90, 5));
        pb.addRow(this.mNetworkCheckTimeout, 2);
        JLabel label = pb.labelAdd(LOCALIZER.msg("waitTime", "Seconds maximum waiting time for connection test"), 4);
        pb.addLabelRowFull(LOCALIZER.msg("sites", "Websites used for checking"), 2);
        JList<String> urlList = new JList<String>(NetworkUtilities.getConnectionCheckUrls());
        urlList.setEnabled(false);
        pb.addRowFull(new JScrollPane(urlList), 2);
        this.mConnectionTest.addItemListener(e -> {
            boolean enabled = e.getStateChange() == 1;
            this.mNetworkCheckTimeout.setEnabled(enabled);
            label.setEnabled(enabled);
        });
        this.mNetworkCheckTimeout.setEnabled(this.mConnectionTest.isSelected());
        label.setEnabled(this.mConnectionTest.isSelected());
        pb.addParagraph(LOCALIZER.msg("cancelTime", "Timeout for not responding connections"));
        this.mConnectionTimeout = new JSpinner(new SpinnerNumberModel(Settings.Network.DEFAULT_CONNECTION_TIMEOUT.getInt() / 1000, 5, 60, 5));
        pb.addRow(this.mConnectionTimeout, 2);
        pb.labelAdd(LOCALIZER.msg("seconds", "Seconds"), 4);
        return pb.getPanel();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("status", "network-transmit-receive", 16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Network");
    }

    @Override
    public void saveSettings() {
        Settings.Network.INTERNET_CONNECTION_CHECK.setBoolean(this.mConnectionTest.isSelected());
        Settings.Network.DEFAULT_CONNECTION_TIMEOUT.setInt((Integer)this.mConnectionTimeout.getValue() * 1000);
        Settings.Network.CHECK_TIMEOUT.setInt((Integer)this.mNetworkCheckTimeout.getValue() * 1000);
    }
}

