/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.settings.TrayImportantSettingsTab;
import tvbrowser.ui.settings.TrayNowSettingsTab;
import tvbrowser.ui.settings.TrayOnTimeSettingsTab;
import tvbrowser.ui.settings.TrayProgramsChannelsSettingsTab;
import tvbrowser.ui.settings.TraySoonSettingsTab;
import util.i18n.Localizer;
import util.misc.JavaVersion;
import util.misc.OperatingSystem;
import util.ui.EnhancedPanelBuilder;

public class TrayBaseSettingsTab
implements SettingsTab {
    protected static final Localizer LOCALIZER = Localizer.getLocalizerFor(TrayBaseSettingsTab.class);
    private JCheckBox mTrayIsEnabled;
    private JCheckBox mMinimizeToTrayChb;
    private JCheckBox mNowOnRestore;
    private JCheckBox mTrayIsAnialiasing;
    private boolean mOldState;
    private static boolean mIsEnabled = Settings.Tray.ENABLED.getBoolean();
    private JRadioButton mFilterAll;
    private JRadioButton mNoMarkedFiltering;
    private JRadioButton mNoFiltering;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder builder = new EnhancedPanelBuilder(new FormLayout("5dlu, 50dlu:grow, 5dlu"));
        builder.border(Borders.DIALOG);
        String msg = LOCALIZER.msg("trayIsEnabled", "Tray activated");
        this.mOldState = Settings.Tray.ENABLED.getBoolean();
        this.mTrayIsEnabled = new JCheckBox(msg, this.mOldState);
        msg = LOCALIZER.msg("minimizeToTray", "Minimize to Tray");
        boolean checked = Settings.Tray.MINIMIZE_TO.getBoolean();
        this.mMinimizeToTrayChb = new JCheckBox(msg, checked && this.mOldState);
        this.mMinimizeToTrayChb.setEnabled(this.mTrayIsEnabled.isSelected());
        msg = LOCALIZER.msg("nowOnDeIconify", "Jump to now when restoring application");
        checked = Settings.Tray.NOW_ON_RESTORE.getBoolean();
        this.mNowOnRestore = new JCheckBox(msg, checked);
        msg = LOCALIZER.msg("trayAntialiasing", "Antialiasing enabled");
        checked = Settings.Tray.ANTIALIASING.getBoolean();
        this.mTrayIsAnialiasing = new JCheckBox(msg, checked);
        if (System.getProperty("os.name").toLowerCase().startsWith("linux") && (JavaVersion.getVersion() < 7 || OperatingSystem.isKDE())) {
            this.mMinimizeToTrayChb.addActionListener(e -> {
                if (this.mMinimizeToTrayChb.isSelected()) {
                    JOptionPane.showMessageDialog(builder.getPanel(), LOCALIZER.msg("minimizeToTrayWarning", "This function might not work as expected on Unix systems like KDE or Gnome.\nSo it's recommended not to select this checkbox."), LOCALIZER.msg("warning", "Warning"), 2);
                }
            });
        }
        ButtonGroup filter = new ButtonGroup();
        msg = LOCALIZER.msg("trayFilterAll", "Filter all programs");
        this.mFilterAll = new JRadioButton(msg);
        msg = LOCALIZER.msg("trayFilterNotMarked", "Filter programs, if not marked");
        checked = Settings.Tray.FILTER_NOT_MARKED.getBoolean();
        this.mNoMarkedFiltering = new JRadioButton(msg, checked);
        msg = LOCALIZER.msg("trayFilterNot", "Don't filter programs");
        checked = Settings.Tray.FILTER_NOT.getBoolean();
        this.mNoFiltering = new JRadioButton(msg, checked);
        if (!this.mNoFiltering.isSelected() && !this.mNoMarkedFiltering.isSelected()) {
            this.mFilterAll.setSelected(true);
        }
        filter.add(this.mFilterAll);
        filter.add(this.mNoMarkedFiltering);
        filter.add(this.mNoFiltering);
        builder.addSeparatorRowFull(false, LOCALIZER.msg("basics", "Basic settings"));
        builder.addRow(this.mTrayIsEnabled, 2);
        builder.addRow(false, (Component)this.mTrayIsAnialiasing, 2);
        builder.addRow(false, (Component)this.mMinimizeToTrayChb, 2);
        builder.addParagraph(LOCALIZER.msg("filter", "Filter settings"));
        builder.addRow(this.mFilterAll, 2);
        builder.addRow(false, (Component)this.mNoMarkedFiltering, 2);
        builder.addRow(false, (Component)this.mNoFiltering, 2);
        this.mTrayIsEnabled.addActionListener(e -> {
            mIsEnabled = this.mTrayIsEnabled.isSelected();
            TrayImportantSettingsTab.setTrayIsEnabled(mIsEnabled);
            TrayNowSettingsTab.setTrayIsEnabled(mIsEnabled);
            TrayOnTimeSettingsTab.setTrayIsEnabled(mIsEnabled);
            TraySoonSettingsTab.setTrayIsEnabled(mIsEnabled);
            TrayProgramsChannelsSettingsTab.setTrayIsEnabled(mIsEnabled);
            this.mMinimizeToTrayChb.setEnabled(this.mTrayIsEnabled.isSelected());
            this.mNowOnRestore.setEnabled(this.mTrayIsEnabled.isSelected());
            this.mTrayIsAnialiasing.setEnabled(this.mTrayIsEnabled.isSelected());
            this.mFilterAll.setEnabled(this.mTrayIsEnabled.isSelected());
            this.mNoMarkedFiltering.setEnabled(this.mTrayIsEnabled.isSelected());
            this.mNoFiltering.setEnabled(this.mTrayIsEnabled.isSelected());
        });
        return builder.getPanel();
    }

    @Override
    public void saveSettings() {
        if (this.mTrayIsEnabled != null) {
            Settings.Tray.ENABLED.setBoolean(this.mTrayIsEnabled.isSelected());
            if (this.mTrayIsEnabled.isSelected() && !this.mOldState) {
                TVBrowser.loadTray();
            } else if (!this.mTrayIsEnabled.isSelected() && this.mOldState) {
                TVBrowser.removeTray();
            }
        }
        if (this.mMinimizeToTrayChb != null) {
            boolean checked = this.mMinimizeToTrayChb.isSelected() && this.mTrayIsEnabled.isSelected();
            Settings.Tray.MINIMIZE_TO.setBoolean(checked);
        }
        Settings.Tray.NOW_ON_RESTORE.setBoolean(this.mNowOnRestore.isSelected());
        Settings.Tray.ANTIALIASING.setBoolean(this.mTrayIsAnialiasing.isSelected());
        Settings.Tray.FILTER_NOT_MARKED.setBoolean(this.mNoMarkedFiltering.isSelected());
        Settings.Tray.FILTER_NOT.setBoolean(this.mNoFiltering.isSelected());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "document-properties", 16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Tray settings");
    }

    protected static boolean isTrayEnabled() {
        return mIsEnabled;
    }
}

