/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Channel;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.OrderChooser;
import util.ui.UiUtilities;

public class TrayProgramsChannelsSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = TrayBaseSettingsTab.LOCALIZER;
    private JCheckBox mUseUserChannels;
    private OrderChooser<Channel> mChannelOCh;
    private static boolean mTrayIsEnabled = Settings.Tray.ENABLED.getBoolean();
    private JLabel mSeparator1;
    private JSlider mChannelWidth;
    private String mHelpLinkText;
    private JEditorPane mHelpLabel;
    private static TrayProgramsChannelsSettingsTab mInstance;
    private static boolean mNow;
    private static boolean mSoon;
    private static boolean mOnTime;

    @Override
    public JPanel createSettingsPanel() {
        mInstance = this;
        EnhancedPanelBuilder builder = new EnhancedPanelBuilder(new FormLayout("5dlu,pref,2dlu,default,5dlu,pref,fill:default:grow,5dlu"));
        builder.border(Borders.DIALOG);
        try {
            this.mChannelWidth = new JSlider(0, 40, 150, Settings.Tray.Channels.WIDTH.getInt());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.mUseUserChannels = new JCheckBox(LOCALIZER.msg("userChannels", "Use user defined channels"), Settings.Tray.Channels.SPECIAL_USE.getBoolean());
        this.mUseUserChannels.setToolTipText(LOCALIZER.msg("userChannelsToolTip", "<html>If you select this you can choose the channels that will be used for<br><b>Programs at...</b> and <b>Now/Soon running programs</b>.<br>If this isn't selected the first 10 channels in default order will be used.</html>"));
        this.mChannelOCh = new OrderChooser<Channel>(Settings.Tray.Channels.SPECIAL.getChannelArray(), Settings.Channels.SUBSCRIBED.getChannelArray(), true);
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "The Tray is deactivated. To activate these settings activate the option <b>Tray activated</b> in the <a href=\"#link\">Tray Base settings</a>."), e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SettingsDialog.getInstance().showSettingsTab("#tray");
            }
        });
        this.mHelpLinkText = this.mHelpLabel.getText();
        this.mHelpLabel.setFont(this.mUseUserChannels.getFont());
        builder.addSeparatorRowFull(false, LOCALIZER.msg("channelColumnWidth", "Column with for channel name"));
        builder.addRow(this.mChannelWidth, 2);
        JLabel valueLabel = builder.labelAdd(String.valueOf(this.mChannelWidth.getValue()), 4);
        valueLabel.setHorizontalAlignment(4);
        Dimension dim = valueLabel.getPreferredSize();
        valueLabel.setPreferredSize(new Dimension(Sizes.dialogUnitXAsPixel((int)20, (Component)builder.getPanel()), dim.height));
        this.mChannelWidth.addChangeListener(e -> valueLabel.setText(String.valueOf(this.mChannelWidth.getValue())));
        JButton reset = new JButton(Localizer.getLocalization("i18n_default"));
        reset.addActionListener(e -> this.mChannelWidth.setValue(Settings.Tray.Channels.WIDTH.getDefault()));
        builder.add(reset, 6);
        JPanel c = (JPanel)builder.addParagraph(LOCALIZER.msg("channelsSeparator", "Which channels should be used for these displays?"));
        builder.addRowFull(this.mUseUserChannels, 2);
        builder.addRowFull("10dlu,fill:default:grow", this.mChannelOCh, 2);
        builder.addRowFull(this.mHelpLabel);
        this.mSeparator1 = (JLabel)c.getComponent(0);
        this.setEnabled(true);
        this.mUseUserChannels.addActionListener(e -> this.setEnabled(false));
        return builder.getPanel();
    }

    private String createHtml(Font font, String text) {
        return "<html><div style=\"color:#000000;font-family:" + font.getName() + "; font-size:" + font.getSize() + ";\">" + text + "</div></html>";
    }

    private void setEnabled(boolean trayStateChange) {
        if (!mTrayIsEnabled) {
            this.mHelpLabel.setVisible(true);
            this.mHelpLabel.setText(this.createHtml(this.mHelpLabel.getFont(), this.mHelpLinkText));
        } else if (!(mNow || mSoon || mOnTime)) {
            this.mHelpLabel.setVisible(true);
            this.mHelpLabel.setText(this.createHtml(this.mHelpLabel.getFont(), LOCALIZER.msg("helpPrograms", "<html>These settings are used only by the Now, Soon and At... programs. Enable at least one of that to enable these settings.</html>")));
        } else {
            this.mHelpLabel.setVisible(false);
        }
        if (trayStateChange) {
            this.mSeparator1.setEnabled(mTrayIsEnabled);
        }
        this.mUseUserChannels.setEnabled(mTrayIsEnabled && (mNow || mSoon || mOnTime));
        this.mChannelOCh.setEnabled(mTrayIsEnabled && this.mUseUserChannels.isSelected() && (mNow || mSoon || mOnTime));
    }

    @Override
    public void saveSettings() {
        Settings.Tray.Channels.SPECIAL_USE.setBoolean(this.mUseUserChannels.isSelected());
        List<Channel> order = this.mChannelOCh.getOrderList();
        Channel[] ch = new Channel[order.size()];
        if (!this.mUseUserChannels.isSelected()) {
            order.clear();
            Collections.addAll(order, Settings.Channels.SUBSCRIBED.getChannelArray());
            ch = new Channel[order.size() > 10 ? 10 : order.size()];
        }
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = order.get(i);
        }
        if (order != null) {
            Settings.Tray.Channels.SPECIAL.setChannelArray(ch);
        }
        if (this.mChannelWidth != null) {
            Settings.Tray.Channels.WIDTH.setInt(this.mChannelWidth.getValue());
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return Localizer.getLocalization("i18n_channels");
    }

    protected static void setTrayIsEnabled(boolean value) {
        mTrayIsEnabled = value;
        if (mInstance != null) {
            mInstance.setEnabled(true);
        }
    }

    protected static void setNowIsEnabled(boolean value) {
        mNow = value;
        if (mInstance != null) {
            mInstance.setEnabled(false);
        }
    }

    protected static void setSoonIsEnabled(boolean value) {
        mSoon = value;
        if (mInstance != null) {
            mInstance.setEnabled(false);
        }
    }

    protected static void setOnTimeIsEnabled(boolean value) {
        mOnTime = value;
        if (mInstance != null) {
            mInstance.setEnabled(false);
        }
    }

    static {
        mNow = Settings.Tray.Now.ENABLED.getBoolean();
        mSoon = Settings.Tray.Soon.ENABLED.getBoolean();
        mOnTime = Settings.Tray.OnTime.ENABLED.getBoolean();
    }
}

