/*
 * Decompiled with CFR 0.152.
 */
package tvdataservice;

import devplugin.Marker;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.MutableProgram;
import util.program.ProgramUtilities;

public class MarkedProgramsMap {
    private static final Integer[] EMPTY = new Integer[0];
    private static MarkedProgramsMap mInstance;
    private final Map<String, MarkedHolder> mMarkedMap = Collections.synchronizedMap(new HashMap());
    private Thread mProgramTableRefreshThread;
    private int mProgramTableRefreshThreadWaitTime;

    private MarkedProgramsMap() {
    }

    public static MarkedProgramsMap getInstance() {
        if (mInstance == null) {
            mInstance = new MarkedProgramsMap();
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setMarkerForProgram(Program p, Marker[] markerArr) {
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            MarkedHolder markedHolder = this.mMarkedMap.get(p.getUniqueID());
            if (markedHolder == null) {
                markedHolder = new MarkedHolder(p);
                this.mMarkedMap.put(p.getUniqueID(), markedHolder);
            }
            markedHolder.setMarkerArr(markerArr);
            this.handleFilterMarking(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addMarkerForProgram(Program p, Marker marker) {
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            MarkedHolder markedHolder = this.mMarkedMap.get(p.getUniqueID());
            if (markedHolder == null) {
                markedHolder = new MarkedHolder(p);
                this.mMarkedMap.put(p.getUniqueID(), markedHolder);
            }
            markedHolder.addMarker(marker);
            this.handleFilterMarking(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeMarkerForProgram(Program p, Marker marker) {
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            MarkedHolder markedHolder = this.mMarkedMap.get(p.getUniqueID());
            if (markedHolder != null) {
                boolean removed = markedHolder.removeMarker(marker);
                if (removed) {
                    this.mMarkedMap.remove(p.getUniqueID());
                }
                this.handleFilterMarking(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Marker[] getMarkerForProgram(Program p) {
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            MarkedHolder markedHolder = this.mMarkedMap.get(p.getUniqueID());
            if (markedHolder != null) {
                return markedHolder.getMarkerArr();
            }
        }
        return MutableProgram.EMPTY_MARKER_ARR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMarkPriorityForProgram(Program p, int markPriority) {
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            MarkedHolder markedHolder = this.mMarkedMap.get(p.getUniqueID());
            if (markedHolder != null) {
                markedHolder.setMarkPriority(markPriority);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMarkPriorityMaxForProgram(Program p) {
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            MarkedHolder markedHolder = this.mMarkedMap.get(p.getUniqueID());
            if (markedHolder != null) {
                return markedHolder.getMarkPriorityMax();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer[] getMarkPrioritesForProgram(Program p) {
        Integer[] result = null;
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            MarkedHolder markedHolder = this.mMarkedMap.get(p.getUniqueID());
            if (markedHolder != null) {
                result = markedHolder.getMarkPriorities();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateMarkingForProgram(Program p) {
        boolean validated = false;
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            MarkedHolder markedHolder = this.mMarkedMap.get(p.getUniqueID());
            if (markedHolder != null) {
                markedHolder.validateMarking();
                validated = true;
            }
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revalidatePrograms() {
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            Iterator<MarkedHolder> markedHolderIterator = this.mMarkedMap.values().iterator();
            ArrayList<String> toRemoveKeys = new ArrayList<String>();
            while (markedHolderIterator.hasNext()) {
                MarkedHolder holder = markedHolderIterator.next();
                if (holder.validate()) continue;
                toRemoveKeys.add(holder.getCurrentProgramInstance().getUniqueID());
            }
            for (String key : toRemoveKeys) {
                this.mMarkedMap.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMarkings() {
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            for (String key : this.mMarkedMap.keySet()) {
                MarkedHolder marked = this.mMarkedMap.get(key);
                if (marked == null) continue;
                marked.validateMarking();
                if (marked.getCurrentProgramInstance() == null) continue;
                ((MutableProgram)marked.getCurrentProgramInstance()).fireStateChanged();
            }
        }
    }

    private void handleFilterMarking(Program p) {
        if (!(MainFrame.isStarting() || MainFrame.isShuttingDown() || PluginManagerImpl.getInstance().getFilterManager() == null || PluginManagerImpl.getInstance().getFilterManager().getCurrentFilter().equals(PluginManagerImpl.getInstance().getFilterManager().getDefaultFilter()))) {
            try {
                boolean contained = MainFrame.getInstance().getProgramTableModel().contains(p);
                boolean accepted = PluginManagerImpl.getInstance().getFilterManager().getCurrentFilter().accept(p);
                if (contained && !accepted || !contained && accepted) {
                    if (this.mProgramTableRefreshThread == null || !this.mProgramTableRefreshThread.isAlive()) {
                        this.mProgramTableRefreshThread = this.getProgramTableRefreshThread();
                        this.mProgramTableRefreshThread.start();
                    } else {
                        this.mProgramTableRefreshThreadWaitTime = 500;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Thread getProgramTableRefreshThread() {
        this.mProgramTableRefreshThreadWaitTime = 500;
        return new Thread("Program table refresh"){

            @Override
            public void run() {
                while (MarkedProgramsMap.this.mProgramTableRefreshThreadWaitTime > 0) {
                    try {
                        1.sleep(100L);
                        MarkedProgramsMap.this.mProgramTableRefreshThreadWaitTime -= 100;
                    }
                    catch (Exception exception) {}
                }
                SwingUtilities.invokeLater(() -> MainFrame.getInstance().getProgramTableModel().updateTableContent());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program[] getMarkedPrograms() {
        Program[] p = null;
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            Iterator<MarkedHolder> markedHolderIterator = this.mMarkedMap.values().iterator();
            ArrayList<Program> markedList = new ArrayList<Program>();
            while (markedHolderIterator.hasNext()) {
                markedList.add(markedHolderIterator.next().getCurrentProgramInstance());
            }
            p = new Program[markedList.size()];
            markedList.toArray(p);
        }
        return p;
    }

    public Program[] getTimeSortedProgramsForTray(ProgramFilter filter, int markPriority, int numberOfPrograms, boolean includeOnAirPrograms) {
        return this.getTimeSortedProgramsForTray(filter, markPriority, numberOfPrograms, includeOnAirPrograms, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program[] getTimeSortedProgramsForTray(ProgramFilter filter, int markPriority, int numberOfPrograms, boolean includeOnAirPrograms, boolean useTrayFilterSettings, ArrayList<Program> excludePrograms) {
        List<Program> programs = new ArrayList();
        Map<String, MarkedHolder> map = this.mMarkedMap;
        synchronized (map) {
            Iterator<MarkedHolder> markedHolderIterator = this.mMarkedMap.values().iterator();
            while (markedHolderIterator.hasNext()) {
                boolean dontAccept;
                Program p = markedHolderIterator.next().getCurrentProgramInstance();
                boolean bl = dontAccept = !filter.accept(p);
                if (dontAccept && useTrayFilterSettings) {
                    boolean bl2 = dontAccept = !Settings.Tray.FILTER_NOT.getBoolean() && (!Settings.Tray.FILTER_NOT_MARKED.getBoolean() || p.getMarkerArr().length <= 0);
                }
                if (p.isOnAir() && !includeOnAirPrograms || p.isExpired() || dontAccept || p.getMarkPriorityMax() < markPriority) continue;
                programs.add(p);
            }
        }
        if (excludePrograms != null) {
            programs.removeAll(excludePrograms);
        }
        Collections.sort(programs, ProgramUtilities.getProgramComparator());
        int maxCount = Math.min(programs.size(), Settings.Tray.Important.SIZE.getInt());
        if (numberOfPrograms > 0) {
            maxCount = Math.min(maxCount, numberOfPrograms);
        }
        programs = programs.subList(0, maxCount);
        Collections.sort(programs, ProgramUtilities.getProgramComparator());
        return programs.toArray(new Program[programs.size()]);
    }

    private static final class MarkedHolder {
        private byte mMarkPriorityMax;
        private Program mCurrentProgramInstance;
        private HashSet<String> mMarkerIDs;
        private HashSet<Marker> mMarkerSet;
        private Hashtable<String, ArrayList<Integer>> mPriorityMap = new Hashtable();
        private Integer[] mMarkPriorities;
        private static final Comparator<Marker> MARKER_COMPARTOR = new Comparator<Marker>(){

            @Override
            public int compare(Marker o1, Marker o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };

        MarkedHolder(Program prog) {
            this.mCurrentProgramInstance = prog;
            this.mMarkPriorityMax = (byte)-1;
            this.mMarkerIDs = new HashSet(0);
            this.mMarkerSet = new HashSet(0);
            this.mMarkPriorities = EMPTY;
        }

        synchronized void addMarker(Marker marker) {
            PluginProxy proxy;
            if (this.mMarkerIDs.contains(marker.getId())) {
                return;
            }
            this.mMarkerIDs.add(marker.getId());
            this.mMarkerSet.add(marker);
            this.handleMarkerPriorities(marker);
            this.mMarkPriorities = this.fillMarkPriorities();
            if (!(!(marker instanceof PluginProxy) || (proxy = (PluginProxy)marker).canUseProgramTree() && !proxy.hasArtificialPluginTree() || proxy.getArtificialRootNode() != null && proxy.getArtificialRootNode().size() >= 100)) {
                proxy.addToArtificialPluginTree((MutableProgram)this.mCurrentProgramInstance);
            }
        }

        private synchronized void handleMarkerPriorities(Marker marker) {
            int[] priorities = marker.getMarkPrioritiesForProgram(this.mCurrentProgramInstance);
            if (priorities == null || priorities.length == 0) {
                priorities = new int[]{marker.getMarkPriorityMaxForProgram(this.mCurrentProgramInstance)};
            }
            Arrays.sort(priorities);
            this.mMarkPriorityMax = (byte)Math.max(this.mMarkPriorityMax, priorities[priorities.length - 1]);
            ArrayList<Integer> list = this.mPriorityMap.get(marker.getId());
            if (list == null) {
                list = new ArrayList();
                this.mPriorityMap.put(marker.getId(), list);
            }
            for (int priority : priorities) {
                if (list.contains(priority)) continue;
                list.add(priority);
            }
        }

        synchronized boolean removeMarker(Marker marker) {
            HashSet<Marker> newSet = new HashSet<Marker>();
            this.mMarkPriorityMax = (byte)-1;
            for (Marker test : this.mMarkerSet) {
                PluginProxy proxy;
                if (test == null || test.getId().equals(marker.getId())) continue;
                newSet.add(test);
                this.mMarkPriorityMax = (byte)Math.max(this.mMarkPriorityMax, test.getMarkPriorityMaxForProgram(this.mCurrentProgramInstance));
                if (!(marker instanceof PluginProxy) || !(proxy = (PluginProxy)marker).hasArtificialPluginTree() || proxy.getArtificialRootNode().size() >= 100) continue;
                proxy.getArtificialRootNode().removeProgram(this.mCurrentProgramInstance);
            }
            this.mMarkerIDs.remove(marker.getId());
            this.mPriorityMap.remove(marker.getId());
            this.mMarkerSet.clear();
            this.mMarkerSet = newSet;
            this.mMarkPriorities = this.fillMarkPriorities();
            return this.isEmpty();
        }

        synchronized void setMarkerArr(Marker[] marker) {
            this.mMarkerIDs.clear();
            this.mMarkerSet.clear();
            this.mMarkPriorityMax = (byte)-1;
            for (Marker test : marker) {
                if (test == null) continue;
                this.mMarkerIDs.add(test.getId());
                this.mMarkerSet.add(test);
                this.handleMarkerPriorities(test);
            }
            this.mMarkPriorities = this.fillMarkPriorities();
        }

        synchronized void setMarkPriority(int markPriority) {
            this.mMarkPriorityMax = (byte)markPriority;
        }

        int getMarkPriorityMax() {
            return this.mMarkPriorityMax;
        }

        Integer[] getMarkPriorities() {
            return this.mMarkPriorities;
        }

        private Integer[] fillMarkPriorities() {
            Collection<ArrayList<Integer>> values = this.mPriorityMap.values();
            ArrayList result = new ArrayList();
            if (values != null && !values.isEmpty()) {
                values.forEach(value -> {
                    for (Integer test : value) {
                        if (result.contains(test)) continue;
                        result.add(test);
                    }
                });
            }
            Collections.sort(result);
            return result.toArray(new Integer[0]);
        }

        Marker[] getMarkerArr() {
            Marker[] markerArr = this.mMarkerSet.toArray(new Marker[this.mMarkerSet.size()]);
            Arrays.sort(markerArr, MARKER_COMPARTOR);
            return markerArr;
        }

        boolean isEmpty() {
            return this.mMarkerSet == null || this.mMarkerSet.isEmpty();
        }

        synchronized void validateMarking() {
            this.mMarkPriorityMax = (byte)-1;
            this.mPriorityMap.clear();
            for (Marker mark : this.mMarkerSet) {
                if (mark == null) continue;
                this.handleMarkerPriorities(mark);
            }
            this.mMarkPriorities = this.fillMarkPriorities();
        }

        Program getCurrentProgramInstance() {
            return this.mCurrentProgramInstance;
        }

        synchronized boolean validate() {
            MutableProgram check = this.checkProgram((MutableProgram)this.mCurrentProgramInstance, PluginManagerImpl.getInstance().getPrograms(this.mCurrentProgramInstance.getDate(), this.mCurrentProgramInstance.getID()));
            if (check != null) {
                this.mCurrentProgramInstance = check;
                return true;
            }
            return false;
        }

        private MutableProgram checkProgram(MutableProgram programInList, Program[] testProgs) {
            boolean titleWasChangedToMuch = false;
            MutableProgram testProg = null;
            if (testProgs != null && testProgs.length > 0) {
                testProg = (MutableProgram)testProgs[0];
                if (testProgs.length > 1) {
                    for (Program prog : testProgs) {
                        String[] titleParts = programInList.getTitle().toLowerCase().replaceAll("\\p{Punct}", " ").replaceAll("\\s+", " ").split(" ");
                        String compareTitle = prog.getTitle().toLowerCase();
                        boolean found = true;
                        for (String titlePart : titleParts) {
                            if (compareTitle.indexOf(titlePart) != -1) continue;
                            found = false;
                            break;
                        }
                        if (!found) continue;
                        testProg = (MutableProgram)prog;
                        break;
                    }
                }
            }
            if (testProg != null && testProg.getTitle() != null && programInList.getTitle() != null && programInList.getTitle().toLowerCase().compareTo(testProg.getTitle().toLowerCase()) != 0) {
                String[] titleParts = programInList.getTitle().toLowerCase().replaceAll("\\p{Punct}", " ").replaceAll("\\s+", " ").split(" ");
                String compareTitle = testProg.getTitle().toLowerCase();
                for (String titlePart : titleParts) {
                    if (compareTitle.indexOf(titlePart) != -1) continue;
                    titleWasChangedToMuch = true;
                    break;
                }
            }
            if (testProg != null && !titleWasChangedToMuch) {
                if (testProg != programInList) {
                    programInList.setProgramState(1);
                    return testProg;
                }
                return programInList;
            }
            programInList.setProgramState(2);
            return null;
        }
    }
}

